ITK Release 2.6
===============

This release covers the period December 1, 2005 through March 11, 2006.

Schedule
--------

  Release Number                   Start Date         End Date
  -------------------------------- ------------------ ------------------
  Last period for adding classes   January 15 2006    February 11 2006
  Feature freeze                   February 12 2006   February 26 2006
  CVS Tagging                      March 11, 2006     March 11, 2006
  Testing tarballs                 March 11, 2006     March 13, 2006
  Posting tarballs                 March 14 2006      March 14 2006

New Classes in this Release
---------------------------

    Code/Algorithms/itkBayesianClassifierInitializationImageFilter

    Code/BasicFilters/itkInvertIntensityImageFilter
    Code/BasicFilters/itkModulusImageFilter
    Code/BasicFilters/itkMorphologicalGradientImageFilter

    Code/Common/itkCovariantVector
    Code/Common/itkSumOfSquaresImageFunction

    Code/Review/CMakeLists.txt
    Code/Review/itkThresholdMaximumConnectedComponentsImageFilter
    Code/Review/README.txt

New Tests in this Release
-------------------------

    Testing/Code/Common/itkMeshSourceGraftOutputTest
    Testing/Code/Common/itkTransformsSetParametersTest

    Testing/Code/BasicFilters/itkInvertIntensityImageFilterTest
    Testing/Code/BasicFilters/itkMaskNeighborhoodOperatorImageFilterTest
    Testing/Code/BasicFilters/itkMatrixIndexSelectionImageFilterTest
    Testing/Code/BasicFilters/itkModulusImageFilterTest
    Testing/Code/BasicFilters/itkMorphologicalGradientImageFilterTest
    Testing/Code/BasicFilters/itkNotImageFilterTest
    Testing/Code/BasicFilters/itkPushPopTileImageFilterTest
    Testing/Code/BasicFilters/itkTernaryMagnitudeSquaredImageFilterTest
    Testing/Code/BasicFilters/itkVectorConnectedComponentImageFilterTest

    Testing/Code/IO/itkRawImageIOTest5

    Testing/Code/Numerics/NeuralNetworks/itkNeuralNetworkTests3

    Testing/Code/Review/CMakeLists.txt
    Testing/Code/Review/itkReviewHeaderTest
    Testing/Code/Review/itkReviewPrintTest
    Testing/Code/Review/itkReviewTests
    Testing/Code/Review/itkThresholdMaximumConnectedComponentsImageFilterTest
    Testing/Code/Review/README.txt

New Examples in this Release
----------------------------


    Examples/Filtering/FilteringExamples8

    Examples/IO/ImageReadExtractFilterInsertWrite

    Examples/Statistics/BayesianClassifier
    Examples/Statistics/BayesianClassifierInitializer
    Examples/Statistics/StatisticsExamplesTests4

New Utilities in this Release
-----------------------------

    Utilities/Dart/NewSince.csh.in
    Utilities/Dart/NewSince.gawk
    Utilities/Doxygen/cvsVersionFilter.
    Utilities/gdcm/CMake/CTestCustom.ctest.in
    Utilities/gdcm/CMake/FindRsync.cmake
    Utilities/gdcm/Dicts/ACUSON.d
    Utilities/gdcm/Dicts/DictGroupName.d
    Utilities/gdcm/Dicts/ELSCINT.d
    Utilities/gdcm/Dicts/gdcm.dic.in
    Utilities/gdcm/Dicts/GE-EchoPAC.d
    Utilities/gdcm/Dicts/GEMS-Advance.d
    Utilities/gdcm/Dicts/GEMS-Advantx.d
    Utilities/gdcm/Dicts/GEMS-CR.d
    Utilities/gdcm/Dicts/GEMS.d
    Utilities/gdcm/Dicts/GEMS-DLX.d
    Utilities/gdcm/Dicts/GEMS-Genie.d
    Utilities/gdcm/Dicts/GEMS-HiSpeed.d
    Utilities/gdcm/Dicts/GEMS-Infinia.d
    Utilities/gdcm/Dicts/HITACHI-MR-pronto.d
    Utilities/gdcm/Dicts/NIH.d
    Utilities/gdcm/Dicts/Papyrus.d
    Utilities/gdcm/Dicts/ParseDict.py
    Utilities/gdcm/Dicts/PHILIPS-EasyVision.d
    Utilities/gdcm/Dicts/PHILIPS-Intera.d
    Utilities/gdcm/Dicts/SIEMENS.d
    Utilities/gdcm/Dicts/SIEMENS-syngo.d
    Utilities/gdcm/Dicts/SPI.d
    Utilities/gdcm/src/gdcmArgMgr
    Utilities/gdcm/src/gdcmDicomDirVisit
    Utilities/gdcm/src/gdcmDictGroupName
    Utilities/gdcm/src/gdcmMpeg
    Utilities/gdcm/src/gdcmValidator
    Utilities/kwsys/DynamicLoader
    Utilities/kwsys/DynamicLoader.hxx.in
    Utilities/kwsys/String.hxx.in
    Utilities/kwsys/testDynamicLoader
    Utilities/kwsys/testDynload
    Utilities/openjpeg/bio
    Utilities/openjpeg/cio
    Utilities/openjpeg/CMakeLists.txt
    Utilities/openjpeg/dwt
    Utilities/openjpeg/event
    Utilities/openjpeg/fix
    Utilities/openjpeg/image
    Utilities/openjpeg/int
    Utilities/openjpeg/j2k
    Utilities/openjpeg/j2k_lib
    Utilities/openjpeg/jp2
    Utilities/openjpeg/jpt
    Utilities/openjpeg/mct
    Utilities/openjpeg/mqc
    Utilities/openjpeg/.NoDartCoverage
    Utilities/openjpeg/openjpeg
    Utilities/openjpeg/opj_includes
    Utilities/openjpeg/pi
    Utilities/openjpeg/raw
    Utilities/openjpeg/README.ITK.txt
    Utilities/openjpeg/t1
    Utilities/openjpeg/t2
    Utilities/openjpeg/tcd
    Utilities/openjpeg/tgt

Changes in this Release
-----------------------


    CMakeLists.txt
        ENH: ExceptionObject now reports method name.

    itkConfigure.h.in
        ENH: ExceptionObject now reports method name.

    itkIncludeDirectories.cmake
        BUG: expat is installed, but ITK_INCLUDE_DIRS fail to report so, therefore any external projects trying to use an installed ITK will fail as soon as a file like itkXMLFile.h is included (it requires expat.h).

    CMake/CheckCPPDirective.cmake

        ENH: ExceptionObject now reports method name.

    CMake/CheckCPPDirectiveExists.cxx.in
        ENH: better Borland support.

    CMake/InsightValgrind.supp
        ENH: Valgrind suppressions with libstdc++.so.6

    Code/CMakeLists.txt

    Code/Algorithms/itkBayesianClassifierImageFilter
        STYLE: Add NAMIC attribution
        COMP: Stupid error. Calling things from typedef prior to declaring
        COMP: Borland issues. Use the GetStaticConstMacro to fetch Dimension

    Code/Algorithms/itkBayesianClassifierImageFilter
        STYLE: indentation.

    Code/Algorithms/itkBayesianClassifierInitializationImageFilter
        STYLE: Add NAMIC attribution
        COMP: Borland issues. Use the GetStaticConstMacro to fetch Dimension

    Code/Algorithms/itkBayesianClassifierInitializationImageFilter
        COMP: cannot assign a T to a Vector< T, 1 > on VS6 apparently
        ENH: VS typename issues.
        ENH: Filter to initialize the bayesian classifer filter with a membership image

    Code/Algorithms/itkBinaryMedialNodeMetric
        ENH: Move include from header to implementation

    Code/Algorithms/itkBinaryMedialNodeMetr
        ENH: Move include from header to implementation

    Code/Algorithms/itkBioCell
        STYLE: Some style cleanup

    Code/Algorithms/itkBioCell
        STYLE: Some style cleanup

    Code/Algorithms/itkBioCellBase
        STYLE: Some style cleanup

    Code/Algorithms/itkBioCellularAggregate
        STYLE: Some style cleanup

    Code/Algorithms/itkBioCellularAggregate
        STYLE: Some style cleanup

    Code/Algorithms/itkBioCellularAggregateBase
        STYLE: Some style cleanup

    Code/Algorithms/itkBioGenome
        STYLE: Some style cleanup

    Code/Algorithms/itkClassifierBase
        STYLE: Some style cleanup

    Code/Algorithms/itkClassifierBase
        STYLE: Some style cleanup

    Code/Algorithms/itkCurvatureRegistrationFilter
        STYLE: Some style cleanup

    Code/Algorithms/itkDeformableSimplexMesh3DBalloonForceFilter
        STYLE: Some style cleanup

    Code/Algorithms/itkDeformableSimplexMesh3DBalloonForceFilter
        STYLE: Some style cleanup

    Code/Algorithms/itkDeformableSimplexMesh3DFilter
        STYLE: Some style cleanup

    Code/Algorithms/itkDeformableSimplexMesh3DFilter
        STYLE: Some style cleanup

    Code/Algorithms/itkDeformableSimplexMesh3DGradientConstraintForceFilter
        COMP: warnings.

    Code/Algorithms/itkFEMRegistrationFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/Algorithms/itkFastMarchingImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/Algorithms/itkGradientDifferenceImageToImageMetric
        BUG: #2543. BoundaryCondotion objects are now ivars.

    Code/Algorithms/itkGradientDifferenceImageToImageMetr
        BUG: removed debugging statements.

    Code/Algorithms/itkHistogramImageToImageMetr
        BUG: throw exception before checking derivate sizes.

    Code/Algorithms/itkHistogramMatchingImageFilter
        COMP:  Fixed typecasting to remove compiler warnings for all histogram image types.

    Code/Algorithms/itkImageGaussianModelEstimator
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/Algorithms/itkImageKmeansModelEstimator
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/Algorithms/itkImageRegistrationMethod
        COMP: some intel compilers have trouble with data allocated in the catch (apparently).

    Code/Algorithms/itkIsoContourDistanceImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/Algorithms/itkKappaStatisticImageToImageMetric

    Code/Algorithms/itkKappaStatisticImageToImageMetr

    Code/Algorithms/itkMIRegistrationFunction
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/Algorithms/itkMRFImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/Algorithms/itkMeanSquareRegistrationFunction
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/Algorithms/itkMinMaxCurvatureFlowFunction
        BUG: Fix compiler errors when non-double pixel types are used. See InsightJournal review for MATITK

    Code/Algorithms/itkMultiResolutionImageRegistrationMethod
    stl/Vector.html) VS8 has stricter checks and managed to catch the bug.

    Code/Algorithms/itkNCCRegistrationFunction
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/Algorithms/itkRayCastInterpolateImageFunction
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/Algorithms/itkRegularSphereMeshSource
        STYLE: Some style cleanup

    Code/Algorithms/itkRegularSphereMeshSource
        STYLE: Some style cleanup

    Code/Algorithms/itkStructHashFunction
        STYLE: Some style cleanup

    Code/Algorithms/itkVnlFFTRealToComplexConjugateImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/Algorithms/itkVoronoiSegmentationImageFilterBase
        BUG: compilation errors repaired.

    Code/Algorithms/itkVoronoiSegmentationImageFilterBase
        BUG: compilation errors repaired.

    Code/Algorithms/itkVoronoiSegmentationRGBImageFilter

    Code/BasicFilters/itkAbsImageFilter
        COMP: warnings about unused parameter.
        ENH: added operator==and operator!= methods.

    Code/BasicFilters/itkAbsoluteValueDifferenceImageFilter
        COMP: warnings about unused parameter.
        ENH: added operator==and operator!= methods.

    Code/BasicFilters/itkAccumulateImageFilter
        STYLE: indentation.

    Code/BasicFilters/itkAcosImageFilter
        COMP: warnings about unused parameter.
        ENH: added operator==and operator!= methods.

    Code/BasicFilters/itkAdaptImageFilter
        ENH: Added operator== and operator!=.

    Code/BasicFilters/itkAdaptiveHistogramEqualizationImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkAddImageFilter
        COMP: warnings about unused parameter.
        ENH: added operator==and operator!= methods.

    Code/BasicFilters/itkAndImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkAnisotropicDiffusionImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkAsinImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkAtan2ImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkAtanImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkBSplineCenteredL2ResampleImageFilterBase
        ENH: better Exception description.

    Code/BasicFilters/itkBSplineCenteredResampleImageFilterBase
        ENH: better Exception description.

    Code/BasicFilters/itkBSplineDecompositionImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkBSplineInterpolateImageFunction
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkBSplineL2ResampleImageFilterBase
        ENH: better Exception description.

    Code/BasicFilters/itkBSplineResampleImageFilterBase
        ENH: better Exception description.

    Code/BasicFilters/itkBilateralImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkBinaryErodeImageFilter
        STYLE: removed dummy variable access.

    Code/BasicFilters/itkBinaryFunctorImageFilter
        ENH: Added operator== and operator!=.

    Code/BasicFilters/itkBinaryMagnitudeImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkBinaryMedianImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkBinaryMorphologyImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkBinaryThresholdImageFilter
        ENH: Added operator== and operator!=.

    Code/BasicFilters/itkBloxBoundaryProfileImageToBloxCoreAtomImageFilter
        ENH: remove redundant dim parameter from itkBloxBoundaryProfileImageToBloxCoreAtomImageFilter

    Code/BasicFilters/itkBloxBoundaryProfileImageToBloxCoreAtomImageFilter
        ENH: remove redundant dim parameter from itkBloxBoundaryProfileImageToBloxCoreAtomImageFilter

    Code/BasicFilters/itkBoundedReciprocalImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkCastImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkChangeLabelImageFilter
        COMP: Fix for bug 2753: itkChangeLabelImageFilter.h -- ChangeLabel::SetChangeMap not const-correct.

    Code/BasicFilters/itkClosingByReconstructionImageFilter
        ENH: added flag to preserve original intesities.

    Code/BasicFilters/itkClosingByReconstructionImageFilter
        BUG: PrintSelf defect.

    Code/BasicFilters/itkComplexToImaginaryImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkComplexToModulusImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkComplexToPhaseImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkComplexToRealImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkCompose2DCovariantVectorImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkCompose2DVectorImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkCompose3DCovariantVectorImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkCompose3DVectorImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkComposeRGBImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkConfidenceConnectedImageFilter
        STYLE: Spelling

    Code/BasicFilters/itkConfidenceConnectedImageFilter
        ENH: Corrected several calculations and improved performance

    Code/BasicFilters/itkConnectedComponentFunctorImageFilter
        BUG: must use NumericTraits to compare to non-zero.

    Code/BasicFilters/itkConnectedComponentFunctorImageFilter
        BUG: bad logic introduced in last checkin.

    Code/BasicFilters/itkConnectedComponentImageFilter
        BUG: must use NumericTraits to compare to non-zero.

    Code/BasicFilters/itkConnectedComponentImageFilter
        BUG: must use NumericTraits to compare to non-zero.

    Code/BasicFilters/itkConstrainedValueAdditionImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkConstrainedValueDifferenceImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkCosImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkDeformationFieldJacobianDeterminantFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkDerivativeImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkDiffusionTensor3DReconstructionImageFilter
        BUG: Sorry Bill. Didn't realize that you had commited a fix. Revert to Bills fix.
        COMP: GetBValue is defined as a macro on windows. Need to undef it if present.
        ENH: Allow for the DW gradient images to be specified as a single multi-component image (vectorimage) or as several itk::Images. The former is a convenient input from nrrd format for DWI images

    Code/BasicFilters/itkDiffusionTensor3DReconstructionImageFilter
        BUG: uninitialized ivar.
        BUG: Check if container is null before printing it. (was causing print tests to segfault)

    Code/BasicFilters/itkDiscreteGaussianImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkDivideImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkEdgePotentialImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkExpImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkExpNegativeImageFilter
        ENH: Added operator== and operator!=.

    Code/BasicFilters/itkExtractImageFilter

    Code/BasicFilters/itkFastIncrementalBinaryDilateImageFilter
        BUG: missing include file for superclass.

    Code/BasicFilters/itkGetAverageSliceImageFilter
        ENH: this class is equivalent to AccumulateImageFilter with AveragingOn and a slightly different api. It is now a subclass of AccumulateImageFilter.

    Code/BasicFilters/itkGetAverageSliceImageFilter
        ENH: this class is equivalent to AccumulateImageFilter with AveragingOn and a slightly different api. It is now a subclass of AccumulateImageFilter.

    Code/BasicFilters/itkGradientImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkGradientMagnitudeImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkGradientToMagnitudeImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkGrayscaleGeodesicDilateImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkGrayscaleGeodesicErodeImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkHoughTransform2DLinesImageFilter

    Code/BasicFilters/itkIntensityWindowingImageFilter
        ENH: Added operator== and operator!=.

    Code/BasicFilters/itkInteriorExteriorMeshFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkInvertIntensityImageFilter
        ENH: new filters contributed by Gaetan Lehmann via the Insight Journal.

    Code/BasicFilters/itkInvertIntensityImageFilter
        ENH: new filters contributed by Gaetan Lehmann via the Insight Journal.

    Code/BasicFilters/itkIterativeInverseDeformationFieldImageFilter
        BUG: did not have progress. STYLE: did not have copyright. STYLE: indentation.

    Code/BasicFilters/itkJoinImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkJoinSeriesImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkLaplacianImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkLaplacianSharpeningImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/Attic/itkLazyEdgeDetectionImageFilter3D
        ENH: removed because it was a utility class for the removed class MidsagittalPlaneExtractionImageFilter.

    Code/BasicFilters/Attic/itkLazyEdgeDetectionImageFilter3D
        ENH: removed because it was a utility class for the removed class MidsagittalPlaneExtractionImageFilter.

    Code/BasicFilters/itkLog10ImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkLogImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkMaskImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkMaskNegatedImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkMaskNeighborhoodOperatorImageFilter

    Code/BasicFilters/itkMaskNeighborhoodOperatorImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkMatrixIndexSelectionImageFilter
        ENH: Added operator== and operator!=.

    Code/BasicFilters/itkMaximumImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkMeanImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkMedianImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkMinimumImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkModulusImageFilter
        ENH: new filters contributed by Gaetan Lehmann via the Insight Journal.

    Code/BasicFilters/itkModulusImageFilter
        ENH: new filters contributed by Gaetan Lehmann via the Insight Journal.

    Code/BasicFilters/itkMorphologicalGradientImageFilter
        ENH: new filters contributed by Gaetan Lehmann via the Insight Journal.

    Code/BasicFilters/itkMorphologicalGradientImageFilter
        ENH: new filters contributed by Gaetan Lehmann via the Insight Journal.

    Code/BasicFilters/itkMorphologyImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkMultiplyImageFilter
        COMP: warnings about unused parameter.
        ENH: added operator==and operator!= methods.

    Code/BasicFilters/itkNarrowBandImageFilterBase
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkNaryAddImageFilter
        ENH: Added operator== and operator!=.

    Code/BasicFilters/itkNaryMaximumImageFilter
        ENH: Added operator== and operator!=.

    Code/BasicFilters/itkNeighborhoodOperatorImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkNoiseImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkNormalizedCorrelationImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkNotImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkObjectMorphologyImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkOpeningByReconstructionImageFilter
        ENH: added flag to preserve original intesities.

    Code/BasicFilters/itkOpeningByReconstructionImageFilter
        ENH: added flag to preserve original intesities.

    Code/BasicFilters/itkOrImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkParallelSparseFieldLevelSetImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkPasteImageFilter

    Code/BasicFilters/itkPasteImageFilter
        BUG: type in type names.

    Code/BasicFilters/itkPermuteAxesImageFilter
        ENH: better Exception description.

    Code/BasicFilters/itkPolylineMask2DImageFilter
        STYLE: Beef up the documentation (Andinet)

    Code/BasicFilters/itkRGBToLuminanceImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkRecursiveSeparableImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkRegionOfInterestImageFilter
        BUG: output region was not being set correctly.

    Code/BasicFilters/itkRescaleIntensityImageFilter
        ENH: Added operator== and operator!=.

    Code/BasicFilters/itkScalarConnectedComponentImageFilter
        ENH: Added operator== and operator!=.

    Code/BasicFilters/itkShrinkImageFilter
        BUG: Bug # 2811 A second call of Update() causes InvalidRequesedRegion Error.

    Code/BasicFilters/itkShrinkImageFilter
        BUG: Bug # 2811 A second call of Update() function causes InvalidRequesedRegion Error.

    Code/BasicFilters/itkSigmoidImageFilter
        ENH: Added operator== and operator!=.

    Code/BasicFilters/itkSimpleContourExtractorImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkSimplexMeshAdaptTopologyFilter
        STYLE: Some style cleanup

    Code/BasicFilters/itkSimplexMeshAdaptTopologyFilter
        STYLE: Some style cleanup

    Code/BasicFilters/itkSinImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkSobelEdgeDetectionImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkSparseFieldLevelSetImageFilter
        BUG: Fix compiler errors when non-double pixel types are used. See InsightJournal review for MATITK

    Code/BasicFilters/itkSqrtImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkSquareImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkSquaredDifferenceImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkSubtractImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkSymmetricEigenAnalysisImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkTanImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkTensorFractionalAnisotropyImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkTensorRelativeAnisotropyImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkTernaryAddImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkTernaryFunctorImageFilter
        ENH: Added operator== and operator!=.

    Code/BasicFilters/itkTernaryMagnitudeImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkTernaryMagnitudeSquaredImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkThresholdLabelerImageFilter
        ENH: Added operator== and operator!=.

    Code/BasicFilters/itkTileImageFilter
        BUG: Improper region calculation for output.

    Code/BasicFilters/itkUnaryFunctorImageFilter
        ENH: Added operator== and operator!=.

    Code/BasicFilters/itkVectorCastImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkVectorConfidenceConnectedImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkVectorConnectedComponentImageFilter
        COMP: warnings about unused parameter.
        COMP: typename issues with VS6.

    Code/BasicFilters/itkVectorExpandImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkVectorGradientMagnitudeImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkVectorIndexSelectionCastImageFilter
        ENH: Added operator== and operator!=.

    Code/BasicFilters/itkVectorNeighborhoodOperatorImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkVectorResampleImageFilter
        ENH: Allow user to specify precision. STYLE: GetObject change to GetConstObject.
        ENH: follows same logic as ResampleImageFilter. BUG: was not setting directions on output.

    Code/BasicFilters/itkVectorResampleImageFilter
        COMP: Set threads to 1 if Borland.
        BUG: missing typedef. BUG: warnings.

    Code/BasicFilters/itkVectorRescaleIntensityImageFilter
        ENH: Added operator== and operator!=.

    Code/BasicFilters/itkVotingBinaryImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkVotingBinaryIterativeHoleFillingImageFilter
        STYLE: spelling.

    Code/BasicFilters/itkWeightedAddImageFilter
        ENH: added operator==and operator!= methods.

    Code/BasicFilters/itkXorImageFilter
        COMP: warnings about unused parameter.

    Code/BasicFilters/itkZeroCrossingBasedEdgeDetectionImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/BasicFilters/itkZeroCrossingImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/Common/CMakeLists.txt
        ENH: Adding CrossProduct for 3D.

    Code/Common/itkAnnulusOperator
        BUG: Incorrect define prevents Sobel include

    Code/Common/itkBSplineDerivativeKernelFunction
        STYLE: Some style cleanup

    Code/Common/itkBSplineInterpolationWeightFunction
        STYLE: Some style cleanup

    Code/Common/itkBSplineInterpolationWeightFunction
        STYLE: Some style cleanup

    Code/Common/itkBSplineKernelFunction
        STYLE: Some style cleanup

    Code/Common/itkBarrier

    Code/Common/itkBarrier

    Code/Common/itkBinaryBallStructuringElement
        STYLE: no need for itk:: withing itk namespace.

    Code/Common/itkBinaryThresholdImageFunction
        STYLE: Some style cleanup

    Code/Common/itkBinaryThresholdImageFunction
        STYLE: Some style cleanup

    Code/Common/itkBinaryThresholdSpatialFunction
        STYLE: Some style cleanup

    Code/Common/itkBloxBoundaryPointImage
        COMP: Move traits around for the sun compilers

    Code/Common/itkBloxBoundaryProfileItem
        STYLE: Some style cleanup

    Code/Common/itkBloxBoundaryProfileItem
        STYLE: Some style cleanup

    Code/Common/itkBloxImage
        COMP: Move traits around for the sun compilers

    Code/Common/itkBloxItem

    Code/Common/itkBluePixelAccessor
        ENH: Added operator== and operator!=.

    Code/Common/itkCenteredAffineTransform
        BUG: 2769. SetParameters() method was missing to invoke Modified().

    Code/Common/itkCenteredEuler3DTransform

    Code/Common/itkCenteredRigid2DTransform

        ENH: simplify modified time computation.
        BUG: was not setting modified times.

    Code/Common/itkCenteredSimilarity2DTransform

    Code/Common/itkCentralDifferenceImageFunction
        STYLE: Some style cleanup

    Code/Common/itkCentralDifferenceImageFunction
        STYLE: Some style cleanup

    Code/Common/itkChainCodePath
        STYLE: Some style cleanup

    Code/Common/itkChainCodePath2D
        STYLE: Some style cleanup

    Code/Common/itkChainCodePath2D
        STYLE: Some style cleanup

    Code/Common/itkConceptChecking
        STYLE: Some style cleanup

    Code/Common/itkConditionVariable
        STYLE: Some style cleanup

    Code/Common/itkConditionVariable
        STYLE: Some style cleanup

    Code/Common/itkCovarianceImageFunction
        STYLE: Some style cleanup

    Code/Common/itkCovarianceImageFunction
        STYLE: Some style cleanup

    Code/Common/itkCovariantVector
        ENH: Adding CrossProduct for 3D.

    Code/Common/itkCovariantVector
        COMP: warnings regarding placement of inline modifier.
        COMP: Keep vs60 happy
        COMP: Borland gets confused by a templated premultiply operator.. Force it to be a scalar of the same scalar type as the vector is templated over, so borland is now forced to recognize it as a scalar
        ENH: Adding CrossProduct for 3D.

    Code/Common/itkCovariantVector

    Code/Common/itkDataObject
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/Common/itkDataObject
        COMP: warnings.

    Code/Common/itkDirectory
        COMP: Fix compilation

    Code/Common/itkDirectory
        COMP: Fix compilation

    Code/Common/itkEuler3DTransform
        COMP: Warnings
        BUG: 2769. SetParameters() method was missing to invoke Modified().

    Code/Common/itkExceptionObject
        COMP: __FUNCTION__ is only valid within a function.

    Code/Common/itkExtrapolateImageFunction
        STYLE: Some style cleanup

    Code/Common/itkFastMutexLock
        ENH: Redo implementation of itkDirectory to use kwsys (avoid duplicating code). Also fix some minor style

    Code/Common/itkFiniteDifferenceImageFilter
        STYLE: doxygen cleanups

    Code/Common/itkFiniteDifferenceImageFilter
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/Common/itkFourierSeriesPath
        STYLE: Some style cleanup

    Code/Common/itkFourierSeriesPa
        STYLE: Some style cleanup

    Code/Common/itkFunctionBase
        STYLE: Some style cleanup

    Code/Common/itkGaussianBlurImageFunction
        STYLE: Some style cleanup

    Code/Common/itkGaussianBlurImageFunction
        STYLE: Some style cleanup

    Code/Common/itkGaussianDerivativeImageFunction
        STYLE: Some style cleanup

    Code/Common/itkGaussianDerivativeImageFunction
        STYLE: Some style cleanup

    Code/Common/itkGaussianKernelFunction
        STYLE: Some style cleanup

    Code/Common/itkGaussianOperator
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/Common/itkGreenPixelAccessor
        ENH: Added operator== and operator!=.

    Code/Common/itkHexahedronCell
        ENH: Added EvaluatePosition()

    Code/Common/itkHexahedronCell

        ENH: Added EvaluatePosition()

    Code/Common/itkImage
        COMP: Move traits around for the sun compilers

    Code/Common/itkImage
        COMP: warnings.

    Code/Common/itkImageAdaptor
        COMP: Move traits around for the sun compilers

    Code/Common/itkImageAdaptor

    Code/Common/itkImageBase
        COMP: Move traits around for the sun compilers

    Code/Common/itkImageBase
        COMP: warnings.

    Code/Common/itkImageConstIteratorWithIndex
        BUG: SetBegin should set the pointer to the begin of the buffer. was setting the one that pointed to the begin of the region instead

    Code/Common/itkImageFunction
        BUG: Wrong argument type was used for a continuous index output
        STYLE: Some style cleanup

    Code/Common/itkImageFunction
        STYLE: Some style cleanup

    Code/Common/itkImageRegionConstIterator
        COMP: Fix for bug 2781, wherein some copy constructors for imageRegion[Const]Iterator do not compile.

    Code/Common/itkImageRegionIterator
        COMP: Fix for bug 2781, wherein some copy constructors for imageRegion[Const]Iterator do not compile.

    Code/Common/itkImageRegionIterator
        COMP: Fix for bug 2781, wherein some copy constructors for imageRegion[Const]Iterator do not compile.

    Code/Common/itkImageSource

    Code/Common/itkImageSource

    Code/Common/itkImageToImageFilter
        BUG: un-hide methods from superclass

    Code/Common/itkImageToImageFilter

    Code/Common/itkImportImageContainer
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/Common/itkInterpolateImageFunction
        STYLE: Some style cleanup

    Code/Common/itkIterationReporter
        STYLE: Some style cleanup

    Code/Common/itkKLMSegmentationBorder
        STYLE: Some style cleanup

    Code/Common/itkKLMSegmentationBorder
        STYLE: Some style cleanup

    Code/Common/itkKLMSegmentationRegion
        STYLE: Some style cleanup

    Code/Common/itkKLMSegmentationRegion
        STYLE: Some style cleanup

    Code/Common/itkKernelFunction
        STYLE: Some style cleanup

    Code/Common/itkKernelTransform
        BUG: 2769. SetParameters() method was missing to invoke Modified().

    Code/Common/itkLandmarkBasedTransformInitializer
        BUG: bug 2632. Else check should have set angle to 90 degrees

    Code/Common/itkLevelSet
        STYLE: Some style cleanup

    Code/Common/itkLightObject
        STYLE: Some style cleanup

    Code/Common/itkLightObject
        STYLE: Some style cleanup

    Code/Common/itkLinearInterpolateImageFunction
        STYLE: Some style cleanup

    Code/Common/itkLinearInterpolateImageFunction
        STYLE: Some style cleanup

    Code/Common/itkLogOutput
        STYLE: Some style cleanup

    Code/Common/itkLogger
        STYLE: Some style cleanup

    Code/Common/itkLoggerBase
        STYLE: Some style cleanup

    Code/Common/itkLoggerManager
        STYLE: Some style cleanup

    Code/Common/itkLoggerThreadWrapper
        STYLE: Some style cleanup

    Code/Common/itkLoggerThreadWrapper
        BUG: Did not have blockers for includes.

    Code/Common/itkMacro
        BUG: cygwin does not have __FUNCSIG__.
        ENH: More descriptive ExceptionMacro.

    Code/Common/itkMahalanobisDistanceThresholdImageFunction
        STYLE: Some style cleanup

    Code/Common/itkMahalanobisDistanceThresholdImageFunction
        STYLE: Some style cleanup

    Code/Common/itkMapContainer

    Code/Common/itkMapContainer

    Code/Common/itkMatrixOffsetTransformBase
        BUG: 2769. SetParameters() method was missing to invoke Modified().

    Code/Common/itkMeanImageFunction
        STYLE: Some style cleanup

    Code/Common/itkMeanImageFunction
        STYLE: Some style cleanup

    Code/Common/itkMedianImageFunction
        STYLE: Some style cleanup

    Code/Common/itkMedianImageFunction
        STYLE: Some style cleanup

    Code/Common/itkMeshSource

    Code/Common/itkMeshSource

    Code/Common/itkMetaDataObject
        STYLE: Already within the itk namespace

    Code/Common/itkMultipleLogOutput
        STYLE: Some style cleanup

    Code/Common/itkNearestNeighborExtrapolateImageFunction
        STYLE: Some style cleanup

    Code/Common/itkNearestNeighborInterpolateImageFunction
        STYLE: Some style cleanup

    Code/Common/itkNeighborhoodBinaryThresholdImageFunction
        STYLE: Some style cleanup

    Code/Common/itkNeighborhoodBinaryThresholdImageFunction
        STYLE: Some style cleanup

    Code/Common/itkNeighborhoodIterator
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/Common/itkNeighborhoodOperatorImageFunction
        STYLE: Some style cleanup

    Code/Common/itkNeighborhoodOperatorImageFunction
        STYLE: Some style cleanup

    Code/Common/itkNumericTraitsCovariantVectorPixel
        STYLE: Some style cleanup

    Code/Common/itkNumericTraitsTensorPixel
        STYLE: Some style cleanup

    Code/Common/itkNumericTraitsVectorPixel
        STYLE: Some style cleanup

    Code/Common/itkObject
        STYLE: Some style cleanup

    Code/Common/itkOctree
        STYLE: Some style cleanup

    Code/Common/itkOctree
        STYLE: Some style cleanup

    Code/Common/itkOctreeNode
        STYLE: Some style cleanup

    Code/Common/itkOctreeNode
        STYLE: Some style cleanup

    Code/Common/itkOrientedImage
        COMP: Move traits around for the sun compilers

    Code/Common/itkPCAShapeSignedDistanceFunction
        STYLE: Some style cleanup

    Code/Common/itkPCAShapeSignedDistanceFunction
        STYLE: Some style cleanup

    Code/Common/itkParametricPa
        STYLE: Some style cleanup

    Code/Common/itkParametricPath
        STYLE: Some style cleanup

    Code/Common/itkPath
        ENH: Fix for bug 2918. Add PathDimension static constant to class.

    Code/Common/itkPa
        STYLE: Some style cleanup

    Code/Common/itkPathFunctions
        STYLE: Some style cleanup

    Code/Common/itkPathSource
        STYLE: Some style cleanup

    Code/Common/itkPathSource
        STYLE: Some style cleanup

    Code/Common/itkPathToPathFilter
        STYLE: Some style cleanup

    Code/Common/itkPathToPathFilter
        STYLE: Some style cleanup

    Code/Common/itkPhasedArray3DSpecialCoordinatesImage
        COMP: Move traits around for the sun compilers

    Code/Common/itkPointSet
        STYLE: Some style cleanup

    Code/Common/itkPolyLineParametricPath
        STYLE: Some style cleanup

    Code/Common/itkPolyLineParametricPa
        STYLE: Some style cleanup

    Code/Common/itkProcessObject

    Code/Common/itkProcessObject

    Code/Common/itkProgressReporter
        STYLE: Some style cleanup

    Code/Common/itkQuaternionRigidTransform
        BUG: 2769. SetParameters() method was missing to invoke Modified().

    Code/Common/itkRealTimeClock
        STYLE: Already within the itk namespace

    Code/Common/itkRedPixelAccessor
        ENH: Added operator== and operator!=.

    Code/Common/itkRigid2DTransform

        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/Common/itkRigid3DPerspectiveTransform

    Code/Common/itkScalarToRGBPixelFunctor
        STYLE: Some style cleanup

    Code/Common/itkScalarToRGBPixelFunctor
        STYLE: Some style cleanup

    Code/Common/itkScaleLogarithmicTransform
        BUG: 2769. SetParameters() method was missing to invoke Modified().

    Code/Common/itkScaleSkewVersor3DTransform

    Code/Common/itkScaleTransform
        BUG: 2769. SetParameters() method was missing to invoke Modified().

    Code/Common/itkScatterMatrixImageFunction
        STYLE: Some style cleanup

    Code/Common/itkScatterMatrixImageFunction
        STYLE: Some style cleanup

    Code/Common/itkSegmentationBorder
        STYLE: Some style cleanup

    Code/Common/itkSegmentationBorder
        STYLE: Some style cleanup

    Code/Common/itkSegmentationRegion
        STYLE: Some style cleanup

    Code/Common/itkSegmentationRegion
        STYLE: Some style cleanup

    Code/Common/itkSemaphore

    Code/Common/itkShapeSignedDistanceFunction
        STYLE: Some style cleanup

    Code/Common/itkSimilarity2DTransform

        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/Common/itkSimilarity3DTransform

    Code/Common/itkSimpleFastMutexLock
        ENH: Redo implementation of itkDirectory to use kwsys (avoid duplicating code). Also fix some minor style

    Code/Common/itkSimpleFilterWatcher
        ENH: Now uses TimeProbe.

    Code/Common/itkSimpleFilterWatcher
        STYLE: Some style cleanup

    Code/Common/itkSmartPointer
        ENH: Redo implementation of itkDirectory to use kwsys (avoid duplicating code). Also fix some minor style

    Code/Common/itkSmartPointerForwardReference
        ENH: Redo implementation of itkDirectory to use kwsys (avoid duplicating code). Also fix some minor style

    Code/Common/itkSmartPointerForwardReference
        ENH: Redo implementation of itkDirectory to use kwsys (avoid duplicating code). Also fix some minor style

    Code/Common/itkSparseImage
        COMP: Move traits around for the sun compilers

    Code/Common/itkSpecialCoordinatesImage
        COMP: Move traits around for the sun compilers

    Code/Common/itkSphereSignedDistanceFunction
        STYLE: Some style cleanup

    Code/Common/itkSphereSignedDistanceFunction
        STYLE: Some style cleanup

    Code/Common/itkStdStreamLogOutput
        STYLE: Some style cleanup

    Code/Common/itkSumOfSquaresImageFunction
        COMP: warnings,
        ENH: Function to calculate the sum of squares in a neighborhood

    Code/Common/itkSumOfSquaresImageFunction
        STYLE: Some style cleanup

    Code/Common/itkTestMain
        ENH: moved code into .h file.

    Code/Common/itkTetrahedronCell
        STYLE: indentation

    Code/Common/itkThreadLogger
        STYLE: Some style cleanup

    Code/Common/itkTimeProbe
        STYLE: Some style cleanup

    Code/Common/itkTranslationTransform
        STYLE: no need for this dereference.
        COMP: Type mismatch on method.

    Code/Common/itkTreeIteratorBase
        ENH: more consistent use of ExceptionMacro and ExceptionObject.

    Code/Common/itkVariableLengthVector
        ENH: Add GetSquaredNorm method to class
        ENH:  premultiplication with scalars

    Code/Common/itkVariableLengthVector
        ENH: Add GetSquaredNorm method to class

    Code/Common/itkVarianceImageFunction
        STYLE: Some style cleanup

    Code/Common/itkVarianceImageFunction
        STYLE: Some style cleanup

    Code/Common/itkVector
        COMP: warnings regarding placement of inline modifier.
        COMP: Borland gets confused by a templated premultiply operator.. Force it to be a scalar of the same scalar type as the vector is templated over, so borland is now forced to recognize it as a scalar
        ENH: Premultiply operator for product of scalar and a vector, from Casey Goodlett

    Code/Common/itkVector

    Code/Common/itkVectorContainer

    Code/Common/itkVectorContainer

    Code/Common/itkVectorImage
        STYLE: More documentation
        COMP: Move traits around for the sun compilers

    Code/Common/itkVectorImage

    Code/Common/itkVectorImageToImageAdaptor
        BUG: The vector image returns a pixel created on the stack, not a reference to a pixel
        COMP: Move traits around for the sun compilers

    Code/Common/itkVectorInterpolateImageFunction
        STYLE: Some style cleanup

    Code/Common/itkVectorLinearInterpolateImageFunction
        STYLE: Some style cleanup

    Code/Common/itkVectorLinearInterpolateImageFunction
        STYLE: Some style cleanup

    Code/Common/itkVectorMeanImageFunction
        STYLE: Some style cleanup

    Code/Common/itkVectorMeanImageFunction
        STYLE: Some style cleanup

    Code/Common/itkVectorNearestNeighborInterpolateImageFunction
        ENH: moved code into .h file.
        STYLE: Some style cleanup

    Code/Common/itkVectorNearestNeighborInterpolateImageFunction
    private/insight-developers/2006-February/007646.html
        STYLE: Some style cleanup

    Code/Common/itkVersor

    Code/Common/itkVersorRigid3DTransform

    Code/Common/itkVersorTransform

        ENH: Now invoking Modified() from SetIdentity().

    Code/Common/itkWindowedSincInterpolateImageFunction
        STYLE: Some style cleanup

    Code/Common/itkWindowedSincInterpolateImageFunction
        STYLE: Some style cleanup

    Code/IO/itkAnalyzeImageIO
        ENH: better exception reporting.

    Code/IO/itkBMPImageIO
        ENH: Better exception reporting.

    Code/IO/itkBrains2HeaderBase
        STYLE: Some style cleanup

    Code/IO/itkBrains2HeaderBase
        STYLE: Some style cleanup

    Code/IO/itkBrains2IPLHeaderInfo
        STYLE: Some style cleanup

    Code/IO/itkBrains2IPLHeaderInfo
        STYLE: Some style cleanup

    Code/IO/itkBrains2MaskHeaderInfo
        STYLE: Some style cleanup

    Code/IO/itkBrains2MaskHeaderInfo
        STYLE: Some style cleanup

    Code/IO/itkConvertPixelBuffer

    Code/IO/itkConvertPixelBuffer
        COMP: signed unsigned comparison warnings

    Code/IO/itkDefaultConvertPixelTraits
        COMP: Fix for bug 2725, which prevented compliation of IO using signed char traits on some compilers.

    Code/IO/itkGDCMImageIO
        BUG: When writting 3D images, it allowed to access the 3d component of the ITK Spacing.
        ENH: Provide an helper function around the MetaDataDictionary. Make it more user oriented.
        BUG: Do not propagate group length as computation is not done
        ENH: better exception reporting.
        STYLE: more consistent use of types.

    Code/IO/itkGDCMImageIO
        ENH: Provide an helper function around the MetaDataDictionary. Make it more user oriented.
        ENH: Bring AddRestriction from the gdcm level to the itkGDCM level. Update example to show usage, add more doc.

    Code/IO/itkGDCMSeriesFileNames
        ENH: Update gdcm version to 1.2

    Code/IO/itkGDCMSeriesFileNames
        ENH: Rename AddRestriction into AddSeriesRestriction

    Code/IO/itkGE4ImageIO
        STYLE: Some style cleanup

    Code/IO/itkGEImageHeader
        STYLE: Some style cleanup

    Code/IO/itkIPLCommonImageIO
        BUG: Report orientation in direction cosines

    Code/IO/itkIPLFileNameList
        STYLE: Some style cleanup

    Code/IO/itkImageFileReader
        ENH: Better exception reporting.
        ENH: Make DefaultConvertPixelTraits a trait of the image to make IO support of VectorImage consistent. Forward declare it so it doesn't increase parsing time.

    Code/IO/itkImageFileReader
        COMP: previous fix does not work for all pixel types... defer until its made correct
        ENH: Better exception reporting.

    Code/IO/itkImageFileWriter
        ENH: Better exception reporting.

    Code/IO/itkImageFileWriter
        ENH: better exception message.

    Code/IO/itkImageSeriesReader
        STYLE: minor style

    Code/IO/itkMetaImageIO
        BUG: Peter Cech found typo that produced incorrect index to physical transform for origin update with direction cosines.
        BUG: MetaIO now supports 64bit int on platforms having 64bit ints.  Thanks to help from Robert Atwood at imperial.ac.uk

    Code/IO/itkMetaImageIO
        COMP: fixed member object reference

    Code/IO/itkMvtSunf
        STYLE: Some style cleanup

    Code/IO/itkNiftiImageIO
        BUG: suppress nifti library error messages

    Code/IO/itkPNGImageIO
        COMP: VS71 issues with exception macro.
        ENH: better error messages

    Code/IO/itkRawImageIO

    Code/IO/itkTIFFImageIO
        BUG: Remove previous commit, while avoiding compiler warning

    Code/IO/itkVTKImageIO
        ENH: Use the kwsys lib instead

    Code/Numerics/Statistics/itkDenseFrequencyContainer
        BUG: Minor.. remove \#defines that were left when copied over from older txx code

    Code/Numerics/Statistics/itkDensityFunction
        BUG: Base and superclass had the same method and ivar. Bug 2880

    Code/Numerics/Statistics/itkMembershipFunctionBase
        BUG: Base and superclass had the same method and ivar. Bug 2880

    Code/Numerics/Statistics/itkSample
        BUG: Use traits to give a default length to the samples, so the user does not need to call SetMeasurementVectorSize( .. ) if TMeasurementVector is a FixedArray, Vector etc

    Code/Numerics/Statistics/itkSparseFrequencyContainer
        BUG: Minor.. remove \#defines that were left when copied over from older txx code

    Code/Review/CMakeLists.txt
        ENH: CMakeLists.txt file for the classes that are in the review process.

    Code/Review/README.txt
        STYLE: Notice regarding the purpose of this directory.

    Code/Review/itkThresholdMaximumConnectedComponentsImageFilter
        BUG: must use itkGetStaticConstMacro to access ImageDimension.
        COMP: "typename" keywords missing.

    Code/Review/itkThresholdMaximumConnectedComponentsImageFilter
        COMP: "typename" keywords missing.

    Code/SpatialObject/itkBlobSpatialObject
        COMP: Warnings

    Code/SpatialObject/itkLandmarkSpatialObject
        COMP: Warnings

    Code/SpatialObject/itkMetaMeshConverter
        BUG: Replaced SetElement() by InsertElement() so the array is allocated when using StaticMeshTrait
        BUG: the ID was not set when writing the mesh

    Code/SpatialObject/itkPolygonGroupOrientation
        STYLE: doxygen cleanups

    Code/SpatialObject/itkPolygonGroupSpatialObject
        STYLE: Some style cleanup

    Code/SpatialObject/itkPolygonSpatialObject
        STYLE: Some style cleanup

    Code/SpatialObject/itkSceneSpatialObject
        STYLE: Improved comments

    Code/SpatialObject/itkSceneSpatialObject
        STYLE: Improved comments

    Code/SpatialObject/itkSpatialObject
        STYLE: Make TreeNode getters and setters use itk[Get|Set]ObjectMacro. Also affects compilation of wrappers, so it is a COMP issue too.

    Code/SpatialObject/itkSpatialObject
        COMP: Warnings

    Code/SpatialObject/itkSpatialObjectTreeNode
        ENH: Added private (unimplemented) copy constructor and = operator (reported by Zach Pincus)

    Code/SpatialObject/itkSurfaceSpatialObject
        COMP: Warnings

    Code/SpatialObject/itkTubeSpatialObject
        STYLE: Better documentation

    Code/SpatialObject/itkTubeSpatialObject
        COMP: Warnings

    Documentation/Doxygen/DoxygenFooter.html
        BUG: The link to Doxygen Home page was broken. Bad html extension.

    Examples/Data/BayesianClassifierInitializerMemberships.mhd
        ENH: new example input data.

    Examples/Data/BayesianClassifierInitializerMemberships.raw
        ENH: new example input data.

    Examples/DataRepresentation/Image/CMakeLists.txt
        COMP: removed tests from Borland.

    Examples/Filtering/CMakeLists.txt
        COMP: Borland LME linker.
        COMP: Avoide borland LME1518 error.
        ENH: Test and Example for the DiffusionTensor3DReconstructionImageFilter, TensorFractionalAnisotropyImageFilter, TensorRelativeAnisotropyImageFilter
        COMP: removed tests to avoid Borland linker errors.

    Examples/Filtering/DiffusionTensor3DReconstructionImageFilter
        COMP: Unused var warnings

    Examples/Filtering/DigitallyReconstructedRadiograph1
        STYLE: Improving the coding style of the example.
        ENH: Replacing old style #define for PI with a const double computed at run time.

    Examples/Filtering/FilteringExamples
        COMP: removed tests to avoid Borland linker errors.

    Examples/Filtering/FilteringExamples5
        ENH: Test and Example for the DiffusionTensor3DReconstructionImageFilter, TensorFractionalAnisotropyImageFilter, TensorRelativeAnisotropyImageFilter

    Examples/Filtering/FilteringExamples8
        COMP: removed tests to avoid Borland linker errors.

    Examples/Filtering/ResampleImageFilter9
        BUG: default pixel should be of type PixelType.
        COMP: set threads to 1 to see if test passes on Borland.

    Examples/Filtering/SecondDerivativeRecursiveGaussianImageFilter
        STYLE: Shortening the error Usage line, so it fits the margins in the Software Guide.

    Examples/IO/CMakeLists.txt

    Examples/IO/DicomImageReadPrintTags
        ENH: Provide an helper function around the MetaDataDictionary. Make it more user oriented.

    Examples/IO/DicomSeriesReadImageWrite
        ENH: signed short is more general for medical images.

    Examples/IO/DicomSeriesReadImageWrite2
        ENH: Rename AddRestriction into AddSeriesRestriction

    Examples/IO/ImageReadExtractFilterInsertWrite

    Examples/IO/ImageReadWrite
        ENH: signed short is more general for medical images.

    Examples/Iterators/CMakeLists.txt
        COMP: Borland linker errors.
        COMP: removed tests to avoid Borland linker errors.

    Examples/Registration/CMakeLists.txt
        COMP: Borland cannot link.

    Examples/Registration/DeformableRegistration3
        STYLE: Adding Hypenation for index entries. Software Guide.

    Examples/Registration/ImageRegistration8
        STYLE: Adding hypenations to index entries. Software Guide.

    Examples/Registration/ModelToImageRegistration1
        STYLE: latex typesetting issues

    Examples/Registration/MultiResImageRegistration1
        BUG: The Example require at least three arguments, so argc must be >= 4.

    Examples/Registration/MultiResImageRegistration2
        STYLE: Latex documentation fixes

    Examples/SpatialObjects/SpatialObjectToImageStatisticsCalculator
        STYLE: Adding hypenation for index entries. Software Guide.

    Examples/Statistics/BayesianClassifier
        COMP: Move traits around for the sun compilers

    Examples/Statistics/BayesianClassifierInitializer
        ENH: Examples and tests for the itk::BayesianClassifierInitializationImageFilter and  itk::BayesianClassifierImageFilter

    Examples/Statistics/CMakeLists.txt
        COMP: Avoid Borland LME1518 linker errors.
        COMP: avoid borland linker errors.
        BUG: tests should never depend upon another test output.

    Examples/Statistics/ImageEntropy1
        COMP:  LaTeX formatting was causing a compiler warning.  Table new lines need to be represented with \cr instead of \

    Examples/Statistics/ImageHistogram1
        STYLE: Adding hypenation for index entries. Software Guide.

    Examples/Statistics/ImageHistogram2
        STYLE: Adding hypenation to index entries.  Software Guide.

    Examples/Statistics/ScalarImageKmeansClassifier
        COMP: Missing semicolon.

    Examples/Statistics/ScalarImageMarkovRandomField1
        STYLE: Reformatting long lines of code that don't fit in the Software Guide margins.

    Examples/Statistics/StatisticsExamplesTests4
        ENH: Examples and tests for the itk::BayesianClassifierInitializationImageFilter and  itk::BayesianClassifierImageFilter

    Testing/Code/CMakeLists.txt

    Testing/Code/Algorithms/CMakeLists.txt

    Testing/Code/Algorithms/itkAlgorithmsPrintTest3
        COMP: too much for the borland compiler to handle.

    Testing/Code/Algorithms/itkAlgorithmsTests4

    Testing/Code/Algorithms/Attic/itkBayesianClassifierImageFilterTest

    Testing/Code/Algorithms/itkGradientDifferenceImageToImageMetricTest
        ENH: Better range for metrix overlap testing.

    Testing/Code/BasicFilters/CMakeLists.txt
        ENH: new test
        ENH: new tests contributed by Gaetan Lehmann via the Insight Journal.
        ENH: added test for itkMatrixIndexSelectionImageFilter
        BUG: Tests should not rely on other test output.
        ENH: added optional difference image.
        ENH: new regression test.
        ENH: new regression test.

    Testing/Code/BasicFilters/itkAbsImageFilterAndAdaptorTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkAbsoluteValueDifferenceImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkAccumulateImageFilterTest
        ENH: better coverage.

    Testing/Code/BasicFilters/itkAcosImageFilterAndAdaptorTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkAdaptImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkAddImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkAndImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkAsinImageFilterAndAdaptorTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkAtanImageFilterAndAdaptorTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkBasicFiltersHeaderTest
        ENH: Added missing classes.

    Testing/Code/BasicFilters/itkBasicFiltersPrintTest
        ENH: remove redundant dim parameter from itkBloxBoundaryProfileImageToBloxCoreAtomImageFilter

    Testing/Code/BasicFilters/itkBasicFiltersTests2
        ENH: new test

    Testing/Code/BasicFilters/itkBasicFiltersTests4
        ENH: new tests contributed by Gaetan Lehmann via the Insight Journal.
        ENH: new test.
        ENH: new regression test.
        ENH: new regression test.

    Testing/Code/BasicFilters/itkBinaryDilateImageFilterTest2
        ENH: better coverage.

    Testing/Code/BasicFilters/itkBinaryMagnitudeImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkBinaryThresholdImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkBloxBoundaryProfileImageToBloxCoreAtomImageFilterTest
        ENH: remove redundant dim parameter from itkBloxBoundaryProfileImageToBloxCoreAtomImageFilter

    Testing/Code/BasicFilters/itkChangeLabelImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkClosingByReconstructionImageFilterTest
        ENH: new regression tests.
        BUG: StructuringElement was uninitialized.

    Testing/Code/BasicFilters/itkCompose2DCovariantVectorImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkCompose3DCovariantVectorImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkComposeRGBImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkConstrainedValueDifferenceImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkCosImageFilterAndAdaptorTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkDiffusionTensor3DReconstructionImageFilterTest
        STYLE: missing copyright.
        BUG: The filter normalizes the gradient directions when they are supplied now, this caused a slight precisoin issue. Although the gradient directions supplied with the test are almost of unit norm, the slight difference from 1 caused the failiure.

    Testing/Code/BasicFilters/itkDivideImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkEdgePotentialImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkExpImageFilterAndAdaptorTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkExpNegativeImageFilterAndAdaptorTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkGetAverageSliceImageFilterTest
        ENH: new regression test.

    Testing/Code/BasicFilters/itkGradientToMagnitudeImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkGrayscaleFillholeImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkIntensityWindowingImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkInvertIntensityImageFilterTest
        ENH: new tests contributed by Gaetan Lehmann via the Insight Journal.

    Testing/Code/BasicFilters/itkIterativeInverseDeformationFieldImageFilterTest
        BUG: did not exit with failure if exception occurred.

    Testing/Code/BasicFilters/itkJoinImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkJoinSeriesImageFilterTest
        BUG: tests should not depend on the text of the exception message.

    Testing/Code/BasicFilters/itkLog10ImageFilterAndAdaptorTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkLogImageFilterAndAdaptorTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkMaskConnectedComponentImageFilterTest
        BUG: type.

    Testing/Code/BasicFilters/itkMaskImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkMaskNegatedImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkMaskNeighborhoodOperatorImageFilterTest
        COMP: warnings.

    Testing/Code/BasicFilters/itkMatrixIndexSelectionImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkMaximumImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkMinimumImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkModulusImageFilterTest
        ENH: new tests contributed by Gaetan Lehmann via the Insight Journal.

    Testing/Code/BasicFilters/itkMorphologicalGradientImageFilterTest
        STYLE: missing copyright.

    Testing/Code/BasicFilters/itkMultiplyImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkNaryAddImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkNaryMaximumImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkNotImageFilterTest
        ENH: new test.

    Testing/Code/BasicFilters/itkOpeningByReconstructionImageFilterTest
        ENH: Added SimpleFilterWatcher.
        ENH: added optional difference image.
        ENH: new regression test.

    Testing/Code/BasicFilters/itkOrImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkPushPopTileImageFilterTest
        ENH: new test

    Testing/Code/BasicFilters/itkRGBToLuminanceImageFilterAndAdaptorTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkRecursiveGaussianImageFiltersOnTensorsTest
        STYLE: missing copyright.

    Testing/Code/BasicFilters/itkRegionOfInterestImageFilterTest
        ENH: Added filter watcher. Now uses OrientedImage.

    Testing/Code/BasicFilters/itkRescaleIntensityImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkScalarConnectedComponentImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkSigmoidImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkSinImageFilterAndAdaptorTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkSqrtImageFilterAndAdaptorTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkSquareImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkSquaredDifferenceImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkSubtractImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkSymmetricEigenAnalysisImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkTanImageFilterAndAdaptorTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkTensorFractionalAnisotropyImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkTensorRelativeAnisotropyImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkTernaryMagnitudeImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkTernaryMagnitudeSquaredImageFilterTest
        ENH: new test.

    Testing/Code/BasicFilters/itkThresholdLabelerImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkTileImageFilterTest
        ENH: now uses OrientedImage.

    Testing/Code/BasicFilters/itkVectorConnectedComponentImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkVectorRescaleIntensityImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkVotingBinaryIterativeHoleFillingImageFilterTest
        ENH: PrintSelf coverage.

    Testing/Code/BasicFilters/itkWeightedAddImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/BasicFilters/itkXorImageFilterTest
        ENH: Added operator== and operator!=.

    Testing/Code/Common/CMakeLists.txt
        BUG: 2769. SetParameters() are missing invocation of Modified().

    Testing/Code/Common/itkCommonTests2
        BUG: 2769. SetParameters() are missing invocation of Modified().

    Testing/Code/Common/itkCovariantVectorGeometryTest
        COMP: must use namespace on funciton call.

    Testing/Code/Common/itkEuler2DTransformTest

    Testing/Code/Common/itkMeshSourceGraftOutputTest
        ENH: added a test for graft output method in mesh source

    Testing/Code/Common/itkRealTimeClockTest
        ENH: rename GetTimestamp into GetTimeStamp

    Testing/Code/Common/itkTransformsSetParametersTest
        COMP: Remove warning
        BUG: 2769. SetParameters() are missing invocation of Modified().

    Testing/Code/Common/itkVectorImageTest
        ENH: Make DefaultConvertPixelTraits a trait of the image to make IO support of VectorImage consistent. Forward declare it so it doesn't increase parsing time.

    Testing/Code/Common/itkVersorTest

    Testing/Code/IO/CMakeLists.txt

    Testing/Code/IO/itkBMPImageIOTest
        ENH: better exception reporting.

    Testing/Code/IO/itkGDCMSeriesReadImageWrite
        ENH: Add more example on how to use restriction operation

    Testing/Code/IO/itkIOTests

    Testing/Code/IO/itkMeshSpatialObjectIOTest
        ENH: Now testing the ID of the MeshSpatialObject

    Testing/Code/IO/itkRawImageIOTest5
        ENH: Adding setup code for the RawImageIO object.

    Testing/Code/Numerics/NeuralNetworks/CMakeLists.txt
        COMP: avoid Borland linker errors.

    Testing/Code/Numerics/NeuralNetworks/itkNeuralNetworkTests
        COMP: avoid Borland linker errors.

    Testing/Code/Numerics/NeuralNetworks/itkNeuralNetworkTests3
        COMP: avoid Borland linker errors.

    Testing/Code/Review/CMakeLists.txt
        ENH: Adding a second test for the itkThresholdMaximumConnectedComponentsImageFilter.
        ENH: Adding returns FAILURE in the catch blocks of the tries.

    Testing/Code/Review/README.txt
        ENH: Notice describing the purpose of this directory.

    Testing/Code/Review/itkReviewHeaderTest
        ENH: Support files for testing the classes that are under the review process.

    Testing/Code/Review/itkReviewPrintTest
        ENH: Support files for testing the classes that are under the review process.

    Testing/Code/Review/itkReviewTests
        COMP: Fixing the connections for the test driver.

    Testing/Code/Review/itkThresholdMaximumConnectedComponentsImageFilterTest
        ENH: Fixing the configuration of the test for using the input and baseline images.
        COMP: Fixing the connections for the test driver.

    Testing/Data/Baseline/BasicFilters/ClosingByReconstructionImageFilterTest.png
        BUG: StructuringElement was uninitialized.

    Testing/Data/Baseline/BasicFilters/ClosingByReconstructionImageFilterTest2.png
        ENH: new regression test.

    Testing/Data/Baseline/BasicFilters/InvertIntensityImageFilterTest.png
        ENH: new regression test.

    Testing/Data/Baseline/BasicFilters/MaskNeighborhoodOperatorImageFilterTest.png
        ENH: new regression test.

    Testing/Data/Baseline/BasicFilters/MatrixIndexSelectionImageFilterTest.png
        ENH: added

    Testing/Data/Baseline/BasicFilters/ModulusImageFilterTest.png
        ENH: new regression test.

    Testing/Data/Baseline/BasicFilters/MorphologicalGradientImageFilterTest.png
        ENH: new regression test.

    Testing/Data/Baseline/BasicFilters/OpeningByReconstructionImageFilterTest.png
        BUG: StructuringElement was uninitialized.

    Testing/Data/Baseline/BasicFilters/OpeningByReconstructionImageFilterTest2.png
        ENH: new regression test.

    Testing/Data/Baseline/BasicFilters/PushPopTileImageFilterTest.png

    Testing/Data/Baseline/BasicFilters/VectorConnectedComponentImageFilterTest.png
        ENH: new regression test.

    Testing/Data/Baseline/Filtering/FACorpusCallosum.mhd
        ENH: Fractional Anisotropy baseline for DiffusionTensor3DReconstructionImageFilterTest

    Testing/Data/Baseline/Filtering/FACorpusCallosum.raw
        ENH: Fractional Anisotropy baseline for DiffusionTensor3DReconstructionImageFilterTest

    Testing/Data/Baseline/Filtering/RACorpusCallosum.mhd
        ENH: Relative Anisotropy baseline for DiffusionTensor3DReconstructionImageFilterTest

    Testing/Data/Baseline/Filtering/RACorpusCallosum.raw
        ENH: Relative Anisotropy baseline for DiffusionTensor3DReconstructionImageFilterTest

    Testing/Data/Baseline/Filtering/ResampleImageFilter9Test.1.png
        ENH: baseline for Borland.

    Testing/Data/Baseline/Filtering/ResampleImageFilter9Test.png
    private/insight-developers/2006-February/007646.html

    Testing/Data/Baseline/Registration/DeformableRegistration3Test.5.png
        ENH: baseline for solaris, darwin and sgi.

    Testing/Data/Baseline/Registration/DeformableRegistration5Test.6.png
        ENH: baseline for ICC8.0

    Testing/Data/Baseline/Review/itkThresholdMaximumConnectedComponentsImageFilterTest1.png
        ENH: Baseline image for the itkThresholdMaximumConnectedComponentsImageFilterTest1.

    Testing/Data/Baseline/Review/itkThresholdMaximumConnectedComponentsImageFilterTest2.png
        ENH: Baseline for the itkThresholdMaximumConnectedComponentsImageFilterTest2.

    Testing/Data/Baseline/Statistics/BayesianClassifierInitializerClass2Output.png

    Testing/Data/Baseline/Statistics/BayesianClassifierLabelMap.png

    Testing/Data/Input/012345.002.050.README
        ENH: Fix comment

    Testing/Data/Input/CellsFluorescence1.png
        ENH: Input test image for the threshold maximum connected components filter test.

    Testing/Data/Input/CellsFluorescence2.png
        ENH: Input image for the ThresholdMaximumConnectedComponentsImageFilterTest2.

    Testing/Data/Input/DwiCorpusCallosum.nhdr
    namic/DTI/Data/dwi.nhdr ftp://public.kitware.com/pub/namic/DTI/Data/dwi.img.gz (gunzip this)

    Testing/Data/Input/DwiCorpusCallosum.raw
    namic/DTI/Data/dwi.nhdr ftp://public.kitware.com/pub/namic/DTI/Data/dwi.img.gz (gunzip this)

    Testing/Data/Input/TensorsCorpusCallosum.mhd

    Testing/Data/Input/TensorsCorpusCallosum.raw

    Testing/Data/Input/chondt.png
        ENH: new input data.

    Testing/Data/Input/closerec1.jpg
        ENH: new input data.

    Utilities/CMakeLists.txt
        ENH: enable kwsys command line processing.
        ENH: Properly handle library prefix. Also backport from openjpeg CVS to support mingw

    Utilities/Dart/CMakeLists.txt
        ENH: Added a script to generate a Wiki-compatible file to show new files between two dates.

    Utilities/Dart/NewSince.csh.in
        ENH: Add the range of dates covered by the release.
        ENH: Added a script to generate a Wiki-compatible file to show new files between two dates.

    Utilities/Dart/NewSince.gawk
        ENH: Added a script to generate a Wiki-compatible file to show new files between two dates.

    Utilities/Doxygen/cvsVersionFilter.

    Utilities/Doxygen/doxygen.config.in
        BUG: Address bug 2733.. For some reason, setting UML_LOOK to ON fails to generate full class inheritence diagrams. It only shows the first level of inheritence
        ENH: Updating the configuration from Doxygen 1.1.4 to Doxygen 1.4.3

    Utilities/MetaIO/metaCommand
        ENH: Added SetOptionComplete() function

    Utilities/MetaIO/metaCommand
        ENH: Added SetOptionComplete() function

    Utilities/MetaIO/metaEllipse
        ENH: Bring AddRestriction from the gdcm level to the itkGDCM level. Update example to show usage, add more doc.

    Utilities/MetaIO/metaImage
        ENH: Bring AddRestriction from the gdcm level to the itkGDCM level. Update example to show usage, add more doc.

    Utilities/MetaIO/metaMe
        COMP: warnings.

    Utilities/MetaIO/metaMesh
        BUG: Now reading PointData and CellData correctly

    Utilities/MetaIO/metaObject
        BUG: MetaIO now supports 64bit int on platforms having 64bit ints.  Thanks to help from Robert Atwood at imperial.ac.uk

    Utilities/MetaIO/metaTypes
        BUG: MetaIO now supports 64bit int on platforms having 64bit ints.  Thanks to help from Robert Atwood at imperial.ac.uk

    Utilities/MetaIO/metaUtils
        BUG: More instances of unsigned __int64 conversion problems on vs6
        BUG: MS-VS6 does not support writing __int64 using ostream <<

    Utilities/MetaIO/metaUtils
        BUG: MetaIO now supports 64bit int on platforms having 64bit ints.  Thanks to help from Robert Atwood at imperial.ac.uk

    Utilities/expat/expatConfig.h.in

    Utilities/expat/xmlparse

    Utilities/expat/xmlrole

    Utilities/expat/xmltok

    Utilities/expat/xmltok_impl

    Utilities/gdcm/AUTHORS
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/CMakeLists.txt
        COMP: Fix compilation on win32 with static on
        STYLE: Typo

    Utilities/gdcm/ChangeLog
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/README
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/gdcmConfigure.h.in
        COMP: Fix compilation on win32 with static on

    Utilities/gdcm/CMake/CTestCustom.ctest.in
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/CMake/FindDicom3Tools.cmake
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/CMake/FindRsync.cmake
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/CMake/gdcmTestFUNCTION
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/ACUSON.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/CMakeLists.txt
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/DicomDir.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/DictGroupName.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/ELSCINT.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/GE-EchoPAC.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/GEMS-Advance.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/GEMS-Advantx.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/GEMS-CR.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/GEMS-DLX.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/GEMS-Genie.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/GEMS-HiSpeed.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/GEMS-Infinia.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/GEMS.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/HITACHI-MR-pronto.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/NIH.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/PHILIPS-EasyVision.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/PHILIPS-Intera.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/Papyrus.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/ParseDict.py
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/README
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/SIEMENS-syngo.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/SIEMENS.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/SPI.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/dicomTS.d
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/Dicts/dicomV3.d
        ENH: changed VR of some tags from US to SS to permit signed shorts.

    Utilities/gdcm/Dicts/gdcm.dic.in
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/src/CMakeLists.txt
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/src/gdcm
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmArgMgr
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmArgMgr
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmBase
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmBase
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmBinEntry
        COMP: Fix compilation on SunOS
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/src/gdcmBinEntry
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmCommon
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmContentEntry
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmContentEntry
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDebug
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDebug
        COMP: Fix compilation on SunOS
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/src/gdcmDefaultDicts.cxx.in
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDicomDir
        COMP: Fix compilation on SunOS
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/src/gdcmDicomDir
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDicomDirElement
        COMP: Fix compilation on SunOS
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/src/gdcmDicomDirElement
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDicomDirImage
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDicomDirImage
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDicomDirMeta
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDicomDirMeta
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDicomDirObject
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDicomDirObject
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDicomDirPatient
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDicomDirPatient
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDicomDirSerie
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDicomDirSerie
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDicomDirStudy
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDicomDirStudy
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDicomDirVisit
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDicomDirVisit
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDict
        COMP: Fix compilation on SunOS
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/src/gdcmDict
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDictEntry
        COMP: Fix compilation on SunOS
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/src/gdcmDictEntry
        COMP: Fix warning
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/src/gdcmDictGroupName
        COMP: Fix compilation on SunOS
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/src/gdcmDictGroupName
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDictSet
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDictSet
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDirList
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDirList
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDocEntry
        COMP: Fix compilation on SunOS
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/src/gdcmDocEntry
        COMP: Fix warning
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/src/gdcmDocEntryArchive
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDocEntryArchive
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDocEntrySet
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDocEntrySet
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmDocument
        COMP: Fix compilation on SunOS
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/src/gdcmDocument
        ENH: Backport gdcm1.2 to ITK-gdcm
        COMP: Please a vendor specific compiler to work around deprecated method and virtual overload

    Utilities/gdcm/src/gdcmElementSet
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmElementSet
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmException
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmException
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmFile
        COMP: Fix compilation on SunOS
        ENH: This should fix the LEGACY code

    Utilities/gdcm/src/gdcmFile
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmFileHelper
        ENH: Properly set some default value: IOP (default to 100010), and Patient Orientation which is redundant...
        BUG: removed old secondary capture logic.

        ENH: Backport gdcm1.2 to ITK-gdcm
        BUG: should not remove Frame Of Reference UID.

    Utilities/gdcm/src/gdcmFileHelper
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmGlobal
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmGlobal
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmJPEGFragment
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmJPEGFragment
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmJPEGFragmentsInfo
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmJPEGFragmentsInfo
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmJpeg
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmJpeg12
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmJpeg16
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmJpeg2000
        ENH: In ITK openjpeg is outside
        COMP: Fix warning on bcc551

    Utilities/gdcm/src/gdcmJpeg8
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmJpegLS
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmMpeg
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmOrientation
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmOrientation
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmPixelReadConvert
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmPixelReadConvert
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmPixelWriteConvert
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmPixelWriteConvert
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmRLEFrame
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmRLEFrame
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmRLEFramesInfo
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmRLEFramesInfo
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmSQItem
        COMP: Fix compilation on SunOS
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/src/gdcmSQItem
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmSeqEntry
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmSeqEntry
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmSerieHelper
        ENH: Redo implementation to use Functor instead of Function, because of brain damage VS6. See Q240871
        ENH: Backport gdcm1.2 to ITK-gdcm
        ENH: Factor code into one single function
        BUG: Clear was incomplete and was not deleting the coherent file list. Thanks to Patrick Cheng for bug report and patch
        BUG: Could not reuse gdcmSerieHelper, now can call Clear before hand

    Utilities/gdcm/src/gdcmSerieHelper
        ENH: Redo implementation to use Functor instead of Function, because of brain damage VS6. See Q240871
        COMP: Fix compilation on bcc
        ENH: Provide backward compatibility
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/src/gdcmTS
        COMP: Fix compilation on SunOS
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/src/gdcmTS
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmUtil
        COMP: Fix compilation on SunOS
        BUG: wrong value for FMIV.
        COMP: Get Mac Address on SGI Irix

    Utilities/gdcm/src/gdcmUtil
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmVR
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmVR
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmValEntry
        COMP: Fix compilation on SunOS
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/src/gdcmValEntry
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/gdcmValidator
        COMP: Fix compilation on SunOS
        ENH: In order to sync with official CVS, remove as much ITKism as possible
        ENH: Update gdcm version to 1.2

    Utilities/gdcm/src/gdcmValidator
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/jdatadst
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/gdcm/src/jdatas
        ENH: Backport gdcm1.2 to ITK-gdcm

    Utilities/kwsys/CMakeLists.txt
        BUG: Fix problem with  in the path
        BUG: Fix DynamicLoader implementation on MacOSX (using old API)
        COMP: Fix cygwin build
        ENH: Carefully turn testing of DynamicLib on
        ENH: Added kwsys::String class to shorten debugging symbols and error messages involving std::string.

    Utilities/kwsys/CommandLineArguments
        ENH: Add a method to remove remaining arguments

    Utilities/kwsys/CommandLineArguments.hxx.in
        ENH: Add a method to remove remaining arguments

    Utilities/kwsys/Directory
        STYLE: Minor style
        COMP: Some STL implementation do not provide clear on std::string
        ENH: Redo implementation of itkDirectory to use kwsys (avoid duplicating code).

    Utilities/kwsys/Directory.hxx.in
        BUG: Need to reset internal structure in case of multiple calls to Load

    Utilities/kwsys/DynamicLoader
        BUG: Fix DynamicLoader implementation on MacOSX (using old API)
        ENH: Hopefully have the DynamicLoader to the proper thing.
        BUG: Including file within a namespace{} is dangerous(unless symbols are within an extern C). Also update documentation about special case for MacOSX
        ENH: Adding kwsys implementation for a DynamicLoader class. Copy from itkDynamicLoader, with patch from cmDynamicLoader

    Utilities/kwsys/DynamicLoader.hxx.in
        ENH: Add documentation on the problem with system wide path for looking up dynamic libraries. STYLE: Fix trailing white spaces
        ENH: Adding kwsys implementation for a DynamicLoader class. Copy from itkDynamicLoader, with patch from cmDynamicLoader

    Utilities/kwsys/EncodeExecutable
        ENH: add support for watcom wmake and wcl386

    Utilities/kwsys/Glob
        STYLE: Make sure to use the proper cast.
        ENH: add support for watcom wmake and wcl386

    Utilities/kwsys/Glob.hxx.in
        COMP: Fix the exporting so that it can actually be used

    Utilities/kwsys/ProcessUNIX
        ENH: Enabled process tree killing on AIX.
        ENH: Enabled process tree killing for FreeBSD and Sun.
        BUG: Do not leak ps FILE when the process starts but reading the header fails.
        BUG: When more than one command is given and one of them fails to start and the rest are killed, do not forget to reap the killed children.

    Utilities/kwsys/ProcessWin32
        COMP: Fixed warnings for Borland 5.8.
        ENH: Improved robustness of sharing parent pipes with children.  This ensures that the parent pipe handles are inherited by the children.  If a parent pipe handle is invalid a handle to an empty pipe is given to the child to make sure all pipes are defined for the children.

    Utilities/kwsys/Registry
        STYLE: Make sure to use the proper cast.
        ENH: add missing cmake depend hacks
        ENH: check in new find stuff

    Utilities/kwsys/Registry.hxx.in
        STYLE: Minor style

    Utilities/kwsys/RegularExpression
        STYLE: Make sure to use the proper cast.

    Utilities/kwsys/String.hxx.in
        ENH: Added kwsys::String class to shorten debugging symbols and error messages involving std::string.

    Utilities/kwsys/SystemTools
        ENH: undo last change because it broke the dashboard
        STYLE: Remove trailing whitespaces
        ENH: fix std in kwsys, has to be kwsys_stl
        ENH: fix for bug 28618, cmake.exe can not find itself
        COMP: Fix compile problem on windows and mac
        ENH: Move relative path to kwsys
        ENH: add support for watcom wmake and wcl386
        BUG: Return if the file is in any directory not just in first one
        ENH: Add another signature to FindProgram that matches more to the one from CMake

    Utilities/kwsys/SystemTools.hxx.in
        ENH: Add documentation on the problem with system wide path for looking up dynamic libraries. STYLE: Fix trailing white spaces
        ENH: Move relative path to kwsys
        ENH: fix for icc
        ENH: Add another signature to FindProgram that matches more to the one from CMake

    Utilities/kwsys/kwsysPlatformCxxTests
        ENH: add support for watcom wmake and wcl386

    Utilities/kwsys/testCommandLineArguments
        STYLE: Make sure to use the proper cast.

    Utilities/kwsys/testDynamicLoader

        BUG: Need a trailing slash
        BUG: Trying to get testDynamicLoader to work on Solaris and SunOS, where current directory is not lookup when doing dlopen
        ENH: Hopefully have the DynamicLoader to the proper thing.
        COMP: Add missing include
        ENH: Still more coverage of the DynamicLoader
        ENH: Adding initial test for DynamicLoader

    Utilities/kwsys/testDynload
        COMP: Fix compilation on MacOSX (common symbols not allowed with MH_DYLIB output format)
        ENH: remove test temporarily

    Utilities/kwsys/testProcess
        ENH: Added a way to quickly enable manual testing of grandchild killing.

    Utilities/kwsys/testRegistry
        ENH: add support for watcom wmake and wcl386

    Utilities/kwsys/testSystemTools
        STYLE: Minor style

    Utilities/kwsys/testSystemTools.h.in
        BUG: Do the proper path
        BUG: Trying to get testDynamicLoader to work on Solaris and SunOS, where current directory is not lookup when doing dlopen

    Utilities/nifti/Testing/niftilib/nifti_test

    Utilities/nifti/examples/CMakeLists.txt

    Utilities/nifti/examples/fsl_api_driver

    Utilities/nifti/fsliolib/fslio

    Utilities/nifti/fsliolib/fslio

    Utilities/nifti/niftilib/nifti1_io
        COMP: warnings.

    Utilities/nifti/niftilib/nifti1_io

    Utilities/nifti/utils/CMakeLists.txt

    Utilities/nifti/utils/nifti_stats

    Utilities/nifti/utils/nifti_tool

    Utilities/nifti/utils/nifti_tool

    Utilities/openjpeg/.NoDartCoverage
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/CMakeLists.txt
        ENH: Update openjpeg to match the one in gdcm 1.2. COMP: This should fix problem introduced yesterday
        ENH: Update openjpeg lib from CVS (Fixes lots of warnings)
        ENH: This is a C only project

    Utilities/openjpeg/README.ITK.txt
        ENH: Add a note for ITK-OpenJPEG

    Utilities/openjpeg/bio
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/bio
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/cio
        ENH: Backport from openjpeg CVS, even more warnings fixes. Change the build system from def file to declspec

    Utilities/openjpeg/cio
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/dwt
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/dwt
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/event
        ENH: Backport from openjpeg CVS, even more warnings fixes. Change the build system from def file to declspec
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/event
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/Attic/fix
        ENH: Update openjpeg to match the one in gdcm 1.2. COMP: This should fix problem introduced yesterday
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/fix
        ENH: Update openjpeg to match the one in gdcm 1.2. COMP: This should fix problem introduced yesterday

    Utilities/openjpeg/image
        ENH: Backport from openjpeg CVS, even more warnings fixes. Change the build system from def file to declspec

    Utilities/openjpeg/image
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/Attic/int
        ENH: Update openjpeg to match the one in gdcm 1.2. COMP: This should fix problem introduced yesterday

    Utilities/openjpeg/int
        ENH: Update openjpeg to match the one in gdcm 1.2. COMP: This should fix problem introduced yesterday

    Utilities/openjpeg/j2k
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/j2k
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/j2k_lib
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/j2k_lib
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/jp2
        ENH: Update openjpeg lib from CVS (Fixes lots of warnings)

    Utilities/openjpeg/jp2
        ENH: Update openjpeg lib from CVS (Fixes lots of warnings)

    Utilities/openjpeg/jpt
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/jpt
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/mct
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/mct
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/mqc
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/mqc
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/openjpeg
        ENH: Backport from openjpeg CVS, even more warnings fixes. Change the build system from def file to declspec
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/Attic/openjpeg.def.in
        ENH: Backport from openjpeg CVS, even more warnings fixes. Change the build system from def file to declspec

    Utilities/openjpeg/openjpeg
        ENH: Update openjpeg to match the one in gdcm 1.2. COMP: This should fix problem introduced yesterday
        ENH: Backport from openjpeg CVS, even more warnings fixes. Change the build system from def file to declspec
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/opj_includes
        ENH: Update openjpeg to match the one in gdcm 1.2. COMP: This should fix problem introduced yesterday

    Utilities/openjpeg/pi
        ENH: Update openjpeg lib from CVS (Fixes lots of warnings)

    Utilities/openjpeg/pi
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/raw
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/raw
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/t1
        ENH: Update openjpeg lib from CVS (Fixes lots of warnings)

    Utilities/openjpeg/t1
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/t2
        ENH: Backport from openjpeg CVS, even more warnings fixes. Change the build system from def file to declspec

    Utilities/openjpeg/t2
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/tcd
        ENH: Backport from openjpeg CVS, even more warnings fixes. Change the build system from def file to declspec
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/tcd
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/tgt
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/openjpeg/tgt
        ENH: Adding a JPEG2000 implementation (OpenJPEG) from Communications and remote sensing Laboratory, Universite catholique de Louvain

    Utilities/tiff/itk_tiff_mangle
        BUG: More external symbols need to be mangled.
        COMP: Enabling mangling

    Utilities/tiff/tif_dir
        COMP: Enabling mangling

    Utilities/tiff/tif_dirread
        COMP: Enabling mangling

    Utilities/tiff/tif_dirwrite
        COMP: Enabling mangling

    Utilities/tiff/tif_swab
        COMP: Enabling mangling

    Utilities/tiff/tiff
        COMP: force to make tiff rebuild.
        COMP: Enabling mangling
        COMP: Missing include to itk_tiff_mangle.h

    Utilities/vxl/vcl/CMakeLists.txt
        STYLE: Removed code with incompatible license.

    Utilities/vxl/vcl/vcl_string
        STYLE: Removed code with incompatible license.

    Utilities/vxl/vcl/vcl_string
        STYLE: Removed code with incompatible license.

    Utilities/vxl/vcl/emulation/vcl_algobase
        STYLE: Removed code with incompatible license.

    Utilities/vxl/vcl/emulation/Attic/vcl_straits
        STYLE: Removed code with incompatible license.

    Utilities/vxl/vcl/emulation/Attic/vcl_straits
        STYLE: Removed code with incompatible license.

    Utilities/vxl/vcl/emulation/Attic/vcl_string
        STYLE: Removed code with incompatible license.

    Utilities/vxl/vcl/emulation/Attic/vcl_string
        STYLE: Removed code with incompatible license.

    Utilities/zlib/zlib.def
        ENH: Fix name
