/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
*/

package test

import (
	v1 "k8s.io/api/core/v1"

	"github.com/apache/yunikorn-k8shim/pkg/common/constants"
	"github.com/apache/yunikorn-scheduler-interface/lib/go/si"
)

type MockedRecoverableAppManager struct {
}

func NewMockedRecoverableAppManager() *MockedRecoverableAppManager {
	return &MockedRecoverableAppManager{}
}

func (m *MockedRecoverableAppManager) ListPods() ([]*v1.Pod, error) {
	return nil, nil
}

func (m *MockedRecoverableAppManager) GetExistingAllocation(pod *v1.Pod) *si.Allocation {
	return &si.Allocation{
		AllocationKey:    string(pod.UID),
		AllocationTags:   nil,
		ResourcePerAlloc: nil,
		Priority:         0,
		NodeID:           pod.Spec.NodeName,
		ApplicationID:    "",
		PartitionName:    constants.DefaultPartition,
	}
}
