/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.xml;

import java.time.Duration;
import java.time.Instant;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.xml.QNameSupport;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public final class DOMTypeSupport {
    @Nonnull
    private static final DatatypeFactory DATA_TYPE_FACTORY;
    @Nonnull
    private static final Calendar BASELINE;

    private DOMTypeSupport() {
    }

    public static Instant stringToInstant(@Nonnull String dateTime) {
        String trimmedString = Constraint.isNotNull(StringSupport.trimOrNull(dateTime), "Lexical dateTime may not be null or empty");
        XMLGregorianCalendar calendar = DATA_TYPE_FACTORY.newXMLGregorianCalendar(trimmedString);
        return calendar.toGregorianCalendar().toInstant();
    }

    public static Duration stringToDuration(@Nonnull String duration) {
        return Duration.ofMillis(DATA_TYPE_FACTORY.newDuration(duration).getTimeInMillis(BASELINE));
    }

    public static DatatypeFactory getDataTypeFactory() {
        return DATA_TYPE_FACTORY;
    }

    @Nullable
    public static QName getXSIType(@Nonnull Element e) {
        Attr attribute;
        String attributeValue;
        if (DOMTypeSupport.hasXSIType(e) && (attributeValue = StringSupport.trimOrNull((attribute = e.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type")).getTextContent())) != null) {
            return QNameSupport.constructQName(e, attributeValue);
        }
        return null;
    }

    public static boolean hasXSIType(@Nonnull Element e) {
        return e.getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type") != null;
    }

    @Nonnull
    public static String instantToString(@Nonnull Instant dateTime) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(dateTime.toEpochMilli());
        return DATA_TYPE_FACTORY.newXMLGregorianCalendar(calendar).normalize().toXMLFormat();
    }

    @Nonnull
    public static String durationToString(@Nonnull Duration duration) {
        return DATA_TYPE_FACTORY.newDuration(duration.toMillis()).toString();
    }

    static {
        try {
            DATA_TYPE_FACTORY = DatatypeFactory.newInstance();
            BASELINE = new GregorianCalendar(1696, 9, 1, 0, 0, 0);
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException("JVM is required to support XML DatatypeFactory but it does not", e);
        }
    }
}

