/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.filter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BinaryOperator;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.FilterStep;
import org.apache.tinkerpop.gremlin.process.traversal.step.filter.RangeGlobalStepContract;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.util.TraverserSet;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

public final class RangeGlobalStep<S>
extends FilterStep<S>
implements RangeGlobalStepContract<S> {
    private long low;
    private long high;
    private Boolean insideLoop;
    private AtomicLong singleCounter = new AtomicLong(0L);
    private Map<String, AtomicLong> loopCounters = new HashMap<String, AtomicLong>();
    private boolean bypass;

    public RangeGlobalStep(Traversal.Admin traversal, long low, long high) {
        super(traversal);
        if (low != -1L && high != -1L && low > high) {
            throw new IllegalArgumentException("Not a legal range: [" + low + ", " + high + "]");
        }
        this.low = low;
        this.high = high;
    }

    @Override
    protected boolean filter(Traverser.Admin<S> traverser) {
        if (this.bypass) {
            return true;
        }
        AtomicLong counter = this.getCounter(traverser);
        if (this.high != -1L && counter.get() >= this.high) {
            if (this.isInsideLoop()) {
                return false;
            }
            throw FastNoSuchElementException.instance();
        }
        long avail = traverser.bulk();
        if (counter.get() + avail <= this.low) {
            counter.getAndAdd(avail);
            return false;
        }
        long toSkip = 0L;
        if (counter.get() < this.low) {
            toSkip = this.low - counter.get();
        }
        long toTrim = 0L;
        if (this.high != -1L && counter.get() + avail >= this.high) {
            toTrim = counter.get() + avail - this.high;
        }
        long toEmit = avail - toSkip - toTrim;
        counter.getAndAdd(toSkip + toEmit);
        traverser.setBulk(toEmit);
        return true;
    }

    @Override
    public void reset() {
        super.reset();
        this.singleCounter.set(0L);
        this.loopCounters.clear();
    }

    @Override
    public String toString() {
        return StringFactory.stepString(this, this.low, this.high);
    }

    @Override
    public Long getLowRange() {
        return this.low;
    }

    @Override
    public Long getHighRange() {
        return this.high;
    }

    @Override
    public RangeGlobalStep<S> clone() {
        RangeGlobalStep clone = (RangeGlobalStep)super.clone();
        clone.singleCounter = new AtomicLong(0L);
        clone.loopCounters = new HashMap<String, AtomicLong>();
        return clone;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Long.hashCode(this.low) ^ Long.hashCode(this.high);
    }

    @Override
    public boolean equals(Object other) {
        if (super.equals(other)) {
            RangeGlobalStep typedOther = (RangeGlobalStep)other;
            return typedOther.low == this.low && typedOther.high == this.high;
        }
        return false;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.BULK);
    }

    @Override
    public void setBypass(boolean bypass) {
        this.bypass = bypass;
    }

    @Override
    public void processAllStarts() {
    }

    private AtomicLong getCounter(Traverser.Admin<S> traverser) {
        if (this.isInsideLoop()) {
            String counterKey = this.getCounterKey(traverser);
            return this.loopCounters.computeIfAbsent(counterKey, k -> new AtomicLong(0L));
        }
        return this.singleCounter;
    }

    private boolean isInsideLoop() {
        if (this.insideLoop == null) {
            this.insideLoop = TraversalHelper.hasRepeatStepParent(this.getTraversal());
        }
        return this.insideLoop;
    }

    private String getCounterKey(Traverser.Admin<S> traverser) {
        ArrayList<String> counterKeyParts = new ArrayList<String>();
        Traversal.Admin traversal = this.getTraversal();
        if (this.isInsideLoop()) {
            while (!traversal.isRoot()) {
                TraversalParent pt = traversal.getParent();
                Step<?, ?> ps = pt.asStep();
                String pid = ps.getId();
                if (traverser.getLoopNames().contains(pid)) {
                    counterKeyParts.add(pid);
                    counterKeyParts.add(String.valueOf(traverser.loops(pid)));
                }
                traversal = ps.getTraversal();
            }
        }
        Collections.reverse(counterKeyParts);
        counterKeyParts.add(this.getId());
        if (traverser.getLoopNames().contains(this.getId())) {
            counterKeyParts.add(String.valueOf(traverser.loops(this.getId())));
        }
        return String.join((CharSequence)":", counterKeyParts);
    }

    public static final class RangeBiOperator<S>
    implements BinaryOperator<TraverserSet<S>>,
    Serializable {
        private final long highRange;

        public RangeBiOperator() {
            this(-1L);
        }

        public RangeBiOperator(long highRange) {
            this.highRange = highRange;
        }

        @Override
        public TraverserSet<S> apply(TraverserSet<S> mutatingSeed, TraverserSet<S> set) {
            if (this.highRange == -1L || (long)mutatingSeed.size() < this.highRange) {
                mutatingSeed.addAll(set);
            }
            return mutatingSeed;
        }
    }
}

