/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint.channel;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateSerializerImpl;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequest;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestDispatcherImpl;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestExecutor;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriteRequestExecutorImpl;
import org.apache.flink.runtime.checkpoint.channel.ChannelStateWriter;
import org.apache.flink.runtime.checkpoint.channel.CheckpointStartRequest;
import org.apache.flink.runtime.checkpoint.channel.InputChannelInfo;
import org.apache.flink.runtime.checkpoint.channel.ResultSubpartitionInfo;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.state.CheckpointStorageWorkerView;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
@ThreadSafe
public class ChannelStateWriterImpl
implements ChannelStateWriter {
    private static final Logger LOG = LoggerFactory.getLogger(ChannelStateWriterImpl.class);
    private static final int DEFAULT_MAX_CHECKPOINTS = 1000;
    private final String taskName;
    private final ChannelStateWriteRequestExecutor executor;
    private final ConcurrentMap<Long, ChannelStateWriter.ChannelStateWriteResult> results;
    private final int maxCheckpoints;

    public ChannelStateWriterImpl(String taskName, int subtaskIndex, CheckpointStorageWorkerView streamFactoryResolver) {
        this(taskName, subtaskIndex, streamFactoryResolver, 1000);
    }

    ChannelStateWriterImpl(String taskName, int subtaskIndex, CheckpointStorageWorkerView streamFactoryResolver, int maxCheckpoints) {
        this(taskName, new ConcurrentHashMap<Long, ChannelStateWriter.ChannelStateWriteResult>(maxCheckpoints), new ChannelStateWriteRequestExecutorImpl(taskName, new ChannelStateWriteRequestDispatcherImpl(taskName, subtaskIndex, streamFactoryResolver, new ChannelStateSerializerImpl())), maxCheckpoints);
    }

    ChannelStateWriterImpl(String taskName, ConcurrentMap<Long, ChannelStateWriter.ChannelStateWriteResult> results, ChannelStateWriteRequestExecutor executor, int maxCheckpoints) {
        this.taskName = taskName;
        this.results = results;
        this.maxCheckpoints = maxCheckpoints;
        this.executor = executor;
    }

    @Override
    public void start(long checkpointId, CheckpointOptions checkpointOptions) {
        LOG.debug("{} starting checkpoint {} ({})", new Object[]{this.taskName, checkpointId, checkpointOptions});
        ChannelStateWriter.ChannelStateWriteResult result = new ChannelStateWriter.ChannelStateWriteResult();
        ChannelStateWriter.ChannelStateWriteResult put = this.results.computeIfAbsent(checkpointId, id -> {
            Preconditions.checkState((this.results.size() < this.maxCheckpoints ? 1 : 0) != 0, (Object)String.format("%s can't start %d, results.size() > maxCheckpoints: %d > %d", this.taskName, checkpointId, this.results.size(), this.maxCheckpoints));
            this.enqueue(new CheckpointStartRequest(checkpointId, result, checkpointOptions.getTargetLocation()), false);
            return result;
        });
        Preconditions.checkArgument((put == result ? 1 : 0) != 0, (Object)(this.taskName + " result future already present for checkpoint " + checkpointId));
    }

    @Override
    public void addInputData(long checkpointId, InputChannelInfo info, int startSeqNum, CloseableIterator<Buffer> iterator) {
        LOG.trace("{} adding input data, checkpoint {}, channel: {}, startSeqNum: {}", new Object[]{this.taskName, checkpointId, info, startSeqNum});
        this.enqueue(ChannelStateWriteRequest.write(checkpointId, info, iterator), false);
    }

    @Override
    public void addOutputData(long checkpointId, ResultSubpartitionInfo info, int startSeqNum, Buffer ... data) {
        LOG.trace("{} adding output data, checkpoint {}, channel: {}, startSeqNum: {}, num buffers: {}", new Object[]{this.taskName, checkpointId, info, startSeqNum, data == null ? 0 : data.length});
        this.enqueue(ChannelStateWriteRequest.write(checkpointId, info, data), false);
    }

    @Override
    public void finishInput(long checkpointId) {
        LOG.debug("{} finishing input data, checkpoint {}", (Object)this.taskName, (Object)checkpointId);
        this.enqueue(ChannelStateWriteRequest.completeInput(checkpointId), false);
    }

    @Override
    public void finishOutput(long checkpointId) {
        LOG.debug("{} finishing output data, checkpoint {}", (Object)this.taskName, (Object)checkpointId);
        this.enqueue(ChannelStateWriteRequest.completeOutput(checkpointId), false);
    }

    @Override
    public void abort(long checkpointId, Throwable cause, boolean cleanup) {
        LOG.debug("{} aborting, checkpoint {}", (Object)this.taskName, (Object)checkpointId);
        this.enqueue(ChannelStateWriteRequest.abort(checkpointId, cause), true);
        this.enqueue(ChannelStateWriteRequest.abort(checkpointId, cause), false);
        if (cleanup) {
            this.results.remove(checkpointId);
        }
    }

    @Override
    public ChannelStateWriter.ChannelStateWriteResult getAndRemoveWriteResult(long checkpointId) {
        LOG.debug("{} requested write result, checkpoint {}", (Object)this.taskName, (Object)checkpointId);
        ChannelStateWriter.ChannelStateWriteResult result = (ChannelStateWriter.ChannelStateWriteResult)this.results.remove(checkpointId);
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (Object)(this.taskName + " channel state write result not found for checkpoint " + checkpointId));
        return result;
    }

    public void open() {
        this.executor.start();
    }

    @Override
    public void close() throws IOException {
        LOG.debug("close, dropping checkpoints {}", this.results.keySet());
        this.results.clear();
        this.executor.close();
    }

    private void enqueue(ChannelStateWriteRequest request, boolean atTheFront) {
        try {
            if (atTheFront) {
                this.executor.submitPriority(request);
            } else {
                this.executor.submit(request);
            }
        }
        catch (Exception e) {
            RuntimeException wrapped = new RuntimeException("unable to send request to worker", e);
            try {
                request.cancel(e);
            }
            catch (Exception cancelException) {
                wrapped.addSuppressed(cancelException);
            }
            throw wrapped;
        }
    }
}

