/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.binders;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.sonatype.guice.bean.locators.BeanLocator;
import org.sonatype.inject.Mediator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BeanListener
implements TypeListener,
InjectionListener<Object> {
    private final List<Mediation<?, ?, ?>> mediation = new ArrayList();
    @Inject
    private BeanLocator locator;

    BeanListener() {
    }

    public <Q, T, W> void mediate(Key<T> key, Mediator<Q, T, W> mediator, Class<W> watcherType) {
        this.mediation.add(new Mediation<Q, T, W>(key, mediator, watcherType));
    }

    public <T> void hear(TypeLiteral<T> type, TypeEncounter<T> encounter) {
        for (Mediation<?, ?, ?> m : this.mediation) {
            if (!m.watcherType.isAssignableFrom(type.getRawType())) continue;
            encounter.register((InjectionListener)this);
        }
    }

    public void afterInjection(Object watcher) {
        for (Mediation<?, ?, ?> m : this.mediation) {
            if (!m.watcherType.isInstance(watcher)) continue;
            this.locator.watch(m.watchedKey, m.mediator, watcher);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Mediation<Q, T, W> {
        final Key<T> watchedKey;
        final Mediator<Q, T, W> mediator;
        final Class<W> watcherType;

        Mediation(Key<T> watchedKey, Mediator<Q, T, W> mediator, Class<W> watcherType) {
            this.watchedKey = watchedKey;
            this.mediator = mediator;
            this.watcherType = watcherType;
        }
    }
}

