/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.registration;

import org.apache.flink.configuration.ClusterOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Preconditions;

public class RetryingRegistrationConfiguration {
    private final long initialRegistrationTimeoutMillis;
    private final long maxRegistrationTimeoutMillis;
    private final long errorDelayMillis;
    private final long refusedDelayMillis;

    public RetryingRegistrationConfiguration(long initialRegistrationTimeoutMillis, long maxRegistrationTimeoutMillis, long errorDelayMillis, long refusedDelayMillis) {
        Preconditions.checkArgument((initialRegistrationTimeoutMillis > 0L ? 1 : 0) != 0, (Object)"initial registration timeout must be greater than zero");
        Preconditions.checkArgument((maxRegistrationTimeoutMillis > 0L ? 1 : 0) != 0, (Object)"maximum registration timeout must be greater than zero");
        Preconditions.checkArgument((errorDelayMillis >= 0L ? 1 : 0) != 0, (Object)"delay on error must be non-negative");
        Preconditions.checkArgument((refusedDelayMillis >= 0L ? 1 : 0) != 0, (Object)"delay on refused registration must be non-negative");
        this.initialRegistrationTimeoutMillis = initialRegistrationTimeoutMillis;
        this.maxRegistrationTimeoutMillis = maxRegistrationTimeoutMillis;
        this.errorDelayMillis = errorDelayMillis;
        this.refusedDelayMillis = refusedDelayMillis;
    }

    public long getInitialRegistrationTimeoutMillis() {
        return this.initialRegistrationTimeoutMillis;
    }

    public long getMaxRegistrationTimeoutMillis() {
        return this.maxRegistrationTimeoutMillis;
    }

    public long getErrorDelayMillis() {
        return this.errorDelayMillis;
    }

    public long getRefusedDelayMillis() {
        return this.refusedDelayMillis;
    }

    public static RetryingRegistrationConfiguration fromConfiguration(Configuration configuration) {
        long initialRegistrationTimeoutMillis = configuration.getLong(ClusterOptions.INITIAL_REGISTRATION_TIMEOUT);
        long maxRegistrationTimeoutMillis = configuration.getLong(ClusterOptions.MAX_REGISTRATION_TIMEOUT);
        long errorDelayMillis = configuration.getLong(ClusterOptions.ERROR_REGISTRATION_DELAY);
        long refusedDelayMillis = configuration.getLong(ClusterOptions.REFUSED_REGISTRATION_DELAY);
        return new RetryingRegistrationConfiguration(initialRegistrationTimeoutMillis, maxRegistrationTimeoutMillis, errorDelayMillis, refusedDelayMillis);
    }

    public static RetryingRegistrationConfiguration defaultConfiguration() {
        return RetryingRegistrationConfiguration.fromConfiguration(new Configuration());
    }
}

