/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.NoSuchElementException;
import org.apache.spark.SparkException;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.feature.VectorAssembler;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.util.DefaultParamsReadable;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructField;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction2;

public final class VectorAssembler$
implements DefaultParamsReadable<VectorAssembler>,
Serializable {
    public static final VectorAssembler$ MODULE$ = new VectorAssembler$();
    private static final String SKIP_INVALID;
    private static final String ERROR_INVALID;
    private static final String KEEP_INVALID;
    private static final String[] supportedHandleInvalids;

    static {
        MLReadable.$init$(MODULE$);
        DefaultParamsReadable.$init$(MODULE$);
        SKIP_INVALID = "skip";
        ERROR_INVALID = "error";
        KEEP_INVALID = "keep";
        supportedHandleInvalids = (String[])((Object[])new String[]{MODULE$.SKIP_INVALID(), MODULE$.ERROR_INVALID(), MODULE$.KEEP_INVALID()});
    }

    @Override
    public MLReader<VectorAssembler> read() {
        return DefaultParamsReadable.read$(this);
    }

    public String SKIP_INVALID() {
        return SKIP_INVALID;
    }

    public String ERROR_INVALID() {
        return ERROR_INVALID;
    }

    public String KEEP_INVALID() {
        return KEEP_INVALID;
    }

    public String[] supportedHandleInvalids() {
        return supportedHandleInvalids;
    }

    public Map<String, Object> getVectorLengthsFromFirstRow(Dataset<?> dataset, Seq<String> columns) {
        Map map;
        try {
            Row first_row = (Row)dataset.toDF().select((Seq)columns.map((Function1 & Serializable)colName -> functions$.MODULE$.col(colName))).first();
            map = ((IterableOnceOps)((IterableOps)columns.zip((IterableOnce)first_row.toSeq())).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    String c = (String)tuple2._1();
                    Object x = tuple2._2();
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)c), (Object)BoxesRunTime.boxToInteger((int)((Vector)x).size()));
                }
                throw new MatchError((Object)tuple2);
            })).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (NullPointerException e) {
            throw new NullPointerException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Encountered null value while inferring lengths from the first row. Consider using\n           |VectorSizeHint to add metadata for columns: " + columns.mkString("[", ", ", "]") + ". ")).replaceAll("\n", " ") + e.toString());
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Encountered empty dataframe while inferring lengths from the first row. Consider using\n           |VectorSizeHint to add metadata for columns: " + columns.mkString("[", ", ", "]") + ". ")).replaceAll("\n", " ") + e.toString());
        }
        return map;
    }

    /*
     * Unable to fully structure code
     */
    public Map<String, Object> getLengths(Dataset<?> dataset, Seq<String> columns, String handleInvalid) {
        block8: {
            block7: {
                groupSizes = ((IterableOnceOps)columns.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getLengths$1(org.apache.spark.sql.Dataset java.lang.String ), (Ljava/lang/String;)Lscala/Tuple2;)(dataset))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
                missingColumns = ((MapOps)groupSizes.filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getLengths$2$adapted(scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)())).keys().toSeq();
                var8_6 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)missingColumns.nonEmpty()), (Object)handleInvalid);
                if (var8_6 == null) break block7;
                var9_7 = var8_6._1$mcZ$sp();
                var10_8 = (String)var8_6._2();
                if (!var9_7) break block7;
                v0 = this.ERROR_INVALID();
                var11_9 = var10_8;
                if (v0 != null ? v0.equals(var11_9) == false : var11_9 != null) break block7;
                v1 = this.getVectorLengthsFromFirstRow(dataset, (Seq<String>)missingColumns);
                break block8;
            }
            if (var8_6 == null) ** GOTO lbl-1000
            var12_10 = var8_6._1$mcZ$sp();
            var13_11 = (String)var8_6._2();
            if (!var12_10) ** GOTO lbl-1000
            v2 = this.SKIP_INVALID();
            var14_12 = var13_11;
            if (!(v2 != null ? v2.equals(var14_12) == false : var14_12 != null)) {
                v1 = this.getVectorLengthsFromFirstRow(dataset.na().drop(missingColumns), (Seq<String>)missingColumns);
            } else lbl-1000:
            // 3 sources

            {
                if (var8_6 != null) {
                    var15_13 = var8_6._1$mcZ$sp();
                    var16_14 = (String)var8_6._2();
                    if (var15_13) {
                        v3 = this.KEEP_INVALID();
                        var17_15 = var16_14;
                        if (!(v3 != null ? v3.equals(var17_15) == false : var17_15 != null)) {
                            throw new RuntimeException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Can not infer column lengths with handleInvalid = \"keep\". Consider using VectorSizeHint\n           |to add metadata for columns: " + missingColumns.mkString("[", ", ", "]") + ".")).replaceAll("\n", " "));
                        }
                    }
                }
                if (var8_6 != null) {
                    v1 = Predef$.MODULE$.Map().empty();
                } else {
                    throw new MatchError((Object)var8_6);
                }
            }
        }
        firstSizes = v1;
        return (Map)groupSizes.$plus$plus((IterableOnce)firstSizes);
    }

    @Override
    public VectorAssembler load(String path) {
        return (VectorAssembler)MLReadable.load$(this, path);
    }

    public Vector assemble(int[] lengths, boolean keepInvalid, Seq<Object> vv) {
        ArrayBuilder indices = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Int());
        ArrayBuilder values = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Double());
        IntRef featureIndex = IntRef.create((int)0);
        IntRef inputColumnIndex = IntRef.create((int)0);
        vv.foreach((Function1 & Serializable)x0$1 -> {
            VectorAssembler$.$anonfun$assemble$1(keepInvalid, indices, featureIndex, values, inputColumnIndex, lengths, x0$1);
            return BoxedUnit.UNIT;
        });
        int[] idxArray = (int[])indices.result();
        double[] valArray = (double[])values.result();
        return Vectors$.MODULE$.sparse(featureIndex.elem, idxArray, valArray).compressedWithNNZ(idxArray.length);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(VectorAssembler$.class);
    }

    public static final /* synthetic */ Tuple2 $anonfun$getLengths$1(Dataset dataset$2, String c) {
        StructField field = SchemaUtils$.MODULE$.getSchemaField(dataset$2.schema(), c);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)c), (Object)BoxesRunTime.boxToInteger((int)AttributeGroup$.MODULE$.fromStructField(field).size()));
    }

    public static final /* synthetic */ boolean $anonfun$getLengths$2(Tuple2 x$1) {
        return x$1._2$mcI$sp() == -1;
    }

    public static final /* synthetic */ ArrayBuilder $anonfun$assemble$3(ArrayBuilder indices$1, IntRef featureIndex$1, ArrayBuilder values$1, int i) {
        indices$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(featureIndex$1.elem + i)));
        return (ArrayBuilder)values$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)Double.NaN));
    }

    public static final /* synthetic */ void $anonfun$assemble$1(boolean keepInvalid$2, ArrayBuilder indices$1, IntRef featureIndex$1, ArrayBuilder values$1, IntRef inputColumnIndex$1, int[] lengths$2, Object x0$1) {
        Object object = x0$1;
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            if (Double.isNaN(d) && !keepInvalid$2) {
                throw new SparkException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Encountered NaN while assembling a row with handleInvalid = \"error\". Consider\n               |removing NaNs from dataset or using handleInvalid = \"keep\" or \"skip\".")));
            }
            if (d != 0.0) {
                indices$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)featureIndex$1.elem));
                v0 = values$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)d));
            } else {
                v0 = BoxedUnit.UNIT;
            }
            ++inputColumnIndex$1.elem;
            ++featureIndex$1.elem;
            return;
        }
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            vector.foreachNonZero((Function2)(JFunction2.mcVID.sp & Serializable)(x0$2, x1$1) -> {
                Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$2, x1$1);
                if (sp2 != null) {
                    int i = sp2._1$mcI$sp();
                    double v = sp2._2$mcD$sp();
                    indices$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(featureIndex$1.elem + i)));
                    values$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)v));
                    return;
                }
                throw new MatchError((Object)sp2);
            });
            ++inputColumnIndex$1.elem;
            featureIndex$1.elem += vector.size();
            return;
        }
        if (object == null) {
            if (keepInvalid$2) {
                int length = lengths$2[inputColumnIndex$1.elem];
                package$.MODULE$.Iterator().range(0, length).foreach((Function1 & Serializable)i -> VectorAssembler$.$anonfun$assemble$3(indices$1, featureIndex$1, values$1, BoxesRunTime.unboxToInt((Object)i)));
                ++inputColumnIndex$1.elem;
                featureIndex$1.elem += length;
                return;
            }
            throw new SparkException(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Encountered null while assembling a row with handleInvalid = \"error\". Consider\n               |removing nulls from dataset or using handleInvalid = \"keep\" or \"skip\".")));
        }
        throw new SparkException(object + " of type " + object.getClass().getName() + " is not supported.");
    }

    private VectorAssembler$() {
    }

    public static final /* synthetic */ Object $anonfun$getLengths$2$adapted(Tuple2 x$1) {
        return BoxesRunTime.boxToBoolean((boolean)VectorAssembler$.$anonfun$getLengths$2(x$1));
    }
}

