/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.types.wrappers;

import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.datanucleus.flush.MapPutOperation;
import org.datanucleus.flush.MapRemoveOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.FetchPlanState;
import org.datanucleus.state.ObjectProvider;
import org.datanucleus.store.types.SCOMap;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class HashMap<K, V>
extends java.util.HashMap<K, V>
implements SCOMap<java.util.HashMap<K, V>, K, V> {
    protected transient ObjectProvider ownerOP;
    protected transient AbstractMemberMetaData ownerMmd;
    protected java.util.HashMap<K, V> delegate;

    public HashMap(ObjectProvider ownerOP, AbstractMemberMetaData mmd) {
        super(0);
        this.ownerOP = ownerOP;
        this.ownerMmd = mmd;
    }

    @Override
    public void initialise(java.util.HashMap<K, V> newValue, Object oldValue) {
        this.initialise(newValue);
    }

    @Override
    public void initialise(java.util.HashMap m) {
        this.delegate = m != null ? m : new java.util.HashMap();
        if (NucleusLogger.PERSISTENCE.isDebugEnabled()) {
            NucleusLogger.PERSISTENCE.debug(Localiser.msg("023003", this.getClass().getName(), this.ownerOP.getObjectAsPrintable(), this.ownerMmd.getName(), "" + this.size(), SCOUtils.getSCOWrapperOptionsMessage(true, false, true, false)));
        }
    }

    @Override
    public void initialise() {
        this.initialise(null);
    }

    @Override
    public java.util.HashMap getValue() {
        return this.delegate;
    }

    @Override
    public void setValue(java.util.HashMap value) {
        this.delegate = value;
    }

    @Override
    public void load() {
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public void updateEmbeddedKey(K key, int fieldNumber, Object newValue, boolean makeDirty) {
        if (makeDirty) {
            this.makeDirty();
        }
    }

    @Override
    public void updateEmbeddedValue(V value, int fieldNumber, Object newValue, boolean makeDirty) {
        if (makeDirty) {
            this.makeDirty();
        }
    }

    @Override
    public String getFieldName() {
        return this.ownerMmd.getName();
    }

    @Override
    public Object getOwner() {
        return this.ownerOP != null ? this.ownerOP.getObject() : null;
    }

    @Override
    public void unsetOwner() {
        if (this.ownerOP != null) {
            this.ownerOP = null;
            this.ownerMmd = null;
        }
    }

    public void makeDirty() {
        if (this.ownerOP != null) {
            this.ownerOP.makeDirty(this.ownerMmd.getAbsoluteFieldNumber());
        }
    }

    @Override
    public java.util.HashMap detachCopy(FetchPlanState state) {
        java.util.HashMap detached = new java.util.HashMap();
        SCOUtils.detachCopyForMap(this.ownerOP, this.entrySet(), state, detached);
        return detached;
    }

    @Override
    public void attachCopy(java.util.HashMap value) {
        boolean keysWithoutIdentity = SCOUtils.mapHasKeysWithoutIdentity(this.ownerMmd);
        boolean valuesWithoutIdentity = SCOUtils.mapHasValuesWithoutIdentity(this.ownerMmd);
        java.util.HashMap attachedKeysValues = new java.util.HashMap(value.size());
        SCOUtils.attachCopyForMap(this.ownerOP, value.entrySet(), attachedKeysValues, keysWithoutIdentity, valuesWithoutIdentity);
        SCOUtils.updateMapWithMapKeysValues(this.ownerOP.getExecutionContext().getApiAdapter(), this, attachedKeysValues);
    }

    @Override
    public Object clone() {
        return this.delegate.clone();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Set entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public V get(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set keySet() {
        return this.delegate.keySet();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Collection values() {
        return this.delegate.values();
    }

    @Override
    public void clear() {
        if (this.ownerOP != null && !this.delegate.isEmpty()) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                for (Map.Entry<K, V> entry : this.delegate.entrySet()) {
                    this.ownerOP.getExecutionContext().addOperationToQueue(new MapRemoveOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), entry.getKey(), entry.getValue()));
                }
            } else if (SCOUtils.hasDependentKey(this.ownerMmd) || SCOUtils.hasDependentValue(this.ownerMmd)) {
                for (Map.Entry<K, V> entry : this.delegate.entrySet()) {
                    if (SCOUtils.hasDependentKey(this.ownerMmd)) {
                        this.ownerOP.getExecutionContext().deleteObjectInternal(entry.getKey());
                    }
                    if (!SCOUtils.hasDependentValue(this.ownerMmd)) continue;
                    this.ownerOP.getExecutionContext().deleteObjectInternal(entry.getValue());
                }
            }
        }
        this.delegate.clear();
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public V put(K key, V value) {
        V oldValue = this.delegate.put(key, value);
        this.makeDirty();
        if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
            this.ownerOP.getExecutionContext().addOperationToQueue(new MapPutOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), key, value));
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return oldValue;
    }

    @Override
    public void putAll(Map m) {
        this.delegate.putAll(m);
        this.makeDirty();
        if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
            for (Map.Entry entry : m.entrySet()) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new MapPutOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), entry.getKey(), entry.getValue()));
            }
        }
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
    }

    @Override
    public V remove(Object key) {
        V value = this.delegate.remove(key);
        if (this.ownerOP != null) {
            if (SCOUtils.useQueuedUpdate(this.ownerOP)) {
                this.ownerOP.getExecutionContext().addOperationToQueue(new MapRemoveOperation(this.ownerOP, this.ownerMmd.getAbsoluteFieldNumber(), key, value));
            } else if (SCOUtils.hasDependentKey(this.ownerMmd) || SCOUtils.hasDependentValue(this.ownerMmd)) {
                if (SCOUtils.hasDependentKey(this.ownerMmd)) {
                    this.ownerOP.getExecutionContext().deleteObjectInternal(key);
                }
                if (SCOUtils.hasDependentValue(this.ownerMmd)) {
                    this.ownerOP.getExecutionContext().deleteObjectInternal(value);
                }
            }
        }
        this.makeDirty();
        if (this.ownerOP != null && !this.ownerOP.getExecutionContext().getTransaction().isActive()) {
            this.ownerOP.getExecutionContext().processNontransactionalUpdate();
        }
        return value;
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new java.util.HashMap<K, V>(this.delegate);
    }
}

