/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import java.util.Random;

public class CuckooSetLong {
    private long[] t1;
    private long[] t2;
    private long[] prev1 = null;
    private long[] prev2 = null;
    private int n;
    private static final double PADDING_FACTOR = 2.5;
    private int[] salt = new int[6];
    private Random gen = new Random(676983475L);
    private long blank = Long.MIN_VALUE;
    private int rehashCount = 0;
    public static int[] primes = new int[]{7, 13, 17, 23, 31, 53, 67, 89, 127, 269, 571, 1019, 2089, 4507, 8263, 16361, 32327, 65437, 131111, 258887, 525961, 999983, 2158909, 4074073, 8321801, 15485863, 32452867, 67867967, 122949829, 256203221, 553105253, 982451653, 1645333507, Integer.MAX_VALUE};

    public CuckooSetLong(int expectedSize) {
        this.n = (int)((double)expectedSize * 2.5 / 2.0);
        for (int i = 0; i != primes.length; ++i) {
            if (this.n > primes[i]) continue;
            this.n = primes[i];
            break;
        }
        this.t1 = new long[this.n];
        this.t2 = new long[this.n];
        Arrays.fill(this.t1, this.blank);
        Arrays.fill(this.t2, this.blank);
        this.updateHashSalt();
    }

    public boolean lookup(long x) {
        return x != this.blank && (this.t1[this.h1(x)] == x || this.t2[this.h2(x)] == x);
    }

    public void insert(long x) {
        if (x == this.blank) {
            this.findNewBlank();
        }
        if (this.lookup(x)) {
            return;
        }
        for (int i = 0; i != this.n; ++i) {
            if (this.t1[this.h1(x)] == this.blank) {
                this.t1[this.h1((long)x)] = x;
                return;
            }
            long temp = this.t1[this.h1(x)];
            this.t1[this.h1((long)x)] = x;
            x = temp;
            if (this.t2[this.h2(x)] == this.blank) {
                this.t2[this.h2((long)x)] = x;
                return;
            }
            temp = this.t2[this.h2(x)];
            this.t2[this.h2((long)x)] = x;
            x = temp;
        }
        this.rehash();
        this.insert(x);
    }

    public void load(long[] a) {
        long[] lArray = a;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            Long x = lArray[i];
            this.insert(x);
        }
    }

    private void findNewBlank() {
        long newBlank = this.gen.nextLong();
        while (newBlank == this.blank || this.lookup(newBlank)) {
            newBlank = this.gen.nextLong();
        }
        for (int i = 0; i != this.n; ++i) {
            if (this.t1[i] == this.blank) {
                this.t1[i] = newBlank;
            }
            if (this.t2[i] != this.blank) continue;
            this.t2[i] = newBlank;
        }
        this.blank = newBlank;
    }

    private long tryInsert(long x) {
        for (int i = 0; i != this.n; ++i) {
            if (this.t1[this.h1(x)] == this.blank) {
                this.t1[this.h1((long)x)] = x;
                return this.blank;
            }
            long temp = this.t1[this.h1(x)];
            this.t1[this.h1((long)x)] = x;
            x = temp;
            if (this.t2[this.h2(x)] == this.blank) {
                this.t2[this.h2((long)x)] = x;
                return this.blank;
            }
            temp = this.t2[this.h2(x)];
            this.t2[this.h2((long)x)] = x;
            x = temp;
            if (x == this.blank) break;
        }
        return x;
    }

    private int h1(long y) {
        int x = (int)((y >>> 32 ^ y) & 0xFFFFFFFFFFFFFFFFL);
        x = x + this.salt[0] + (x << 12);
        x = x ^ this.salt[1] ^ x >> 19;
        x = x + this.salt[2] + (x << 5);
        x = x + this.salt[3] ^ x << 9;
        x = x + this.salt[4] + (x << 3);
        x = x ^ this.salt[5] ^ x >> 16;
        return (x & Integer.MAX_VALUE) % this.n;
    }

    private int h2(long x) {
        return ((int)(x % (long)this.n) + this.n) % this.n;
    }

    private void updateHashSalt() {
        for (int i = 0; i != 6; ++i) {
            this.salt[i] = this.gen.nextInt(Integer.MAX_VALUE);
        }
    }

    private void rehash() {
        long x;
        Long v;
        int n;
        ++this.rehashCount;
        if (this.rehashCount > 20) {
            throw new RuntimeException("Too many rehashes");
        }
        this.updateHashSalt();
        if (this.prev1 == null) {
            this.prev1 = this.t1;
            this.prev2 = this.t2;
        }
        this.t1 = new long[this.n];
        this.t2 = new long[this.n];
        Arrays.fill(this.t1, this.blank);
        Arrays.fill(this.t2, this.blank);
        long[] lArray = this.prev1;
        int n2 = lArray.length;
        for (n = 0; n < n2; ++n) {
            v = lArray[n];
            if (v == this.blank || (x = this.tryInsert(v)) == this.blank) continue;
            this.rehash();
            return;
        }
        lArray = this.prev2;
        n2 = lArray.length;
        for (n = 0; n < n2; ++n) {
            v = lArray[n];
            if (v == this.blank || (x = this.tryInsert(v)) == this.blank) continue;
            this.rehash();
            return;
        }
        this.prev1 = null;
        this.prev2 = null;
    }
}

