/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.sparkproject.guava.base.Objects;

public class RemoveShuffleMerge
extends BlockTransferMessage {
    public final String appId;
    public final int appAttemptId;
    public final int shuffleId;
    public final int shuffleMergeId;

    public RemoveShuffleMerge(String appId, int appAttemptId, int shuffleId, int shuffleMergeId) {
        this.appId = appId;
        this.appAttemptId = appAttemptId;
        this.shuffleId = shuffleId;
        this.shuffleMergeId = shuffleMergeId;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.REMOVE_SHUFFLE_MERGE;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.appId, this.appAttemptId, this.shuffleId, this.shuffleMergeId});
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("appId", (Object)this.appId).append("attemptId", this.appAttemptId).append("shuffleId", this.shuffleId).append("shuffleMergeId", this.shuffleMergeId).toString();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof RemoveShuffleMerge) {
            RemoveShuffleMerge o = (RemoveShuffleMerge)other;
            return Objects.equal((Object)this.appId, (Object)o.appId) && this.appAttemptId == o.appAttemptId && this.shuffleId == o.shuffleId && this.shuffleMergeId == o.shuffleMergeId;
        }
        return false;
    }

    public int encodedLength() {
        return Encoders.Strings.encodedLength((String)this.appId) + 4 + 4 + 4;
    }

    public void encode(ByteBuf buf) {
        Encoders.Strings.encode((ByteBuf)buf, (String)this.appId);
        buf.writeInt(this.appAttemptId);
        buf.writeInt(this.shuffleId);
        buf.writeInt(this.shuffleMergeId);
    }

    public static RemoveShuffleMerge decode(ByteBuf buf) {
        String appId = Encoders.Strings.decode((ByteBuf)buf);
        int attemptId = buf.readInt();
        int shuffleId = buf.readInt();
        int shuffleMergeId = buf.readInt();
        return new RemoveShuffleMerge(appId, attemptId, shuffleId, shuffleMergeId);
    }
}

