/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.evaluation.AreaUnderCurve$;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics$;
import org.apache.spark.mllib.evaluation.binary.BinaryClassificationMetricComputer;
import org.apache.spark.mllib.evaluation.binary.BinaryConfusionMatrix;
import org.apache.spark.mllib.evaluation.binary.BinaryConfusionMatrixImpl;
import org.apache.spark.mllib.evaluation.binary.BinaryLabelCounter;
import org.apache.spark.mllib.evaluation.binary.BinaryLabelCounter$;
import org.apache.spark.mllib.evaluation.binary.FMeasure;
import org.apache.spark.mllib.evaluation.binary.FalsePositiveRate$;
import org.apache.spark.mllib.evaluation.binary.Precision$;
import org.apache.spark.mllib.evaluation.binary.Recall$;
import org.apache.spark.rdd.OrderedRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005]g\u0001B\u000f\u001f\u0001%B\u0001B\u000e\u0001\u0003\u0006\u0004%\ta\u000e\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005q!AQ\u000b\u0001BC\u0002\u0013\u0005a\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003X\u0011\u0015i\u0006\u0001\"\u0001_\u0011\u001da\u0007A1A\u0005\u00025Dq!!\u0001\u0001A\u0003%a\u000e\u0003\u0004^\u0001\u0011\u0005\u0011Q\u0001\u0005\b;\u0002!\t\u0001IA\t\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fAq!!\u0013\u0001\t\u0003\tY\u0005C\u0004\u0002R\u0001!\t!a\u0015\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z!9\u0011Q\f\u0001\u0005\u0002\u0005M\u0003bBA1\u0001\u0011\u0005\u0011\u0011\f\u0005\b\u0003K\u0002A\u0011AA4\u0011\u001d\t)\u0007\u0001C\u0001\u0003'Bq!!\u001d\u0001\t\u0003\t\u0019\u0006C\u0004\u0002v\u0001!\t!a\u0015\t\u0019\u0005e\u0004\u0001%A\t\b\u0004&I!a\u001f\t\u0015\u0005e\u0005\u0001#b\u0001\n\u0013\tY\n\u0003\u0006\u0002\u001e\u0002A)\u0019!C\u0005\u0003?Cq!!)\u0001\t\u0013\t\u0019\u000bC\u0004\u0002\"\u0002!I!a,\b\u0013\u0005ef$!A\t\u0002\u0005mf\u0001C\u000f\u001f\u0003\u0003E\t!!0\t\ruSB\u0011AA`\u0011%\t\tMGI\u0001\n\u0003\t\u0019MA\u000eCS:\f'/_\"mCN\u001c\u0018NZ5dCRLwN\\'fiJL7m\u001d\u0006\u0003?\u0001\n!\"\u001a<bYV\fG/[8o\u0015\t\t#%A\u0003nY2L'M\u0003\u0002$I\u0005)1\u000f]1sW*\u0011QEJ\u0001\u0007CB\f7\r[3\u000b\u0003\u001d\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u00161!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0019\te.\u001f*fMB\u0011\u0011\u0007N\u0007\u0002e)\u00111GI\u0001\tS:$XM\u001d8bY&\u0011QG\r\u0002\b\u0019><w-\u001b8h\u00039\u00198m\u001c:f\u0003:$G*\u00192fYN,\u0012\u0001\u000f\u0019\u0003s\u0005\u00032AO\u001f@\u001b\u0005Y$B\u0001\u001f#\u0003\r\u0011H\rZ\u0005\u0003}m\u00121A\u0015#E!\t\u0001\u0015\t\u0004\u0001\u0005\u0013\t\u0013\u0011\u0011!A\u0001\u0006\u0003i%aA0%c\u0005y1oY8sK\u0006sG\rT1cK2\u001c\b\u0005K\u0002\u0003\u000b.\u0003\"AR%\u000e\u0003\u001dS!\u0001\u0013\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002K\u000f\n)1+\u001b8dK\u0006\nA*A\u00032]Mr\u0003'\u0005\u0002O#B\u00111fT\u0005\u0003!2\u0012qAT8uQ&tw\r\u0005\u0002,%&\u00111\u000b\f\u0002\b!J|G-^2uQ\r\tQiS\u0001\b]Vl')\u001b8t+\u00059\u0006CA\u0016Y\u0013\tIFFA\u0002J]RD3aA#L\u0003!qW/\u001c\"j]N\u0004\u0003f\u0001\u0003F\u0017\u00061A(\u001b8jiz\"2aX1h!\t\u0001\u0007!D\u0001\u001f\u0011\u00151T\u00011\u0001ca\t\u0019W\rE\u0002;{\u0011\u0004\"\u0001Q3\u0005\u0013\t\u000b\u0017\u0011!A\u0001\u0006\u0003i\u0005fA1F\u0017\"9Q+\u0002I\u0001\u0002\u00049\u0006fA4F\u0017\"\u001aQ!\u00126\"\u0003-\fQa\r\u00181]A\n\u0011c]2pe\u0016d\u0015MY3mg^+\u0017n\u001a5u+\u0005q\u0007c\u0001\u001e>_B!1\u0006\u001d:v\u0013\t\tHF\u0001\u0004UkBdWM\r\t\u0003WML!\u0001\u001e\u0017\u0003\r\u0011{WO\u00197f!\u0011Y\u0003O\u001d:)\r\u00199(p_?\u007f!\tY\u00030\u0003\u0002zY\tQA-\u001a9sK\u000e\fG/\u001a3\u0002\u000f5,7o]1hK\u0006\nA0\u0001)UQ\u0016\u0004c/\u0019:jC\ndW\r\t1tG>\u0014X\rT1cK2\u001cx+Z5hQR\u0004\u0007e\u001d5pk2$\u0007EY3!aJLg/\u0019;fA\u0005tG\rI<jY2\u0004#-\u001a\u0011sK6|g/\u001a3!S:\u0004CG\f\u0019/a9\nQa]5oG\u0016\f\u0013a`\u0001\u0006g9\"d\u0006M\u0001\u0013g\u000e|'/\u001a'bE\u0016d7oV3jO\"$\b\u0005\u000b\u0004\boj\\XP \u000b\u0004?\u0006\u001d\u0001B\u0002\u001c\t\u0001\u0004\tI\u0001E\u0002;{UDC\u0001C#\u0002\u000e\u0005\u0012\u0011qB\u0001\u0006c9\u0002d\u0006\r\u000b\u0004?\u0006M\u0001B\u0002\u001c\n\u0001\u0004\t)\u0002\u0005\u0003\u0002\u0018\u0005]b\u0002BA\r\u0003cqA!a\u0007\u0002.9!\u0011QDA\u0016\u001d\u0011\ty\"!\u000b\u000f\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\n)\u0003\u0019a$o\\8u}%\tq%\u0003\u0002&M%\u00111\u0005J\u0005\u0004\u0003_\u0011\u0013aA:rY&!\u00111GA\u001b\u0003\u001d\u0001\u0018mY6bO\u0016T1!a\f#\u0013\u0011\tI$a\u000f\u0003\u0013\u0011\u000bG/\u0019$sC6,'\u0002BA\u001a\u0003k\t\u0011\"\u001e8qKJ\u001c\u0018n\u001d;\u0015\u0005\u0005\u0005\u0003cA\u0016\u0002D%\u0019\u0011Q\t\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0005\u0015\u0015\u000bi!\u0001\u0006uQJ,7\u000f[8mIN$\"!!\u0014\u0011\u0007ij$\u000f\u000b\u0003\f\u000b\u00065\u0011a\u0001:pGR\u0011\u0011\u0011\u0002\u0015\u0005\u0019\u0015\u000bi!\u0001\u0007be\u0016\fWK\u001c3feJ{5\tF\u0001sQ\u0011iQ)!\u0004\u0002\u0005A\u0014\b\u0006\u0002\bF\u0003\u001b\t1\"\u0019:fCVsG-\u001a:Q%\"\"q\"RA\u0007\u0003M1W*Z1tkJ,')\u001f+ie\u0016\u001c\bn\u001c7e)\u0011\tI!!\u001b\t\r\u0005-\u0004\u00031\u0001s\u0003\u0011\u0011W\r^1)\tA)\u0015Q\u0002\u0015\u0005#\u0015\u000bi!\u0001\u000bqe\u0016\u001c\u0017n]5p]\nKH\u000b\u001b:fg\"|G\u000e\u001a\u0015\u0005%\u0015\u000bi!A\tsK\u000e\fG\u000e\u001c\"z)\"\u0014Xm\u001d5pY\u0012DCaE#\u0002\u000e\u0005\u0019\u0001\u0010J\u001a\u0016\u0005\u0005u\u0004CB\u0016q\u0003\u007f\ny\t\u0005\u0003;{\u0005\u0005\u0005#B\u0016qe\u0006\r\u0005\u0003BAC\u0003\u0017k!!a\"\u000b\u0007\u0005%e$\u0001\u0004cS:\f'/_\u0005\u0005\u0003\u001b\u000b9I\u0001\nCS:\f'/\u001f'bE\u0016d7i\\;oi\u0016\u0014\b\u0003\u0002\u001e>\u0003#\u0003Ra\u000b9s\u0003'\u0003B!!\"\u0002\u0016&!\u0011qSAD\u0005U\u0011\u0015N\\1ss\u000e{gNZ;tS>tW*\u0019;sSb\f\u0001cY;nk2\fG/\u001b<f\u0007>,h\u000e^:\u0016\u0005\u0005}\u0014AC2p]\u001a,8/[8ogV\u0011\u0011qR\u0001\fGJ,\u0017\r^3DkJ4X\r\u0006\u0003\u0002\n\u0005\u0015\u0006bBAT/\u0001\u0007\u0011\u0011V\u0001\u0002sB!\u0011QQAV\u0013\u0011\ti+a\"\u0003E\tKg.\u0019:z\u00072\f7o]5gS\u000e\fG/[8o\u001b\u0016$(/[2D_6\u0004X\u000f^3s)\u0019\tI!!-\u00026\"9\u00111\u0017\rA\u0002\u0005%\u0016!\u0001=\t\u000f\u0005\u001d\u0006\u00041\u0001\u0002*\"\"\u0001!RA\u0007\u0003m\u0011\u0015N\\1ss\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6+GO]5dgB\u0011\u0001MG\n\u00035)\"\"!a/\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t)MK\u0002X\u0003\u000f\\#!!3\u0011\t\u0005-\u00171[\u0007\u0003\u0003\u001bTA!a4\u0002R\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003\u00112JA!!6\u0002N\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class BinaryClassificationMetrics
implements Logging {
    private Tuple2<RDD<Tuple2<Object, BinaryLabelCounter>>, RDD<Tuple2<Object, BinaryConfusionMatrix>>> x$3;
    private RDD<Tuple2<Object, BinaryLabelCounter>> cumulativeCounts;
    private RDD<Tuple2<Object, BinaryConfusionMatrix>> confusions;
    private final RDD<? extends Product> scoreAndLabels;
    private final int numBins;
    private final RDD<Tuple2<Object, Tuple2<Object, Object>>> scoreLabelsWeight;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static int $lessinit$greater$default$2() {
        return BinaryClassificationMetrics$.MODULE$.$lessinit$greater$default$2();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public RDD<? extends Product> scoreAndLabels() {
        return this.scoreAndLabels;
    }

    public int numBins() {
        return this.numBins;
    }

    public RDD<Tuple2<Object, Tuple2<Object, Object>>> scoreLabelsWeight() {
        return this.scoreLabelsWeight;
    }

    public void unpersist() {
        this.cumulativeCounts().unpersist(this.cumulativeCounts().unpersist$default$1());
    }

    public RDD<Object> thresholds() {
        return this.cumulativeCounts().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1._1$mcD$sp()), (ClassTag)ClassTag$.MODULE$.Double());
    }

    public RDD<Tuple2<Object, Object>> roc() {
        RDD<Tuple2<Object, Object>> rocCurve = this.createCurve(FalsePositiveRate$.MODULE$, Recall$.MODULE$);
        int numParts = rocCurve.getNumPartitions();
        return rocCurve.mapPartitionsWithIndex((Function2 & Serializable)(x0$1, x1$1) -> BinaryClassificationMetrics.$anonfun$roc$1(numParts, BoxesRunTime.unboxToInt((Object)x0$1), x1$1), rocCurve.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public double areaUnderROC() {
        return AreaUnderCurve$.MODULE$.of(this.roc());
    }

    public RDD<Tuple2<Object, Object>> pr() {
        double firstPrecision;
        RDD<Tuple2<Object, Object>> prCurve = this.createCurve(Recall$.MODULE$, Precision$.MODULE$);
        Tuple2 tuple2 = (Tuple2)prCurve.first();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double d = firstPrecision = tuple2._2$mcD$sp();
        double firstPrecision2 = d;
        return prCurve.mapPartitionsWithIndex((Function2 & Serializable)(x0$1, x1$1) -> BinaryClassificationMetrics.$anonfun$pr$1(firstPrecision2, BoxesRunTime.unboxToInt((Object)x0$1), x1$1), prCurve.mapPartitionsWithIndex$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public double areaUnderPR() {
        return AreaUnderCurve$.MODULE$.of(this.pr());
    }

    public RDD<Tuple2<Object, Object>> fMeasureByThreshold(double beta) {
        return this.createCurve(new FMeasure(beta));
    }

    public RDD<Tuple2<Object, Object>> fMeasureByThreshold() {
        return this.fMeasureByThreshold(1.0);
    }

    public RDD<Tuple2<Object, Object>> precisionByThreshold() {
        return this.createCurve(Precision$.MODULE$);
    }

    public RDD<Tuple2<Object, Object>> recallByThreshold() {
        return this.createCurve(Recall$.MODULE$);
    }

    private Tuple2<RDD<Tuple2<Object, BinaryLabelCounter>>, RDD<Tuple2<Object, BinaryConfusionMatrix>>> x$3$lzycompute() {
        block10: {
            BinaryClassificationMetrics binaryClassificationMetrics = this;
            synchronized (binaryClassificationMetrics) {
                RDD rDD;
                RDD confusions;
                block12: {
                    Tuple2 tuple2;
                    block11: {
                        RDD rDD2;
                        if ((byte)(this.bitmap$0 & 1) != 0) break block10;
                        OrderedRDDFunctions qual$1 = RDD$.MODULE$.rddToOrderedRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(this.scoreLabelsWeight(), (ClassTag)ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$).combineByKey((Function1 & Serializable)labelAndWeight -> new BinaryLabelCounter(0.0, 0.0).$plus$eq(labelAndWeight._1$mcD$sp(), labelAndWeight._2$mcD$sp()), (Function2 & Serializable)(c, labelAndWeight) -> c.$plus$eq(labelAndWeight._1$mcD$sp(), labelAndWeight._2$mcD$sp()), (Function2 & Serializable)(c1, c2) -> c1.$plus$eq((BinaryLabelCounter)c2)), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$, (ClassTag)ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(BinaryLabelCounter.class));
                        boolean x$1 = false;
                        int x$2 = qual$1.sortByKey$default$2();
                        RDD counts = qual$1.sortByKey(false, x$2);
                        if (this.numBins() == 0) {
                            rDD2 = counts;
                        } else {
                            long countsSize = counts.count();
                            long grouping = countsSize / (long)this.numBins();
                            if (grouping < 2L) {
                                this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(44).append("Curve is too small (").append(countsSize).append(") for ").append(this.numBins()).append(" bins to be useful").toString());
                                rDD2 = counts;
                            } else {
                                rDD2 = counts.mapPartitions((Function1 & Serializable)iter -> {
                                    Iterator iterator;
                                    if (iter.hasNext()) {
                                        DoubleRef score = DoubleRef.create((double)Double.NaN);
                                        ObjectRef agg = ObjectRef.create((Object)new BinaryLabelCounter(BinaryLabelCounter$.MODULE$.$lessinit$greater$default$1(), BinaryLabelCounter$.MODULE$.$lessinit$greater$default$2()));
                                        LongRef cnt = LongRef.create((long)0L);
                                        iterator = iter.flatMap((Function1 & Serializable)pair -> {
                                            None$ none$;
                                            score$1.elem = pair._1$mcD$sp();
                                            ((BinaryLabelCounter)agg$1.elem).$plus$eq((BinaryLabelCounter)pair._2());
                                            ++cnt$1.elem;
                                            if (cnt$1.elem == grouping) {
                                                Tuple2 ret = new Tuple2((Object)BoxesRunTime.boxToDouble((double)score$1.elem), (Object)((BinaryLabelCounter)agg$1.elem));
                                                agg$1.elem = new BinaryLabelCounter(BinaryLabelCounter$.MODULE$.$lessinit$greater$default$1(), BinaryLabelCounter$.MODULE$.$lessinit$greater$default$2());
                                                cnt$1.elem = 0L;
                                                none$ = new Some((Object)ret);
                                            } else {
                                                none$ = None$.MODULE$;
                                            }
                                            return none$;
                                        }).$plus$plus((Function0 & Serializable)() -> cnt$1.elem > 0L ? package$.MODULE$.Iterator().single((Object)new Tuple2((Object)BoxesRunTime.boxToDouble((double)score$1.elem), (Object)((BinaryLabelCounter)agg$1.elem))) : package$.MODULE$.Iterator().empty());
                                    } else {
                                        iterator = package$.MODULE$.Iterator().empty();
                                    }
                                    return iterator;
                                }, counts.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
                            }
                        }
                        RDD binnedCounts = rDD2;
                        RDD qual$2 = RDD$.MODULE$.rddToPairRDDFunctions(binnedCounts, (ClassTag)ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.apply(BinaryLabelCounter.class), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$).values();
                        Function1 & Serializable x$3 = (Function1 & Serializable)iter -> {
                            BinaryLabelCounter agg = new BinaryLabelCounter(BinaryLabelCounter$.MODULE$.$lessinit$greater$default$1(), BinaryLabelCounter$.MODULE$.$lessinit$greater$default$2());
                            iter.foreach((Function1 & Serializable)x$2 -> agg.$plus$eq((BinaryLabelCounter)x$2));
                            return package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BinaryLabelCounter[]{agg}));
                        };
                        boolean x$4 = qual$2.mapPartitions$default$2();
                        BinaryLabelCounter[] agg2 = (BinaryLabelCounter[])qual$2.mapPartitions((Function1)x$3, x$4, ClassTag$.MODULE$.apply(BinaryLabelCounter.class)).collect();
                        BinaryLabelCounter[] partitionwiseCumulativeCounts = (BinaryLabelCounter[])ArrayOps$.MODULE$.scanLeft$extension(Predef$.MODULE$.refArrayOps((Object[])agg2), (Object)new BinaryLabelCounter(BinaryLabelCounter$.MODULE$.$lessinit$greater$default$1(), BinaryLabelCounter$.MODULE$.$lessinit$greater$default$2()), (Function2 & Serializable)(agg, c) -> agg.clone().$plus$eq((BinaryLabelCounter)c), ClassTag$.MODULE$.apply(BinaryLabelCounter.class));
                        BinaryLabelCounter totalCount = (BinaryLabelCounter)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])partitionwiseCumulativeCounts));
                        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(14).append("Total counts: ").append(totalCount).toString());
                        RDD cumulativeCounts = binnedCounts.mapPartitionsWithIndex((Function2 & Serializable)(index, iter) -> BinaryClassificationMetrics.$anonfun$x$3$12(partitionwiseCumulativeCounts, BoxesRunTime.unboxToInt((Object)index), iter), true, ClassTag$.MODULE$.apply(Tuple2.class));
                        cumulativeCounts.persist();
                        RDD confusions2 = cumulativeCounts.map((Function1 & Serializable)x0$2 -> {
                            Tuple2 tuple2 = x0$2;
                            if (tuple2 == null) {
                                throw new MatchError((Object)tuple2);
                            }
                            double score = tuple2._1$mcD$sp();
                            BinaryLabelCounter cumCount = (BinaryLabelCounter)tuple2._2();
                            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)score), (Object)new BinaryConfusionMatrixImpl(cumCount, totalCount));
                            return tuple22;
                        }, ClassTag$.MODULE$.apply(Tuple2.class));
                        tuple2 = new Tuple2((Object)cumulativeCounts, (Object)confusions2);
                        if (tuple2 == null) break block11;
                        RDD cumulativeCounts2 = (RDD)tuple2._1();
                        confusions = (RDD)tuple2._2();
                        if (cumulativeCounts2 == null) break block11;
                        rDD = cumulativeCounts2;
                        if (confusions != null) break block12;
                    }
                    throw new MatchError((Object)tuple2);
                }
                RDD rDD3 = confusions;
                Tuple2 tuple2 = new Tuple2((Object)rDD, (Object)rDD3);
                this.x$3 = tuple2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$3;
    }

    private /* synthetic */ Tuple2 x$3() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$3$lzycompute() : this.x$3;
    }

    private RDD<Tuple2<Object, BinaryLabelCounter>> cumulativeCounts$lzycompute() {
        BinaryClassificationMetrics binaryClassificationMetrics = this;
        synchronized (binaryClassificationMetrics) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.cumulativeCounts = (RDD)this.x$3()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.cumulativeCounts;
    }

    private RDD<Tuple2<Object, BinaryLabelCounter>> cumulativeCounts() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.cumulativeCounts$lzycompute() : this.cumulativeCounts;
    }

    private RDD<Tuple2<Object, BinaryConfusionMatrix>> confusions$lzycompute() {
        BinaryClassificationMetrics binaryClassificationMetrics = this;
        synchronized (binaryClassificationMetrics) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.confusions = (RDD)this.x$3()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.confusions;
    }

    private RDD<Tuple2<Object, BinaryConfusionMatrix>> confusions() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.confusions$lzycompute() : this.confusions;
    }

    private RDD<Tuple2<Object, Object>> createCurve(BinaryClassificationMetricComputer y) {
        return this.confusions().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double s = tuple2._1$mcD$sp();
            BinaryConfusionMatrix c = (BinaryConfusionMatrix)tuple2._2();
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(s, y.apply(c));
            return sp2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    private RDD<Tuple2<Object, Object>> createCurve(BinaryClassificationMetricComputer x, BinaryClassificationMetricComputer y) {
        return this.confusions().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BinaryConfusionMatrix c = (BinaryConfusionMatrix)tuple2._2();
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x.apply(c), y.apply(c));
            return sp2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public static final /* synthetic */ Iterator $anonfun$roc$1(int numParts$1, int x0$1, Iterator x1$1) {
        Iterator iterator;
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 != null) {
            int pid = tuple2._1$mcI$sp();
            Iterator iter = (Iterator)tuple2._2();
            if (numParts$1 == 1) {
                Predef$.MODULE$.require(pid == 0);
                iterator = package$.MODULE$.Iterator().single((Object)new Tuple2.mcDD.sp(0.0, 0.0)).$plus$plus((Function0 & Serializable)() -> iter).$plus$plus((Function0 & Serializable)() -> package$.MODULE$.Iterator().single((Object)new Tuple2.mcDD.sp(1.0, 1.0)));
            } else {
                iterator = pid == 0 ? package$.MODULE$.Iterator().single((Object)new Tuple2.mcDD.sp(0.0, 0.0)).$plus$plus((Function0 & Serializable)() -> iter) : (pid == numParts$1 - 1 ? iter.$plus$plus((Function0 & Serializable)() -> package$.MODULE$.Iterator().single((Object)new Tuple2.mcDD.sp(1.0, 1.0))) : iter);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        Iterator iterator2 = iterator;
        return iterator2;
    }

    public static final /* synthetic */ Iterator $anonfun$pr$1(double firstPrecision$1, int x0$1, Iterator x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int pid = tuple2._1$mcI$sp();
        Iterator iter = (Iterator)tuple2._2();
        Iterator iterator = pid == 0 ? package$.MODULE$.Iterator().single((Object)new Tuple2.mcDD.sp(0.0, firstPrecision$1)).$plus$plus((Function0 & Serializable)() -> iter) : iter;
        return iterator;
    }

    public static final /* synthetic */ Iterator $anonfun$x$3$12(BinaryLabelCounter[] partitionwiseCumulativeCounts$1, int index, Iterator iter) {
        BinaryLabelCounter cumCount = partitionwiseCumulativeCounts$1[index];
        return iter.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double score = tuple2._1$mcD$sp();
            BinaryLabelCounter c = (BinaryLabelCounter)tuple2._2();
            cumCount.$plus$eq(c);
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)score), (Object)cumCount.clone());
            return tuple22;
        });
    }

    public BinaryClassificationMetrics(RDD<? extends Product> scoreAndLabels, int numBins) {
        this.scoreAndLabels = scoreAndLabels;
        this.numBins = numBins;
        Logging.$init$((Logging)this);
        this.scoreLabelsWeight = scoreAndLabels.map((Function1 & Serializable)x0$1 -> {
            Product product = x0$1;
            if (product instanceof Tuple3) {
                Tuple3 tuple3 = (Tuple3)product;
                Object prediction = tuple3._1();
                Object label = tuple3._2();
                Object weight = tuple3._3();
                if (prediction instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)prediction);
                    if (label instanceof Double) {
                        double d2 = BoxesRunTime.unboxToDouble((Object)label);
                        if (weight instanceof Double) {
                            double d3 = BoxesRunTime.unboxToDouble((Object)weight);
                            Predef$.MODULE$.require(d3 >= 0.0, (Function0 & Serializable)() -> new StringBuilder(34).append("instance weight, ").append(d3).append(" has to be >= 0.0").toString());
                            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)d), (Object)new Tuple2.mcDD.sp(d2, d3));
                        }
                    }
                }
            }
            if (!(product instanceof Tuple2)) throw new IllegalArgumentException(new StringBuilder(21).append("Expected tuples, got ").append(product).toString());
            Tuple2 tuple2 = (Tuple2)product;
            Object prediction = tuple2._1();
            Object label = tuple2._2();
            if (!(prediction instanceof Double)) throw new IllegalArgumentException(new StringBuilder(21).append("Expected tuples, got ").append(product).toString());
            double d = BoxesRunTime.unboxToDouble((Object)prediction);
            if (!(label instanceof Double)) throw new IllegalArgumentException(new StringBuilder(21).append("Expected tuples, got ").append(product).toString());
            double d4 = BoxesRunTime.unboxToDouble((Object)label);
            return new Tuple2((Object)BoxesRunTime.boxToDouble((double)d), (Object)new Tuple2.mcDD.sp(d4, 1.0));
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        Predef$.MODULE$.require(numBins >= 0, (Function0 & Serializable)() -> "numBins must be nonnegative");
    }

    public BinaryClassificationMetrics(RDD<Tuple2<Object, Object>> scoreAndLabels) {
        this(scoreAndLabels, 0);
    }

    public BinaryClassificationMetrics(Dataset<Row> scoreAndLabels) {
        this((RDD<? extends Product>)scoreAndLabels.rdd().map((Function1)new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Tuple3<Object, Object, Object> apply(Row x0$1) {
                Some some;
                Row row = x0$1;
                if (row != null && !(some = Row$.MODULE$.unapplySeq(row)).isEmpty() && some.get() != null && ((SeqOps)some.get()).lengthCompare(3) == 0) {
                    Object prediction = ((SeqOps)some.get()).apply(0);
                    Object label = ((SeqOps)some.get()).apply(1);
                    Object weight = ((SeqOps)some.get()).apply(2);
                    if (prediction instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)prediction);
                        if (label instanceof Double) {
                            double d2 = BoxesRunTime.unboxToDouble((Object)label);
                            if (weight instanceof Double) {
                                double d3 = BoxesRunTime.unboxToDouble((Object)weight);
                                return new Tuple3((Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d2), (Object)BoxesRunTime.boxToDouble((double)d3));
                            }
                        }
                    }
                }
                if (row == null) throw new IllegalArgumentException(new StringBuilder(28).append("Expected Row of tuples, got ").append(row).toString());
                Some some2 = Row$.MODULE$.unapplySeq(row);
                if (some2.isEmpty()) throw new IllegalArgumentException(new StringBuilder(28).append("Expected Row of tuples, got ").append(row).toString());
                if (some2.get() == null) throw new IllegalArgumentException(new StringBuilder(28).append("Expected Row of tuples, got ").append(row).toString());
                if (((SeqOps)some2.get()).lengthCompare(2) != 0) throw new IllegalArgumentException(new StringBuilder(28).append("Expected Row of tuples, got ").append(row).toString());
                Object prediction = ((SeqOps)some2.get()).apply(0);
                Object label = ((SeqOps)some2.get()).apply(1);
                if (!(prediction instanceof Double)) throw new IllegalArgumentException(new StringBuilder(28).append("Expected Row of tuples, got ").append(row).toString());
                double d = BoxesRunTime.unboxToDouble((Object)prediction);
                if (!(label instanceof Double)) throw new IllegalArgumentException(new StringBuilder(28).append("Expected Row of tuples, got ").append(row).toString());
                double d4 = BoxesRunTime.unboxToDouble((Object)label);
                return new Tuple3((Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d4), (Object)BoxesRunTime.boxToDouble((double)1.0));
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class)), BinaryClassificationMetrics$.MODULE$.$lessinit$greater$default$2());
    }
}

