/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasVarianceCol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel$;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel$DecisionTreeRegressionModelWriter$;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite$;
import org.apache.spark.ml.tree.DecisionTreeModelReadWrite$NodeData$;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.DecisionTreeRegressorParams;
import org.apache.spark.ml.tree.HasVarianceImpurity;
import org.apache.spark.ml.tree.LeafNode;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.DefaultParamsReader$;
import org.apache.spark.ml.util.DefaultParamsWriter$;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\ted\u0001\u0002\u0013&\u0001AB\u0001\"\u0017\u0001\u0003\u0006\u0004%\tE\u0017\u0005\tG\u0002\u0011\t\u0011)A\u00057\"AA\r\u0001BC\u0002\u0013\u0005S\r\u0003\u0005j\u0001\t\u0005\t\u0015!\u0003g\u0011!Q\u0007A!b\u0001\n\u0003Z\u0007\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011\u00027\t\rE\u0004A\u0011A\u0014s\u0011\u00151\b\u0001\"\u0001x\u0011\u0019\t\b\u0001\"\u0001(w\")a\u0010\u0001C!\u007f\"9\u00111\u0002\u0001\u0005\u0012\u00055\u0001bBA\t\u0001\u0011\u0005\u00131\u0003\u0005\b\u0003w\u0001A\u0011IA\u001f\u0011\u001d\t)\t\u0001C!\u0003\u000fCq!a'\u0001\t\u0003\ni\n\u0003\u0006\u0002\"\u0002A)\u0019!C\u0001\u0003GC\u0001\"a*\u0001\t\u0003J\u0013\u0011\u0016\u0005\b\u0003w\u0003A\u0011IA_\u000f\u001d\tI-\nE\u0001\u0003\u00174a\u0001J\u0013\t\u0002\u00055\u0007BB9\u0015\t\u0003\tI\u000fC\u0004\u0002lR!\t%!<\t\u000f\u0005]H\u0003\"\u0011\u0002z\u001a9!\u0011\u0001\u000b\u0001)\t\r\u0001\"\u0003B\u00031\t\u0005\t\u0015!\u0003<\u0011\u0019\t\b\u0004\"\u0001\u0003\b!9!q\u0002\r\u0005R\tEaA\u0002B\u000e)\u0011\u0011i\u0002\u0003\u0004r9\u0011\u0005!q\u0004\u0005\n\u0005Ga\"\u0019!C\u0005\u0005KA\u0001B!\r\u001dA\u0003%!q\u0005\u0005\b\u0003odB\u0011\tB\u001a\u0011!\u00119\u0004\u0006C\u0001O\te\u0002B\u0003B+)E\u0005I\u0011A\u0014\u0003X!I!1\u000e\u000b\u0002\u0002\u0013%!Q\u000e\u0002\u001c\t\u0016\u001c\u0017n]5p]R\u0013X-\u001a*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\u0019:\u0013A\u0003:fOJ,7o]5p]*\u0011\u0001&K\u0001\u0003[2T!AK\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u0002\u0001'\u0019\u0001\u0011\u0007\u0010\"F\u0017B!!gM\u001b<\u001b\u0005)\u0013B\u0001\u001b&\u0005=\u0011Vm\u001a:fgNLwN\\'pI\u0016d\u0007C\u0001\u001c:\u001b\u00059$B\u0001\u001d(\u0003\u0019a\u0017N\\1mO&\u0011!h\u000e\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005I\u0002\u0001CA\u001fA\u001b\u0005q$BA (\u0003\u0011!(/Z3\n\u0005\u0005s$!\u0005#fG&\u001c\u0018n\u001c8Ue\u0016,Wj\u001c3fYB\u0011QhQ\u0005\u0003\tz\u00121\u0004R3dSNLwN\u001c+sK\u0016\u0014Vm\u001a:fgN|'\u000fU1sC6\u001c\bC\u0001$J\u001b\u00059%B\u0001%(\u0003\u0011)H/\u001b7\n\u0005);%AC'M/JLG/\u00192mKB\u0011AJ\u0016\b\u0003\u001bNs!AT)\u000e\u0003=S!\u0001U\u0018\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0016!B:dC2\f\u0017B\u0001+V\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011AU\u0005\u0003/b\u0013AbU3sS\u0006d\u0017N_1cY\u0016T!\u0001V+\u0002\u0007ULG-F\u0001\\!\ta\u0006M\u0004\u0002^=B\u0011a*V\u0005\u0003?V\u000ba\u0001\u0015:fI\u00164\u0017BA1c\u0005\u0019\u0019FO]5oO*\u0011q,V\u0001\u0005k&$\u0007%\u0001\u0005s_>$hj\u001c3f+\u00051\u0007CA\u001fh\u0013\tAgH\u0001\u0003O_\u0012,\u0017!\u0003:p_Rtu\u000eZ3!\u0003-qW/\u001c$fCR,(/Z:\u0016\u00031\u0004\"!\u001c8\u000e\u0003UK!a\\+\u0003\u0007%sG/\u0001\u0007ok64U-\u0019;ve\u0016\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0005wM$X\u000fC\u0003Z\u000f\u0001\u00071\fC\u0003e\u000f\u0001\u0007a\rC\u0003k\u000f\u0001\u0007A.\u0001\btKR4\u0016M]5b]\u000e,7i\u001c7\u0015\u0005aLX\"\u0001\u0001\t\u000biD\u0001\u0019A.\u0002\u000bY\fG.^3\u0015\u0007mbX\u0010C\u0003e\u0013\u0001\u0007a\rC\u0003k\u0013\u0001\u0007A.A\u0004qe\u0016$\u0017n\u0019;\u0015\t\u0005\u0005\u0011q\u0001\t\u0004[\u0006\r\u0011bAA\u0003+\n1Ai\\;cY\u0016Da!!\u0003\u000b\u0001\u0004)\u0014\u0001\u00034fCR,(/Z:\u0002\u001fA\u0014X\rZ5diZ\u000b'/[1oG\u0016$B!!\u0001\u0002\u0010!1\u0011\u0011B\u0006A\u0002U\nq\u0002\u001e:b]N4wN]7TG\",W.\u0019\u000b\u0005\u0003+\t)\u0003\u0005\u0003\u0002\u0018\u0005\u0005RBAA\r\u0015\u0011\tY\"!\b\u0002\u000bQL\b/Z:\u000b\u0007\u0005}\u0011&A\u0002tc2LA!a\t\u0002\u001a\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000f\u0005\u001dB\u00021\u0001\u0002\u0016\u000511o\u00195f[\u0006DS\u0001DA\u0016\u0003o\u0001B!!\f\u000245\u0011\u0011q\u0006\u0006\u0004\u0003cI\u0013AC1o]>$\u0018\r^5p]&!\u0011QGA\u0018\u0005\u0015\u0019\u0016N\\2fC\t\tI$A\u00032]Qr\u0003'A\u0005ue\u0006t7OZ8s[R!\u0011qHA.!\u0011\t\t%!\u0016\u000f\t\u0005\r\u00131\u000b\b\u0005\u0003\u000b\n\tF\u0004\u0003\u0002H\u0005=c\u0002BA%\u0003\u001br1ATA&\u0013\u0005q\u0013B\u0001\u0017.\u0013\tQ3&C\u0002\u0002 %J1\u0001VA\u000f\u0013\u0011\t9&!\u0017\u0003\u0013\u0011\u000bG/\u0019$sC6,'b\u0001+\u0002\u001e!9\u0011QL\u0007A\u0002\u0005}\u0013a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003C\ni\u0007\u0005\u0004\u0002d\u0005\u0015\u0014\u0011N\u0007\u0003\u0003;IA!a\u001a\u0002\u001e\t9A)\u0019;bg\u0016$\b\u0003BA6\u0003[b\u0001\u0001\u0002\u0007\u0002p\u0005m\u0013\u0011!A\u0001\u0006\u0003\t\tHA\u0002`II\nB!a\u001d\u0002zA\u0019Q.!\u001e\n\u0007\u0005]TKA\u0004O_RD\u0017N\\4\u0011\u00075\fY(C\u0002\u0002~U\u00131!\u00118zQ\u0015i\u00111FAAC\t\t\u0019)A\u00033]Ar\u0003'\u0001\u0003d_BLHcA\u001e\u0002\n\"9\u00111\u0012\bA\u0002\u00055\u0015!B3yiJ\f\u0007\u0003BAH\u0003+k!!!%\u000b\u0007\u0005Mu%A\u0003qCJ\fW.\u0003\u0003\u0002\u0018\u0006E%\u0001\u0003)be\u0006lW*\u00199)\u000b9\tY#a\u000e\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012a\u0017\u0015\u0006\u001f\u0005-\u0012qG\u0001\u0013M\u0016\fG/\u001e:f\u00136\u0004xN\u001d;b]\u000e,7/F\u00016Q\u0015\u0001\u00121FAA\u0003\u0015!xn\u00147e+\t\tY\u000b\u0005\u0003\u0002.\u0006eVBAAX\u0015\u0011\t\t,a-\u0002\u000b5|G-\u001a7\u000b\u0007}\n)LC\u0002\u00028&\nQ!\u001c7mS\nL1!QAX\u0003\u00159(/\u001b;f+\t\ty\fE\u0002G\u0003\u0003L1!a1H\u0005!iEj\u0016:ji\u0016\u0014\b&\u0002\n\u0002,\u0005\u0005\u0005&\u0002\u0001\u0002,\u0005]\u0012a\u0007#fG&\u001c\u0018n\u001c8Ue\u0016,'+Z4sKN\u001c\u0018n\u001c8N_\u0012,G\u000e\u0005\u00023)M9A#a4\u0002V\u0006m\u0007cA7\u0002R&\u0019\u00111[+\u0003\r\u0005s\u0017PU3g!\u00111\u0015q[\u001e\n\u0007\u0005ewI\u0001\u0006N\u0019J+\u0017\rZ1cY\u0016\u0004B!!8\u0002h6\u0011\u0011q\u001c\u0006\u0005\u0003C\f\u0019/\u0001\u0002j_*\u0011\u0011Q]\u0001\u0005U\u00064\u0018-C\u0002X\u0003?$\"!a3\u0002\tI,\u0017\rZ\u000b\u0003\u0003_\u0004BARAyw%\u0019\u00111_$\u0003\u00115c%+Z1eKJDSAFA\u0016\u0003\u0003\u000bA\u0001\\8bIR\u00191(a?\t\r\u0005ux\u00031\u0001\\\u0003\u0011\u0001\u0018\r\u001e5)\u000b]\tY#!!\u0003C\u0011+7-[:j_:$&/Z3SK\u001e\u0014Xm]:j_:lu\u000eZ3m/JLG/\u001a:\u0014\u0007a\ty,\u0001\u0005j]N$\u0018M\\2f)\u0011\u0011IA!\u0004\u0011\u0007\t-\u0001$D\u0001\u0015\u0011\u0019\u0011)A\u0007a\u0001w\u0005A1/\u0019<f\u00136\u0004H\u000e\u0006\u0003\u0003\u0014\te\u0001cA7\u0003\u0016%\u0019!qC+\u0003\tUs\u0017\u000e\u001e\u0005\u0007\u0003{\\\u0002\u0019A.\u0003C\u0011+7-[:j_:$&/Z3SK\u001e\u0014Xm]:j_:lu\u000eZ3m%\u0016\fG-\u001a:\u0014\u0007q\ty\u000f\u0006\u0002\u0003\"A\u0019!1\u0002\u000f\u0002\u0013\rd\u0017m]:OC6,WC\u0001B\u0014!\u0011\u0011ICa\f\u000e\u0005\t-\"\u0002\u0002B\u0017\u0003G\fA\u0001\\1oO&\u0019\u0011Ma\u000b\u0002\u0015\rd\u0017m]:OC6,\u0007\u0005F\u0002<\u0005kAa!!@!\u0001\u0004Y\u0016a\u00024s_6|E\u000e\u001a\u000b\nw\tm\"q\bB%\u0005'BqA!\u0010\"\u0001\u0004\tY+\u0001\u0005pY\u0012lu\u000eZ3m\u0011\u001d\u0011\t%\ta\u0001\u0005\u0007\na\u0001]1sK:$\bc\u0001\u001a\u0003F%\u0019!qI\u0013\u0003+\u0011+7-[:j_:$&/Z3SK\u001e\u0014Xm]:pe\"9!1J\u0011A\u0002\t5\u0013aE2bi\u0016<wN]5dC24U-\u0019;ve\u0016\u001c\b#\u0002/\u0003P1d\u0017b\u0001B)E\n\u0019Q*\u00199\t\u000f)\f\u0003\u0013!a\u0001Y\u0006\tbM]8n\u001f2$G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\te#f\u00017\u0003\\-\u0012!Q\f\t\u0005\u0005?\u00129'\u0004\u0002\u0003b)!!1\rB3\u0003%)hn\u00195fG.,GMC\u0002\u00022UKAA!\u001b\u0003b\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t=\u0004\u0003\u0002B\u0015\u0005cJAAa\u001d\u0003,\t1qJ\u00196fGRDS\u0001FA\u0016\u0003\u0003CSaEA\u0016\u0003\u0003\u0003")
public class DecisionTreeRegressionModel
extends RegressionModel<Vector, DecisionTreeRegressionModel>
implements DecisionTreeModel,
DecisionTreeRegressorParams,
MLWritable {
    private Vector featureImportances;
    private final String uid;
    private final Node rootNode;
    private final int numFeatures;
    private Param<String> varianceCol;
    private Param<String> impurity;
    private Param<String> leafCol;
    private IntParam maxDepth;
    private IntParam maxBins;
    private IntParam minInstancesPerNode;
    private DoubleParam minWeightFractionPerNode;
    private DoubleParam minInfoGain;
    private IntParam maxMemoryInMB;
    private BooleanParam cacheNodeIds;
    private Param<String> weightCol;
    private LongParam seed;
    private IntParam checkpointInterval;
    private int depth;
    private int numLeave;
    private NominalAttribute leafAttr;
    private transient Map<LeafNode, Object> org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    public static DecisionTreeRegressionModel load(String path) {
        return DecisionTreeRegressionModel$.MODULE$.load(path);
    }

    public static MLReader<DecisionTreeRegressionModel> read() {
        return DecisionTreeRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$DecisionTreeRegressorParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return DecisionTreeRegressorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final String getVarianceCol() {
        return HasVarianceCol.getVarianceCol$(this);
    }

    @Override
    public final String getImpurity() {
        return HasVarianceImpurity.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return HasVarianceImpurity.getOldImpurity$(this);
    }

    @Override
    public final DecisionTreeParams setLeafCol(String value) {
        return DecisionTreeParams.setLeafCol$(this, value);
    }

    @Override
    public final String getLeafCol() {
        return DecisionTreeParams.getLeafCol$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinWeightFractionPerNode() {
        return DecisionTreeParams.getMinWeightFractionPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    @Override
    public int numNodes() {
        return DecisionTreeModel.numNodes$(this);
    }

    @Override
    public String toDebugString() {
        return DecisionTreeModel.toDebugString$(this);
    }

    @Override
    public int maxSplitFeatureIndex() {
        return DecisionTreeModel.maxSplitFeatureIndex$(this);
    }

    @Override
    public StructField getLeafField(String leafCol) {
        return DecisionTreeModel.getLeafField$(this, leafCol);
    }

    @Override
    public double predictLeaf(Vector features) {
        return DecisionTreeModel.predictLeaf$(this, features);
    }

    @Override
    public final Param<String> varianceCol() {
        return this.varianceCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasVarianceCol$_setter_$varianceCol_$eq(Param<String> x$1) {
        this.varianceCol = x$1;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$HasVarianceImpurity$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final Param<String> leafCol() {
        return this.leafCol;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minWeightFractionPerNode() {
        return this.minWeightFractionPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$leafCol_$eq(Param<String> x$1) {
        this.leafCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minWeightFractionPerNode_$eq(DoubleParam x$1) {
        this.minWeightFractionPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    private int depth$lzycompute() {
        DecisionTreeRegressionModel decisionTreeRegressionModel = this;
        synchronized (decisionTreeRegressionModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.depth = DecisionTreeModel.depth$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.depth;
    }

    @Override
    public int depth() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.depth$lzycompute() : this.depth;
    }

    private int numLeave$lzycompute() {
        DecisionTreeRegressionModel decisionTreeRegressionModel = this;
        synchronized (decisionTreeRegressionModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.numLeave = DecisionTreeModel.numLeave$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.numLeave;
    }

    @Override
    public int numLeave() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.numLeave$lzycompute() : this.numLeave;
    }

    private NominalAttribute leafAttr$lzycompute() {
        DecisionTreeRegressionModel decisionTreeRegressionModel = this;
        synchronized (decisionTreeRegressionModel) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.leafAttr = DecisionTreeModel.leafAttr$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.leafAttr;
    }

    @Override
    public NominalAttribute leafAttr() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.leafAttr$lzycompute() : this.leafAttr;
    }

    private Map<LeafNode, Object> org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices$lzycompute() {
        DecisionTreeRegressionModel decisionTreeRegressionModel = this;
        synchronized (decisionTreeRegressionModel) {
            if (!this.bitmap$trans$0) {
                this.org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices = DecisionTreeModel.org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices;
    }

    @Override
    public Map<LeafNode, Object> org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices() {
        return !this.bitmap$trans$0 ? this.org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices$lzycompute() : this.org$apache$spark$ml$tree$DecisionTreeModel$$leafIndices;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    @Override
    public Node rootNode() {
        return this.rootNode;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public DecisionTreeRegressionModel setVarianceCol(String value) {
        return (DecisionTreeRegressionModel)this.set(this.varianceCol(), value);
    }

    @Override
    public double predict(Vector features) {
        return this.rootNode().predictImpl(features).prediction();
    }

    public double predictVariance(Vector features) {
        return this.rootNode().predictImpl(features).impurityStats().calculate();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StructType transformSchema(StructType schema) {
        void var2_2;
        block1: {
            StructType outputSchema = super.transformSchema(schema);
            if (this.isDefined(this.varianceCol()) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.varianceCol())))) {
                outputSchema = SchemaUtils$.MODULE$.updateNumeric(outputSchema, this.$(this.varianceCol()));
            }
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) break block1;
            outputSchema = SchemaUtils$.MODULE$.updateField(outputSchema, this.getLeafField(this.$(this.leafCol())), SchemaUtils$.MODULE$.updateField$default$3());
        }
        return var2_2;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Seq predictionColNames = (Seq)package$.MODULE$.Seq().empty();
        Seq predictionColumns = (Seq)package$.MODULE$.Seq().empty();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(DecisionTreeRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator1$1(DecisionTreeRegressionModel $outer) {
                }
            }
            UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)this.predict(features)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator1$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.predictionCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)predictUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.predictionCol()), outputSchema.apply(this.$(this.predictionCol())).metadata()));
        }
        if (this.isDefined(this.varianceCol()) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.varianceCol())))) {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(DecisionTreeRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator2$1(DecisionTreeRegressionModel $outer) {
                }
            }
            UserDefinedFunction predictVarianceUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)this.predictVariance(features)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator2$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.varianceCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)predictVarianceUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.varianceCol()), outputSchema.apply(this.$(this.varianceCol())).metadata()));
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) {
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(DecisionTreeRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator3$1(DecisionTreeRegressionModel $outer) {
                }
            }
            UserDefinedFunction leafUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)this.predictLeaf(features)), ((TypeTags)scala.reflect.runtime.package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_DecisionTreeRegressionModel$$typecreator3$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.leafCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)leafUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.leafCol()), outputSchema.apply(this.$(this.leafCol())).metadata()));
        }
        if (predictionColNames.nonEmpty()) {
            dataset2 = dataset.withColumns(predictionColNames, predictionColumns);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append(new StringBuilder(54).append(this.uid()).append(": DecisionTreeRegressionModel.transform() does nothing").toString()).append(" because no output columns were set.").toString());
            dataset2 = dataset.toDF();
        }
        return dataset2;
    }

    @Override
    public DecisionTreeRegressionModel copy(ParamMap extra) {
        return (DecisionTreeRegressionModel)((Model)this.copyValues(new DecisionTreeRegressionModel(this.uid(), this.rootNode(), this.numFeatures()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return new StringBuilder(0).append(new StringBuilder(54).append("DecisionTreeRegressionModel: uid=").append(this.uid()).append(", depth=").append(this.depth()).append(", numNodes=").append(this.numNodes()).append(", ").toString()).append(new StringBuilder(12).append("numFeatures=").append(this.numFeatures()).toString()).toString();
    }

    private Vector featureImportances$lzycompute() {
        DecisionTreeRegressionModel decisionTreeRegressionModel = this;
        synchronized (decisionTreeRegressionModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this, this.numFeatures(), ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.featureImportances$lzycompute() : this.featureImportances;
    }

    @Override
    public org.apache.spark.mllib.tree.model.DecisionTreeModel toOld() {
        return new org.apache.spark.mllib.tree.model.DecisionTreeModel(this.rootNode().toOld(1), Algo$.MODULE$.Regression());
    }

    @Override
    public MLWriter write() {
        return new DecisionTreeRegressionModelWriter(this);
    }

    public DecisionTreeRegressionModel(String uid, Node rootNode, int numFeatures) {
        this.uid = uid;
        this.rootNode = rootNode;
        this.numFeatures = numFeatures;
        DecisionTreeModel.$init$(this);
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        HasWeightCol.$init$(this);
        DecisionTreeParams.$init$(this);
        HasVarianceImpurity.$init$(this);
        HasVarianceCol.$init$(this);
        DecisionTreeRegressorParams.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(rootNode != null, (Function0 & Serializable)() -> "DecisionTreeRegressionModel given null rootNode, but it requires a non-null rootNode.");
        Statics.releaseFence();
    }

    public DecisionTreeRegressionModel(Node rootNode, int numFeatures) {
        this(Identifiable$.MODULE$.randomUID("dtr"), rootNode, numFeatures);
    }

    private static class DecisionTreeRegressionModelReader
    extends MLReader<DecisionTreeRegressionModel> {
        private final String className = DecisionTreeRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        @Override
        public DecisionTreeRegressionModel load(String path) {
            DefaultFormats$ format = DefaultFormats$.MODULE$;
            DefaultParamsReader.Metadata metadata = DefaultParamsReader$.MODULE$.loadMetadata(path, this.sc(), this.className());
            int numFeatures = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(metadata.metadata()).$bslash("numFeatures")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            Node root = DecisionTreeModelReadWrite$.MODULE$.loadTreeNodes(path, metadata, this.sparkSession());
            DecisionTreeRegressionModel model = new DecisionTreeRegressionModel(metadata.uid(), root, numFeatures);
            metadata.getAndSetParams(model, metadata.getAndSetParams$default$2());
            return model;
        }
    }

    public static class DecisionTreeRegressionModelWriter
    extends MLWriter {
        private final DecisionTreeRegressionModel instance;

        @Override
        public void saveImpl(String path) {
            Seq nodeData;
            JsonAST.JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures()))})), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            DefaultParamsWriter$.MODULE$.saveMetadata(this.instance, path, this.sc(), (Option<JsonAST.JObject>)new Some((Object)extraMetadata), DefaultParamsWriter$.MODULE$.saveMetadata$default$5());
            Tuple2<Seq<DecisionTreeModelReadWrite.NodeData>, Object> tuple2 = DecisionTreeModelReadWrite$NodeData$.MODULE$.build(this.instance.rootNode(), 0);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq seq = nodeData = (Seq)tuple2._1();
            Seq nodeData2 = seq;
            String dataPath = new Path(path, "data").toString();
            int numDataParts = DecisionTreeModelReadWrite$NodeData$.MODULE$.inferNumPartitions(this.instance.numNodes());
            JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(DecisionTreeRegressionModelWriter.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_DecisionTreeRegressionModel$DecisionTreeRegressionModelWriter$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("org")), (Symbols.SymbolApi)$m.staticPackage("org.apache")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.ml")), (Symbols.SymbolApi)$m.staticPackage("org.apache.spark.ml.tree")), (Symbols.SymbolApi)$m.staticModule("org.apache.spark.ml.tree.DecisionTreeModelReadWrite")), (Symbols.SymbolApi)$m.staticClass("org.apache.spark.ml.tree.DecisionTreeModelReadWrite.NodeData"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_ml_regression_DecisionTreeRegressionModel$DecisionTreeRegressionModelWriter$$typecreator1$2(DecisionTreeRegressionModelWriter $outer) {
                }
            }
            this.sparkSession().createDataFrame(nodeData2, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_DecisionTreeRegressionModel$DecisionTreeRegressionModelWriter$$typecreator1$2(null))).repartition(numDataParts).write().parquet(dataPath);
        }

        public DecisionTreeRegressionModelWriter(DecisionTreeRegressionModel instance) {
            this.instance = instance;
        }
    }
}

