/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.linalg;

import java.io.Serializable;
import org.apache.spark.ml.linalg.DenseMatrix;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.SparseMatrix;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u00054Qa\u0003\u0007\u0001!YAQa\t\u0001\u0005\u0002\u0015BQa\n\u0001\u0005B!BQ\u0001\f\u0001\u0005B5BQA\u000e\u0001\u0005B]BQ\u0001\u0011\u0001\u0005B\u0005CQ!\u0014\u0001\u0005B9CQ\u0001\u0016\u0001\u0005BUCQ!\u0017\u0001\u0005BiCQA\u0018\u0001\u0005BiCaa\u0018\u0001\u0005BA\u0001'!C'biJL\u00070\u0016#U\u0015\tia\"\u0001\u0004mS:\fGn\u001a\u0006\u0003\u001fA\t!!\u001c7\u000b\u0005E\u0011\u0012!B:qCJ\\'BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001c\"\u0001A\f\u0011\u0007air$D\u0001\u001a\u0015\tQ2$A\u0003usB,7O\u0003\u0002\u001d!\u0005\u00191/\u001d7\n\u0005yI\"aD+tKJ$UMZ5oK\u0012$\u0016\u0010]3\u0011\u0005\u0001\nS\"\u0001\u0007\n\u0005\tb!AB'biJL\u00070\u0001\u0004=S:LGOP\u0002\u0001)\u00051\u0003C\u0001\u0011\u0001\u0003\u001d\u0019\u0018\u000f\u001c+za\u0016,\u0012!\u000b\t\u00031)J!aK\r\u0003\u0015M#(/^2u)f\u0004X-A\u0005tKJL\u0017\r\\5{KR\u0011a\u0006\u000e\t\u0003_Ij\u0011\u0001\r\u0006\u0003cm\t\u0001bY1uC2L8\u000f^\u0005\u0003gA\u00121\"\u00138uKJt\u0017\r\u001c*po\")Qg\u0001a\u0001?\u0005\u0019qN\u00196\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0003?aBQ!\u000f\u0003A\u0002i\nQ\u0001Z1uk6\u0004\"a\u000f \u000e\u0003qR\u0011!P\u0001\u0006g\u000e\fG.Y\u0005\u0003\u007fq\u00121!\u00118z\u0003%)8/\u001a:DY\u0006\u001c8/F\u0001C!\r\u0019%j\b\b\u0003\t\"\u0003\"!\u0012\u001f\u000e\u0003\u0019S!a\u0012\u0013\u0002\rq\u0012xn\u001c;?\u0013\tIE(\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u00172\u0013Qa\u00117bgNT!!\u0013\u001f\u0002\r\u0015\fX/\u00197t)\ty%\u000b\u0005\u0002<!&\u0011\u0011\u000b\u0010\u0002\b\u0005>|G.Z1o\u0011\u0015\u0019f\u00011\u0001;\u0003\u0005y\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003Y\u0003\"aO,\n\u0005ac$aA%oi\u0006AA/\u001f9f\u001d\u0006lW-F\u0001\\!\t\u0019E,\u0003\u0002^\u0019\n11\u000b\u001e:j]\u001e\fQ\u0001]=V\tR\u000b!\"Y:Ok2d\u0017M\u00197f+\u00051\u0003")
public class MatrixUDT
extends UserDefinedType<Matrix> {
    public StructType sqlType() {
        return new StructType((StructField[])((Object[])new StructField[]{new StructField("type", (DataType)ByteType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("numRows", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("numCols", (DataType)IntegerType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), new StructField("colPtrs", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), new StructField("rowIndices", (DataType)new ArrayType((DataType)IntegerType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), new StructField("values", (DataType)new ArrayType((DataType)DoubleType$.MODULE$, false), true, StructField$.MODULE$.apply$default$4()), new StructField("isTransposed", (DataType)BooleanType$.MODULE$, false, StructField$.MODULE$.apply$default$4())}));
    }

    /*
     * WARNING - void declaration
     */
    public InternalRow serialize(Matrix obj) {
        void var3_2;
        GenericInternalRow row = new GenericInternalRow(7);
        Matrix matrix = obj;
        if (matrix instanceof SparseMatrix) {
            SparseMatrix sparseMatrix = (SparseMatrix)matrix;
            row.setByte(0, (byte)0);
            row.setInt(1, sparseMatrix.numRows());
            row.setInt(2, sparseMatrix.numCols());
            row.update(3, (Object)UnsafeArrayData.fromPrimitiveArray((int[])sparseMatrix.colPtrs()));
            row.update(4, (Object)UnsafeArrayData.fromPrimitiveArray((int[])sparseMatrix.rowIndices()));
            row.update(5, (Object)UnsafeArrayData.fromPrimitiveArray((double[])sparseMatrix.values()));
            row.setBoolean(6, sparseMatrix.isTransposed());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (matrix instanceof DenseMatrix) {
            DenseMatrix denseMatrix = (DenseMatrix)matrix;
            row.setByte(0, (byte)1);
            row.setInt(1, denseMatrix.numRows());
            row.setInt(2, denseMatrix.numCols());
            row.setNullAt(3);
            row.setNullAt(4);
            row.update(5, (Object)UnsafeArrayData.fromPrimitiveArray((double[])denseMatrix.values()));
            row.setBoolean(6, denseMatrix.isTransposed());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)matrix);
        }
        return var3_2;
    }

    public Matrix deserialize(Object datum) {
        DenseMatrix denseMatrix;
        Object object = datum;
        if (object instanceof InternalRow) {
            InternalRow internalRow = (InternalRow)object;
            Predef$.MODULE$.require(internalRow.numFields() == 7, (Function0 & Serializable)() -> new StringBuilder(69).append("MatrixUDT.deserialize given row with length ").append(internalRow.numFields()).append(" but requires length == 7").toString());
            byte tpe = internalRow.getByte(0);
            int numRows = internalRow.getInt(1);
            int numCols = internalRow.getInt(2);
            double[] values = internalRow.getArray(5).toDoubleArray();
            boolean isTransposed = internalRow.getBoolean(6);
            byte by = tpe;
            switch (by) {
                case 0: {
                    int[] colPtrs = internalRow.getArray(3).toIntArray();
                    int[] rowIndices = internalRow.getArray(4).toIntArray();
                    denseMatrix = new SparseMatrix(numRows, numCols, colPtrs, rowIndices, values, isTransposed);
                    break;
                }
                case 1: {
                    denseMatrix = new DenseMatrix(numRows, numCols, values, isTransposed);
                    break;
                }
                default: {
                    throw new MatchError((Object)BoxesRunTime.boxToByte((byte)by));
                }
            }
        } else {
            throw new MatchError(object);
        }
        DenseMatrix denseMatrix2 = denseMatrix;
        return denseMatrix2;
    }

    public Class<Matrix> userClass() {
        return Matrix.class;
    }

    public boolean equals(Object o) {
        Object object = o;
        boolean bl = object instanceof MatrixUDT;
        return bl;
    }

    public int hashCode() {
        return MatrixUDT.class.getName().hashCode();
    }

    public String typeName() {
        return "matrix";
    }

    public String pyUDT() {
        return "pyspark.ml.linalg.MatrixUDT";
    }

    public MatrixUDT asNullable() {
        return this;
    }
}

