/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrimLeft$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the leading space characters from `str`.\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u00055x!B\u0012%\u0011\u0003\td!B\u001a%\u0011\u0003!\u0004\"B\"\u0002\t\u0003!\u0005\"B#\u0002\t\u00031\u0005BB#\u0002\t\u0003\t)\r\u0003\u0005F\u0003\u0005\u0005I\u0011QAe\u0011%\ty-AI\u0001\n\u0003\t9\u0005C\u0005\u0002R\u0006\t\t\u0011\"!\u0002T\"I\u0011\u0011]\u0001\u0012\u0002\u0013\u0005\u0011q\t\u0005\n\u0003G\f\u0011\u0011!C\u0005\u0003K4Aa\r\u0013A\u0011\"AQL\u0003BK\u0002\u0013\u0005a\f\u0003\u0005`\u0015\tE\t\u0015!\u0003J\u0011!\u0001'B!f\u0001\n\u0003\t\u0007\u0002C3\u000b\u0005#\u0005\u000b\u0011\u00022\t\u000b\rSA\u0011\u00014\t\u000b\rSA\u0011A5\t\u000b\rSA\u0011\u00017\t\u000b9TA\u0011I8\t\u000baTA\u0011K8\t\u000beTA\u0011\t>\t\reTA\u0011IA\u0006\u0011!\t\u0019B\u0003b\u0001\n\u0003z\u0007bBA\u000b\u0015\u0001\u0006I\u0001\u001d\u0005\b\u0003/QA\u0011KA\r\u0011%\t)CCA\u0001\n\u0003\t9\u0003C\u0005\u0002.)\t\n\u0011\"\u0001\u00020!I\u0011Q\t\u0006\u0012\u0002\u0013\u0005\u0011q\t\u0005\n\u0003\u0017R\u0011\u0011!C!\u0003\u001bB\u0011\"!\u0017\u000b\u0003\u0003%\t!a\u0017\t\u0013\u0005\r$\"!A\u0005\u0002\u0005\u0015\u0004\"CA9\u0015\u0005\u0005I\u0011IA:\u0011%\t\tICA\u0001\n\u0003\t\u0019\tC\u0005\u0002\u000e*\t\t\u0011\"\u0011\u0002\u0010\"I\u00111\u0013\u0006\u0002\u0002\u0013\u0005\u0013QS\u0001\u000f'R\u0014\u0018N\\4Ue&lG*\u001a4u\u0015\t)c%A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0014)\u0003!\u0019\u0017\r^1msN$(BA\u0015+\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003W1\nQa\u001d9be.T!!\f\u0018\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0013aA8sO\u000e\u0001\u0001C\u0001\u001a\u0002\u001b\u0005!#AD*ue&tw\r\u0016:j[2+g\r^\n\u0004\u0003UZ\u0004C\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$AB!osJ+g\r\u0005\u0002=\u00036\tQH\u0003\u0002?\u007f\u0005\u0011\u0011n\u001c\u0006\u0002\u0001\u0006!!.\u0019<b\u0013\t\u0011UH\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGO\u0010\u000b\u0002c\u0005)\u0011\r\u001d9msR)q)a0\u0002DB\u0011!GC\n\u0006\u0015%cuJ\u0015\t\u0003e)K!a\u0013\u0013\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u00023\u001b&\u0011a\n\n\u0002\u0016'R\u0014\u0018N\\43)JLW.\u0012=qe\u0016\u001c8/[8o!\t1\u0004+\u0003\u0002Ro\t9\u0001K]8ek\u000e$\bCA*\\\u001d\t!\u0016L\u0004\u0002V16\taK\u0003\u0002Xa\u00051AH]8pizJ\u0011\u0001O\u0005\u00035^\nq\u0001]1dW\u0006<W-\u0003\u0002C9*\u0011!lN\u0001\u0007gJ\u001c7\u000b\u001e:\u0016\u0003%\u000bqa\u001d:d'R\u0014\b%A\u0004ue&l7\u000b\u001e:\u0016\u0003\t\u00042AN2J\u0013\t!wG\u0001\u0004PaRLwN\\\u0001\tiJLWn\u0015;sAQ\u0019qi\u001a5\t\u000bu{\u0001\u0019A%\t\u000f\u0001|\u0001\u0013!a\u0001ER\u0019qI[6\t\u000b\u0001\u0004\u0002\u0019A%\t\u000bu\u0003\u0002\u0019A%\u0015\u0005\u001dk\u0007\"B/\u0012\u0001\u0004I\u0015A\u00039sKR$\u0018PT1nKV\t\u0001\u000f\u0005\u0002rk:\u0011!o\u001d\t\u0003+^J!\u0001^\u001c\u0002\rA\u0013X\rZ3g\u0013\t1xO\u0001\u0004TiJLgn\u001a\u0006\u0003i^\n\u0011\u0002Z5sK\u000e$\u0018n\u001c8\u0002\r\u0011|WI^1m)\rY\u0018q\u0001\t\u0004y\u0006\rQ\"A?\u000b\u0005y|\u0018!\u0002;za\u0016\u001c(bAA\u0001U\u00051QO\\:bM\u0016L1!!\u0002~\u0005))FK\u0012\u001dTiJLgn\u001a\u0005\u0007\u0003\u0013!\u0002\u0019A>\u0002\u0013M\u00148m\u0015;sS:<G#B>\u0002\u000e\u0005=\u0001BBA\u0005+\u0001\u00071\u0010\u0003\u0004\u0002\u0012U\u0001\ra_\u0001\u000biJLWn\u0015;sS:<\u0017A\u0003;sS6lU\r\u001e5pI\u0006YAO]5n\u001b\u0016$\bn\u001c3!\u0003]9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7ee\u0016t\u0017J\u001c;fe:\fG\u000eF\u0002H\u00037Aq!!\b\u0019\u0001\u0004\ty\"A\u0006oK^\u001c\u0005.\u001b7ee\u0016t\u0007\u0003B*\u0002\"%K1!a\t]\u0005)Ie\u000eZ3yK\u0012\u001cV-]\u0001\u0005G>\u0004\u0018\u0010F\u0003H\u0003S\tY\u0003C\u0004^3A\u0005\t\u0019A%\t\u000f\u0001L\u0002\u0013!a\u0001E\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA\u0019U\rI\u00151G\u0016\u0003\u0003k\u0001B!a\u000e\u0002B5\u0011\u0011\u0011\b\u0006\u0005\u0003w\ti$A\u0005v]\u000eDWmY6fI*\u0019\u0011qH\u001c\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002D\u0005e\"!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA%U\r\u0011\u00171G\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005=\u0003\u0003BA)\u0003/j!!a\u0015\u000b\u0007\u0005Us(\u0001\u0003mC:<\u0017b\u0001<\u0002T\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\f\t\u0004m\u0005}\u0013bAA1o\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qMA7!\r1\u0014\u0011N\u0005\u0004\u0003W:$aA!os\"I\u0011q\u000e\u0010\u0002\u0002\u0003\u0007\u0011QL\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005U\u0004CBA<\u0003{\n9'\u0004\u0002\u0002z)\u0019\u00111P\u001c\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u0000\u0005e$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!\"\u0002\fB\u0019a'a\"\n\u0007\u0005%uGA\u0004C_>dW-\u00198\t\u0013\u0005=\u0004%!AA\u0002\u0005\u001d\u0014A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u0014\u0002\u0012\"I\u0011qN\u0011\u0002\u0002\u0003\u0007\u0011QL\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u0015\u0015q\u0013\u0005\n\u0003_\u0012\u0013\u0011!a\u0001\u0003OBsCCAN\u0003C\u000b\u0019+a*\u0002*\u00065\u0016qVAZ\u0003k\u000bI,a/\u0011\u0007I\ni*C\u0002\u0002 \u0012\u0012Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002&\u00061%\u0002\t\u0011!A}3UKT\"`QM$(/\u000b\u0011.AI+Wn\u001c<fg\u0002\"\b.\u001a\u0011mK\u0006$\u0017N\\4!gB\f7-\u001a\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004cM]8nA\u0001\u001cHO\u001d1/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\tY+AA\u000f\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u00023\u000f\u001e:![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8o\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"(/[7TiJ\u0004S\u0006\t;iK\u0002\"(/[7!gR\u0014\u0018N\\4!G\"\f'/Y2uKJ\u001c\b\u0005^8!iJLW\u000e\f\u0011uQ\u0016\u0004C-\u001a4bk2$\bE^1mk\u0016\u0004\u0013n\u001d\u0011bAMLgn\u001a7fAM\u0004\u0018mY3\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003c\u000b1J\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(A\u0001\u0002\u0003e\u00159be.\u001c\u0016\u000b\u0014\u0011!A\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I*qCJ\\7+\u0015'\u000bA\u0001\nQa]5oG\u0016\f#!a.\u0002\u000bErSG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005u\u0016\u0001D:ue&twm\u00184v]\u000e\u001c\bBBAa\u0007\u0001\u0007\u0011*A\u0002tiJDQ\u0001Y\u0002A\u0002%#2aRAd\u0011\u0019\t\t\r\u0002a\u0001\u0013R)q)a3\u0002N\")Q,\u0002a\u0001\u0013\"9\u0001-\u0002I\u0001\u0002\u0004\u0011\u0017aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u0011Q[Ao!\u001114-a6\u0011\u000bY\nI.\u00132\n\u0007\u0005mwG\u0001\u0004UkBdWM\r\u0005\t\u0003?<\u0011\u0011!a\u0001\u000f\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u000319(/\u001b;f%\u0016\u0004H.Y2f)\t\t9\u000f\u0005\u0003\u0002R\u0005%\u0018\u0002BAv\u0003'\u0012aa\u00142kK\u000e$\b")
public class StringTrimLeft
extends Expression
implements String2TrimExpression,
Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;
    private final String trimMethod;

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrimLeft$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrimLeft x$0) {
        return StringTrimLeft$.MODULE$.unapply(x$0);
    }

    public static Option<Expression> apply$default$2() {
        return StringTrimLeft$.MODULE$.apply$default$2();
    }

    @Override
    public /* synthetic */ String org$apache$spark$sql$catalyst$expressions$String2TrimExpression$$super$sql() {
        return super.sql();
    }

    @Override
    public Seq<Expression> children() {
        return String2TrimExpression.children$(this);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression.inputTypes$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public Object eval(InternalRow input) {
        return String2TrimExpression.eval$(this, input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return String2TrimExpression.doGenCode$(this, ctx, ev);
    }

    @Override
    public String sql() {
        return String2TrimExpression.sql$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression srcStr() {
        return this.srcStr;
    }

    @Override
    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "ltrim";
    }

    @Override
    public String direction() {
        return "LEADING";
    }

    @Override
    public UTF8String doEval(UTF8String srcString) {
        return srcString.trimLeft();
    }

    @Override
    public UTF8String doEval(UTF8String srcString, UTF8String trimString) {
        return srcString.trimLeft(trimString);
    }

    @Override
    public String trimMethod() {
        return this.trimMethod;
    }

    @Override
    public StringTrimLeft withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.head(), (Option<Expression>)(this.trimStr().isDefined() ? new Some(newChildren.last()) : None$.MODULE$));
    }

    public StringTrimLeft copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrimLeft(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrimLeft";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.srcStr();
                break;
            }
            case 1: {
                object = this.trimStr();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrimLeft;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "srcStr";
                break;
            }
            case 1: {
                string = "trimStr";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrimLeft)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrimLeft stringTrimLeft = (StringTrimLeft)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrimLeft.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrimLeft.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrimLeft.canEqual(this)) return false;
        return true;
    }

    public StringTrimLeft(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
        this.trimMethod = "trimLeft";
    }

    public StringTrimLeft(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrimLeft(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

