/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl.writer;

import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.orc.OrcProto;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.CryptoUtils;
import org.apache.orc.impl.IntegerWriter;
import org.apache.orc.impl.OutStream;
import org.apache.orc.impl.PositionRecorder;
import org.apache.orc.impl.StreamName;
import org.apache.orc.impl.writer.TreeWriterBase;
import org.apache.orc.impl.writer.WriterContext;
import org.apache.orc.impl.writer.WriterEncryptionVariant;

public class IntegerTreeWriter
extends TreeWriterBase {
    private final IntegerWriter writer;
    private boolean isDirectV2 = true;
    private final boolean isLong;

    public IntegerTreeWriter(TypeDescription schema, WriterEncryptionVariant encryption, WriterContext context) throws IOException {
        super(schema, encryption, context);
        OutStream out = context.createStream(new StreamName(this.id, OrcProto.Stream.Kind.DATA, encryption));
        this.isDirectV2 = this.isNewWriteFormat(context);
        this.writer = this.createIntegerWriter(out, true, this.isDirectV2, context);
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
        this.isLong = schema.getCategory() == TypeDescription.Category.LONG;
    }

    @Override
    OrcProto.ColumnEncoding.Builder getEncoding() {
        OrcProto.ColumnEncoding.Builder result = super.getEncoding();
        if (this.isDirectV2) {
            result.setKind(OrcProto.ColumnEncoding.Kind.DIRECT_V2);
        } else {
            result.setKind(OrcProto.ColumnEncoding.Kind.DIRECT);
        }
        return result;
    }

    @Override
    public void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
        block6: {
            LongColumnVector vec;
            block5: {
                super.writeBatch(vector, offset, length);
                vec = (LongColumnVector)vector;
                if (!vector.isRepeating) break block5;
                if (!vector.noNulls && vector.isNull[0]) break block6;
                long value = vec.vector[0];
                this.indexStatistics.updateInteger(value, length);
                if (this.createBloomFilter) {
                    if (this.bloomFilter != null) {
                        this.bloomFilter.addLong(value);
                    }
                    this.bloomFilterUtf8.addLong(value);
                }
                for (int i = 0; i < length; ++i) {
                    this.writer.write(value);
                }
                break block6;
            }
            for (int i = 0; i < length; ++i) {
                if (!vec.noNulls && vec.isNull[i + offset]) continue;
                long value = vec.vector[i + offset];
                this.writer.write(value);
                this.indexStatistics.updateInteger(value, 1);
                if (!this.createBloomFilter) continue;
                if (this.bloomFilter != null) {
                    this.bloomFilter.addLong(value);
                }
                this.bloomFilterUtf8.addLong(value);
            }
        }
    }

    @Override
    public void writeStripe(int requiredIndexEntries) throws IOException {
        super.writeStripe(requiredIndexEntries);
        if (this.rowIndexPosition != null) {
            this.recordPosition(this.rowIndexPosition);
        }
    }

    @Override
    void recordPosition(PositionRecorder recorder) throws IOException {
        super.recordPosition(recorder);
        this.writer.getPosition(recorder);
    }

    @Override
    public long estimateMemory() {
        return super.estimateMemory() + this.writer.estimateMemory();
    }

    @Override
    public long getRawDataSize() {
        JavaDataModel jdm = JavaDataModel.get();
        long num = this.fileStatistics.getNumberOfValues();
        return num * (long)(this.isLong ? jdm.primitive2() : jdm.primitive1());
    }

    @Override
    public void flushStreams() throws IOException {
        super.flushStreams();
        this.writer.flush();
    }

    @Override
    public void prepareStripe(int stripeId) {
        super.prepareStripe(stripeId);
        this.writer.changeIv(CryptoUtils.modifyIvForStripe(stripeId));
    }
}

