/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.python;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.python.RowQueue;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.memory.MemoryBlock;
import scala.Function0;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005-4aa\u0005\u000b\u0002\u0002Q\u0001\u0003\u0002C\u0016\u0001\u0005\u000b\u0007I\u0011A\u0017\t\u0011Y\u0002!\u0011!Q\u0001\n9B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\u0006w\u0001!\t\u0001\u0010\u0005\b\u0001\u0002\u0011\r\u0011\"\u0003B\u0011\u0019\u0011\u0005\u0001)A\u0005C!91\t\u0001b\u0001\n\u0013!\u0005B\u0002%\u0001A\u0003%Q\tC\u0004J\u0001\u0001\u0007I\u0011\u0002#\t\u000f)\u0003\u0001\u0019!C\u0005\u0017\"1\u0011\u000b\u0001Q!\n\u0015CqA\u0015\u0001A\u0002\u0013%A\tC\u0004T\u0001\u0001\u0007I\u0011\u0002+\t\rY\u0003\u0001\u0015)\u0003F\u0011\u001d9\u0006A1A\u0005\naCa!\u0019\u0001!\u0002\u0013I\u0006\"\u00022\u0001\t\u0003\u0019\u0007\"B5\u0001\t\u0003Q'\u0001E%o\u001b\u0016lwN]=S_^\fV/Z;f\u0015\t)b#\u0001\u0004qsRDwN\u001c\u0006\u0003/a\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005eQ\u0012aA:rY*\u00111\u0004H\u0001\u0006gB\f'o\u001b\u0006\u0003;y\ta!\u00199bG\",'\"A\u0010\u0002\u0007=\u0014xmE\u0002\u0001C\u001d\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u0015*\u001b\u0005!\u0012B\u0001\u0016\u0015\u0005!\u0011vn^)vKV,\u0017\u0001\u00029bO\u0016\u001c\u0001!F\u0001/!\tyC'D\u00011\u0015\t\t$'\u0001\u0004nK6|'/\u001f\u0006\u0003gi\ta!\u001e8tC\u001a,\u0017BA\u001b1\u0005-iU-\\8ss\ncwnY6\u0002\u000bA\fw-\u001a\u0011\u0002\u00139,XNR5fY\u0012\u001c\bC\u0001\u0012:\u0013\tQ4EA\u0002J]R\fa\u0001P5oSRtDcA\u001f?\u007fA\u0011\u0001\u0006\u0001\u0005\u0006W\u0011\u0001\rA\f\u0005\u0006o\u0011\u0001\r\u0001O\u0001\u0005E\u0006\u001cX-F\u0001\"\u0003\u0015\u0011\u0017m]3!\u0003%)g\u000eZ(g!\u0006<W-F\u0001F!\t\u0011c)\u0003\u0002HG\t!Aj\u001c8h\u0003))g\u000eZ(g!\u0006<W\rI\u0001\foJLG/Z(gMN,G/A\bxe&$Xm\u00144gg\u0016$x\fJ3r)\tau\n\u0005\u0002#\u001b&\u0011aj\t\u0002\u0005+:LG\u000fC\u0004Q\u0015\u0005\u0005\t\u0019A#\u0002\u0007a$\u0013'\u0001\u0007xe&$Xm\u00144gg\u0016$\b%\u0001\u0006sK\u0006$wJ\u001a4tKR\faB]3bI>3gm]3u?\u0012*\u0017\u000f\u0006\u0002M+\"9\u0001+DA\u0001\u0002\u0004)\u0015a\u0003:fC\u0012|eMZ:fi\u0002\n\u0011B]3tk2$(k\\<\u0016\u0003e\u0003\"AW0\u000e\u0003mS!\u0001X/\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003=b\t\u0001bY1uC2L8\u000f^\u0005\u0003An\u0013\u0011\"\u00168tC\u001a,'k\\<\u0002\u0015I,7/\u001e7u%><\b%A\u0002bI\u0012$\"\u0001Z4\u0011\u0005\t*\u0017B\u00014$\u0005\u001d\u0011un\u001c7fC:DQ\u0001[\tA\u0002e\u000b1A]8x\u0003\u0019\u0011X-\\8wKR\t\u0011\f")
public abstract class InMemoryRowQueue
implements RowQueue {
    private final MemoryBlock page;
    private final Object base;
    private final long endOfPage;
    private long writeOffset;
    private long readOffset;
    private final UnsafeRow resultRow;

    public MemoryBlock page() {
        return this.page;
    }

    private Object base() {
        return this.base;
    }

    private long endOfPage() {
        return this.endOfPage;
    }

    private long writeOffset() {
        return this.writeOffset;
    }

    private void writeOffset_$eq(long x$1) {
        this.writeOffset = x$1;
    }

    private long readOffset() {
        return this.readOffset;
    }

    private void readOffset_$eq(long x$1) {
        this.readOffset = x$1;
    }

    private UnsafeRow resultRow() {
        return this.resultRow;
    }

    @Override
    public synchronized boolean add(UnsafeRow row) {
        boolean bl;
        int size = row.getSizeInBytes();
        if (this.writeOffset() + 4L + (long)size > this.endOfPage()) {
            if (this.writeOffset() + 4L <= this.endOfPage()) {
                Platform.putInt((Object)this.base(), (long)this.writeOffset(), (int)-1);
            }
            bl = false;
        } else {
            Platform.putInt((Object)this.base(), (long)this.writeOffset(), (int)size);
            Platform.copyMemory((Object)row.getBaseObject(), (long)row.getBaseOffset(), (Object)this.base(), (long)(this.writeOffset() + 4L), (long)size);
            this.writeOffset_$eq(this.writeOffset() + (long)(4 + size));
            bl = true;
        }
        return bl;
    }

    @Override
    public synchronized UnsafeRow remove() {
        UnsafeRow unsafeRow;
        Predef$.MODULE$.assert(this.readOffset() <= this.writeOffset(), (Function0 & Serializable)() -> "reader should not go beyond writer");
        if (this.readOffset() + 4L > this.endOfPage() || Platform.getInt((Object)this.base(), (long)this.readOffset()) < 0) {
            unsafeRow = null;
        } else {
            int size = Platform.getInt((Object)this.base(), (long)this.readOffset());
            this.resultRow().pointTo(this.base(), this.readOffset() + 4L, size);
            this.readOffset_$eq(this.readOffset() + (long)(4 + size));
            unsafeRow = this.resultRow();
        }
        return unsafeRow;
    }

    public InMemoryRowQueue(MemoryBlock page, int numFields) {
        this.page = page;
        this.base = page.getBaseObject();
        this.endOfPage = page.getBaseOffset() + page.size();
        this.writeOffset = page.getBaseOffset();
        this.readOffset = page.getBaseOffset();
        this.resultRow = new UnsafeRow(numFields);
    }
}

