/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.orc;

import java.util.ArrayList;
import java.util.List;
import org.apache.orc.ColumnStatistics;

public class OrcColumnStatistics {
    private final ColumnStatistics statistics;
    private final List<OrcColumnStatistics> children;

    public OrcColumnStatistics(ColumnStatistics statistics) {
        this.statistics = statistics;
        this.children = new ArrayList<OrcColumnStatistics>();
    }

    public ColumnStatistics getStatistics() {
        return this.statistics;
    }

    public OrcColumnStatistics get(int ordinal) {
        if (ordinal < 0 || ordinal >= this.children.size()) {
            throw new IndexOutOfBoundsException(String.format("Ordinal %d out of bounds of statistics size %d", ordinal, this.children.size()));
        }
        return this.children.get(ordinal);
    }

    public void add(OrcColumnStatistics newChild) {
        this.children.add(newChild);
    }
}

