/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.hbase.stats.merge;

import org.apache.hadoop.hive.metastore.NumDistinctValueEstimator;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.hbase.stats.merge.ColumnStatsMerger;

public class StringColumnStatsMerger
extends ColumnStatsMerger {
    @Override
    public void merge(ColumnStatisticsObj aggregateColStats, ColumnStatisticsObj newColStats) {
        StringColumnStatsData aggregateData = aggregateColStats.getStatsData().getStringStats();
        StringColumnStatsData newData = newColStats.getStatsData().getStringStats();
        aggregateData.setMaxColLen(Math.max(aggregateData.getMaxColLen(), newData.getMaxColLen()));
        aggregateData.setAvgColLen(Math.max(aggregateData.getAvgColLen(), newData.getAvgColLen()));
        aggregateData.setNumNulls(aggregateData.getNumNulls() + newData.getNumNulls());
        if (this.ndvEstimator == null || !newData.isSetBitVectors() || newData.getBitVectors().length() == 0) {
            aggregateData.setNumDVs(Math.max(aggregateData.getNumDVs(), newData.getNumDVs()));
        } else {
            this.ndvEstimator.mergeEstimators(new NumDistinctValueEstimator(aggregateData.getBitVectors(), this.ndvEstimator.getnumBitVectors()));
            this.ndvEstimator.mergeEstimators(new NumDistinctValueEstimator(newData.getBitVectors(), this.ndvEstimator.getnumBitVectors()));
            long ndv = this.ndvEstimator.estimateNumDistinctValues();
            this.LOG.debug("Use bitvector to merge column " + aggregateColStats.getColName() + "'s ndvs of " + aggregateData.getNumDVs() + " and " + newData.getNumDVs() + " to be " + ndv);
            aggregateData.setNumDVs(ndv);
            aggregateData.setBitVectors(this.ndvEstimator.serialize().toString());
        }
    }
}

