/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.gui.referencing;

import java.time.ZoneId;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.concurrent.Task;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.TextArea;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.StringConverter;
import org.apache.sis.gui.internal.BackgroundThreads;
import org.apache.sis.gui.referencing.AuthorityCodes;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.WKTFormat;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;

final class WKTPane
extends StringConverter<Convention>
implements ChangeListener<Convention> {
    private final WKTFormat format;
    final ChoiceBox<Convention> convention;
    private final EnumMap<Convention, String> conventionTexts;
    final TextArea text = new TextArea();
    private CoordinateReferenceSystem crs;

    WKTPane(Locale locale) {
        Object[] sc = new Convention[]{Convention.WKT2_SIMPLIFIED, Convention.WKT2, Convention.WKT2_2015, Convention.WKT1, Convention.WKT1_COMMON_UNITS};
        this.conventionTexts = new EnumMap(Convention.class);
        Vocabulary vocabulary = Vocabulary.forLocale((Locale)locale);
        for (Convention convention : sc) {
            this.conventionTexts.put(convention, this.toString(convention, vocabulary));
        }
        this.format = new WKTFormat(locale, (ZoneId)null);
        this.format.setConvention(Convention.WKT2_SIMPLIFIED);
        this.convention = new ChoiceBox(FXCollections.observableArrayList((Object[])sc));
        this.convention.setConverter((StringConverter)this);
        this.convention.getSelectionModel().select((Object)this.format.getConvention());
        this.convention.valueProperty().addListener((ChangeListener)this);
        this.convention.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow(this.convention, (Priority)Priority.ALWAYS);
    }

    private String toString(Convention c, Vocabulary vocabulary) {
        Object version;
        boolean simplified = false;
        switch (c) {
            case WKT2_SIMPLIFIED: {
                simplified = true;
            }
            case WKT2: {
                version = 2;
                break;
            }
            case WKT2_2015: {
                version = "2 (2015)";
                break;
            }
            case WKT1: {
                version = 1;
                break;
            }
            case WKT1_COMMON_UNITS: {
                version = "GDAL 1-2";
                break;
            }
            default: {
                return c.name();
            }
        }
        Object text = vocabulary.getString((short)218, (Object)"WKT (Well Known Text)", version);
        if (simplified) {
            text = (String)text + " \u2014 " + vocabulary.getString((short)180);
        }
        return text;
    }

    public String toString(Convention c) {
        return this.conventionTexts.get(c);
    }

    public Convention fromString(String text) {
        for (Map.Entry<Convention, String> e : this.conventionTexts.entrySet()) {
            if (!e.getValue().equals(text)) continue;
            return e.getKey();
        }
        return null;
    }

    public void changed(ObservableValue<? extends Convention> observable, Convention oldValue, Convention newValue) {
        this.format.setConvention(newValue);
        if (this.crs != null) {
            this.text.setText(this.format.format((Object)this.crs));
        }
    }

    final void setContent(final AuthorityCodes source, final String code) {
        this.text.setDisable(true);
        BackgroundThreads.execute((Runnable)new Task<CoordinateReferenceSystem>(this){
            private String wkt;
            final /* synthetic */ WKTPane this$0;
            {
                this.this$0 = this$0;
            }

            protected CoordinateReferenceSystem call() throws FactoryException {
                CoordinateReferenceSystem crs = source.getFactory().createCoordinateReferenceSystem(code);
                if (crs != null) {
                    this.wkt = this.this$0.format.format((Object)crs);
                }
                return crs;
            }

            protected void succeeded() {
                this.this$0.setContent((CoordinateReferenceSystem)this.getValue(), this.wkt);
            }

            protected void cancelled() {
                this.this$0.text.setText(null);
            }

            protected void failed() {
                this.this$0.text.setDisable(false);
                this.this$0.text.setEditable(false);
                this.this$0.text.setText(Exceptions.getLocalizedMessage((Throwable)this.getException(), (Locale)source.locale));
            }
        });
    }

    private void setContent(CoordinateReferenceSystem newCRS, String wkt) {
        this.text.setEditable(false);
        this.text.setDisable(false);
        if (newCRS != this.crs) {
            this.crs = newCRS;
            this.text.setText(wkt);
        }
    }
}

