/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml.bind.gco;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.FilterByVersion;
import org.apache.sis.xml.internal.shared.XmlUtilities;

@XmlType(name="Date_PropertyType")
public class GO_Temporal
extends XmlAdapter<GO_Temporal, Temporal> {
    @XmlElement(name="DateTime")
    @XmlSchemaType(name="dateTime")
    public XMLGregorianCalendar dateTime;
    @XmlElement(name="Date")
    @XmlSchemaType(name="date")
    public XMLGregorianCalendar date;

    public GO_Temporal() {
    }

    private GO_Temporal(Temporal time) {
        Context context = Context.current();
        try {
            XMLGregorianCalendar gc = XmlUtilities.toXML(context, time);
            if (gc.getMillisecond() == 0) {
                gc.setMillisecond(Integer.MIN_VALUE);
            }
            if (Context.isFlagSet(context, 32) && !time.isSupported(ChronoField.HOUR_OF_DAY)) {
                this.date = gc;
                return;
            }
            this.dateTime = gc;
        }
        catch (DatatypeConfigurationException e) {
            Context.warningOccured(context, XmlAdapter.class, "marshal", e, true);
        }
    }

    private Temporal getDate() {
        return XmlUtilities.toTemporal(Context.current(), this.dateTime != null ? this.dateTime : this.date);
    }

    public final Temporal unmarshal(GO_Temporal value) {
        return value != null ? value.getDate() : null;
    }

    public GO_Temporal marshal(Temporal value) {
        return value != null ? new GO_Temporal(value) : null;
    }

    public static final class Since2014
    extends GO_Temporal {
        @Override
        public GO_Temporal marshal(Temporal value) {
            return FilterByVersion.CURRENT_METADATA.accept() ? super.marshal(value) : null;
        }
    }
}

