/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.processor.annotation;

import io.swagger.annotations.ResponseHeader;
import io.swagger.models.properties.Property;
import java.lang.reflect.Type;
import org.apache.servicecomb.swagger.generator.MethodAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.OperationGenerator;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.AnnotationUtils;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.models.ResponseHeaderConfig;

public class ResponseHeaderProcessor
implements MethodAnnotationProcessor<ResponseHeader> {
    @Override
    public Type getProcessType() {
        return ResponseHeader.class;
    }

    @Override
    public void process(SwaggerGenerator swaggerGenerator, OperationGenerator operationGenerator, ResponseHeader responseHeader) {
        ResponseHeaderConfig config = AnnotationUtils.convert(responseHeader);
        if (config != null) {
            Property property = AnnotationUtils.generateResponseHeaderProperty(swaggerGenerator.getSwagger(), config);
            operationGenerator.addMethodResponseHeader(config.getName(), property);
        }
    }
}

