/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.lightweight;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import java.util.concurrent.CompletableFuture;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.servicecomb.provider.rest.common.RestSchema;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.lightweight.MicroserviceInfo;
import org.apache.servicecomb.registry.lightweight.Self;

@RestSchema(schemaId="scb-discovery")
@Path(value="/v1/discovery")
public class DiscoveryEndpoint {
    public static final String SCHEMA_ID = "scb-discovery";
    private final Self self;

    public DiscoveryEndpoint(Self self) {
        this.self = self;
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="service-id", paramType="query", dataType="string", value="just make it possible to mock many instances by one real instance for performance test")})
    @Path(value="/info")
    @GET
    public CompletableFuture<MicroserviceInfo> getInfo() {
        return CompletableFuture.completedFuture(this.self.getMicroserviceInfo());
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="service-id", paramType="query", dataType="string", value="just make it possible to mock many instances by one real instance for performance test")})
    @Path(value="/microservice")
    @GET
    public CompletableFuture<Microservice> getMicroservice() {
        return CompletableFuture.completedFuture(this.self.getMicroservice());
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="service-id", paramType="query", dataType="string", value="just make it possible to mock many instances by one real instance for performance test")})
    @Path(value="/instance")
    @GET
    public CompletableFuture<MicroserviceInstance> getInstance() {
        return CompletableFuture.completedFuture(this.self.getInstance());
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="service-id", paramType="query", dataType="string", value="just make it possible to mock many instances by one real instance for performance test")})
    @Path(value="/schemas/{schema-id}")
    @GET
    @Produces(value={"text/plain"})
    public CompletableFuture<String> getSchema(@PathParam(value="schema-id") String schemaId) {
        return CompletableFuture.completedFuture((String)this.self.getMicroservice().getSchemaMap().get(schemaId));
    }
}

