/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.jsontype;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.Collection;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.jsontype.NamedType;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.jsontype.TypeIdResolver;
import tools.jackson.databind.jsontype.TypeResolverBuilder;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.jsontype.impl.StdTypeResolverBuilder;

public class TypeResolverProvider
implements Serializable {
    private static final long serialVersionUID = 3L;
    protected static final StdTypeResolverBuilder NO_RESOLVER = StdTypeResolverBuilder.noTypeInfoBuilder();

    public TypeSerializer findTypeSerializer(SerializationContext ctxt, JavaType baseType, AnnotatedClass classInfo) {
        SerializationConfig config = ctxt.getConfig();
        TypeResolverBuilder<?> b = this._findTypeResolver(config, classInfo, baseType);
        if (b == null && (b = config.getDefaultTyper(baseType)) == null) {
            return null;
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypesByClass(config, classInfo);
        return b.buildTypeSerializer(ctxt, baseType, subtypes);
    }

    public TypeDeserializer findTypeDeserializer(DeserializationContext ctxt, JavaType baseType, AnnotatedClass classInfo) {
        JavaType defaultType;
        DeserializationConfig config = ctxt.getConfig();
        TypeResolverBuilder<?> b = this._findTypeResolver(config, classInfo, baseType);
        if (b == null && (b = config.getDefaultTyper(baseType)) == null) {
            return null;
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypesByTypeId(config, classInfo);
        if (b.getDefaultImpl() == null && baseType.isAbstract() && (defaultType = config.mapAbstractType(baseType)) != null && !defaultType.hasRawClass(baseType.getRawClass())) {
            b = b.withDefaultImpl(defaultType.getRawClass());
        }
        return b.buildTypeDeserializer(ctxt, baseType, subtypes);
    }

    public TypeSerializer findPropertyTypeSerializer(SerializationContext ctxt, AnnotatedMember accessor, JavaType baseType) {
        TypeResolverBuilder<?> b = null;
        SerializationConfig config = ctxt.getConfig();
        if (!baseType.isContainerType() && !baseType.isReferenceType()) {
            b = this._findTypeResolver(config, accessor, baseType);
        }
        if (b == null) {
            return this.findTypeSerializer(ctxt, baseType, ctxt.introspectClassAnnotations(baseType));
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypesByClass(config, accessor, baseType);
        return b.buildTypeSerializer(ctxt, baseType, subtypes);
    }

    public TypeDeserializer findPropertyTypeDeserializer(DeserializationContext ctxt, AnnotatedMember accessor, JavaType baseType) {
        JavaType defaultType;
        TypeResolverBuilder<?> b = null;
        DeserializationConfig config = ctxt.getConfig();
        if (!baseType.isContainerType() && !baseType.isReferenceType()) {
            b = this._findTypeResolver(config, accessor, baseType);
        }
        if (b == null) {
            return this.findTypeDeserializer(ctxt, baseType, ctxt.introspectClassAnnotations(baseType));
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypesByTypeId(config, accessor, baseType);
        if (b.getDefaultImpl() == null && baseType.isAbstract() && (defaultType = config.mapAbstractType(baseType)) != null && !defaultType.hasRawClass(baseType.getRawClass())) {
            b = b.withDefaultImpl(defaultType.getRawClass());
        }
        return b.buildTypeDeserializer(ctxt, baseType, subtypes);
    }

    public TypeSerializer findPropertyContentTypeSerializer(SerializationContext ctxt, AnnotatedMember accessor, JavaType containerType) {
        JavaType contentType = containerType.getContentType();
        if (contentType == null) {
            throw new IllegalArgumentException("Must call method with a container or reference type (got " + String.valueOf(containerType) + ")");
        }
        SerializationConfig config = ctxt.getConfig();
        TypeResolverBuilder<?> b = this._findTypeResolver(config, accessor, containerType);
        if (b == null) {
            return this.findTypeSerializer(ctxt, contentType, ctxt.introspectClassAnnotations(contentType.getRawClass()));
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypesByClass(config, accessor, contentType);
        return b.buildTypeSerializer(ctxt, contentType, subtypes);
    }

    public TypeDeserializer findPropertyContentTypeDeserializer(DeserializationContext ctxt, AnnotatedMember accessor, JavaType containerType) {
        JavaType defaultType;
        JavaType contentType = containerType.getContentType();
        DeserializationConfig config = ctxt.getConfig();
        if (contentType == null) {
            throw new IllegalArgumentException("Must call method with a container or reference type (got " + String.valueOf(containerType) + ")");
        }
        TypeResolverBuilder<?> b = this._findTypeResolver(config, accessor, containerType);
        if (b == null) {
            return this.findTypeDeserializer(ctxt, contentType, ctxt.introspectClassAnnotations(contentType));
        }
        Collection<NamedType> subtypes = config.getSubtypeResolver().collectAndResolveSubtypesByTypeId(config, accessor, contentType);
        if (b.getDefaultImpl() == null && contentType.isAbstract() && (defaultType = config.mapAbstractType(contentType)) != null && !defaultType.hasRawClass(contentType.getRawClass())) {
            b = b.withDefaultImpl(defaultType.getRawClass());
        }
        return b.buildTypeDeserializer(ctxt, contentType, subtypes);
    }

    protected TypeResolverBuilder<?> _findTypeResolver(MapperConfig<?> config, Annotated ann, JavaType baseType) {
        TypeResolverBuilder<?> b;
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        JsonTypeInfo.Value typeInfo = ai.findPolymorphicTypeInfo(config, ann);
        Object customResolverOb = ai.findTypeResolverBuilder(config, ann);
        if (customResolverOb != null) {
            if (typeInfo != null && typeInfo.getIdType() == JsonTypeInfo.Id.NONE) {
                return null;
            }
            if (customResolverOb instanceof Class) {
                Class cls = (Class)customResolverOb;
                b = config.typeResolverBuilderInstance(ann, cls);
            } else {
                b = (TypeResolverBuilder<?>)customResolverOb;
            }
        } else {
            JsonTypeInfo.As inclusion;
            if (typeInfo == null) {
                return null;
            }
            if (typeInfo.getIdType() == JsonTypeInfo.Id.NONE) {
                return NO_RESOLVER;
            }
            if (ann instanceof AnnotatedClass && (inclusion = typeInfo.getInclusionType()) == JsonTypeInfo.As.EXTERNAL_PROPERTY && ann instanceof AnnotatedClass) {
                typeInfo = typeInfo.withInclusionType(JsonTypeInfo.As.PROPERTY);
            }
            b = this._constructStdTypeResolverBuilder(config, typeInfo, baseType);
        }
        Object customIdResolverOb = ai.findTypeIdResolver(config, ann);
        TypeIdResolver idResolver = null;
        if (customIdResolverOb != null && customIdResolverOb instanceof Class) {
            Class cls = (Class)customIdResolverOb;
            idResolver = config.typeIdResolverInstance(ann, cls);
            idResolver.init(baseType);
        }
        b = b.init(typeInfo, idResolver);
        return b;
    }

    protected TypeResolverBuilder<?> _constructStdTypeResolverBuilder(MapperConfig<?> config, JsonTypeInfo.Value typeInfo, JavaType baseType) {
        return new StdTypeResolverBuilder(typeInfo);
    }
}

