/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store;

import org.apache.qpid.server.plugin.MessageMetaDataType;
import org.apache.qpid.server.plugin.QpidServiceLoader;

public class MessageMetaDataTypeRegistry {
    private static final MessageMetaDataType[] VALUES;

    public static MessageMetaDataType fromOrdinal(int ordinal) {
        return VALUES[ordinal];
    }

    static {
        int maxOrdinal = -1;
        Iterable<MessageMetaDataType> messageMetaDataTypes = new QpidServiceLoader().atLeastOneInstanceOf(MessageMetaDataType.class);
        for (MessageMetaDataType type : messageMetaDataTypes) {
            if (type.ordinal() <= maxOrdinal) continue;
            maxOrdinal = type.ordinal();
        }
        VALUES = new MessageMetaDataType[maxOrdinal + 1];
        for (MessageMetaDataType type : new QpidServiceLoader().instancesOf(MessageMetaDataType.class)) {
            if (VALUES[type.ordinal()] != null) {
                throw new IllegalStateException("Multiple MessageDataType (" + VALUES[type.ordinal()].getClass().getName() + ", " + type.getClass().getName() + ") defined for the same ordinal value: " + type.ordinal());
            }
            MessageMetaDataTypeRegistry.VALUES[type.ordinal()] = type;
        }
    }
}

