/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.rep.impl.node.NameIdPair;
import java.net.InetSocketAddress;

public class MasterStatus
implements Cloneable {
    private final NameIdPair nameIdPair;
    private String groupMasterHostName = null;
    private int groupMasterPort = 0;
    private NameIdPair groupMasterNameId = NameIdPair.NULL;
    private String nodeMasterHostName = null;
    private int nodeMasterPort = 0;
    private NameIdPair nodeMasterNameId = NameIdPair.NULL;

    public MasterStatus(NameIdPair nameIdPair) {
        this.nameIdPair = nameIdPair;
    }

    public synchronized Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
    }

    public synchronized boolean isGroupMaster() {
        int id = this.nameIdPair.getId();
        return id != -1 && id == this.groupMasterNameId.getId();
    }

    public synchronized boolean isNodeMaster() {
        int id = this.nameIdPair.getId();
        return id != -1 && id == this.nodeMasterNameId.getId();
    }

    public synchronized void setGroupMaster(String hostname, int port, NameIdPair newGroupMasterNameId) {
        this.groupMasterHostName = hostname;
        this.groupMasterPort = port;
        this.groupMasterNameId = newGroupMasterNameId;
    }

    public synchronized boolean inSync() {
        return !this.nodeMasterNameId.hasNullId() && this.groupMasterNameId.getId() == this.nodeMasterNameId.getId();
    }

    public synchronized void unSync() {
        this.nodeMasterHostName = null;
        this.nodeMasterPort = 0;
        this.nodeMasterNameId = NameIdPair.NULL;
    }

    public synchronized void assertSync() throws MasterSyncException {
        if (!this.inSync()) {
            throw new MasterSyncException();
        }
    }

    public synchronized void sync() {
        this.nodeMasterHostName = this.groupMasterHostName;
        this.nodeMasterPort = this.groupMasterPort;
        this.nodeMasterNameId = this.groupMasterNameId;
    }

    public synchronized InetSocketAddress getNodeMaster() {
        if (this.nodeMasterHostName == null) {
            return null;
        }
        return new InetSocketAddress(this.nodeMasterHostName, this.nodeMasterPort);
    }

    public synchronized NameIdPair getNodeMasterNameId() {
        return this.nodeMasterNameId;
    }

    public synchronized InetSocketAddress getGroupMaster() {
        if (this.groupMasterHostName == null) {
            return null;
        }
        return new InetSocketAddress(this.groupMasterHostName, this.groupMasterPort);
    }

    public synchronized NameIdPair getGroupMasterNameId() {
        return this.groupMasterNameId;
    }

    public class MasterSyncException
    extends Exception {
        private final NameIdPair savedGroupMasterId;
        private final NameIdPair savedNodeMasterId;

        MasterSyncException() {
            this.savedGroupMasterId = MasterStatus.this.getGroupMasterNameId();
            this.savedNodeMasterId = MasterStatus.this.getNodeMasterNameId();
        }

        @Override
        public String getMessage() {
            return "Master change. Node master id: " + this.savedNodeMasterId + " Group master id: " + this.savedGroupMasterId;
        }
    }
}

