/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.search.ahocorasick;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Set;
import org.apache.nifi.util.search.Search;
import org.apache.nifi.util.search.SearchTerm;
import org.apache.nifi.util.search.ahocorasick.Node;
import org.apache.nifi.util.search.ahocorasick.SearchState;

public class AhoCorasick<T>
implements Search<T> {
    private Node root = null;

    @Override
    public void initializeDictionary(Set<SearchTerm<T>> terms) {
        if (this.root != null) {
            throw new IllegalStateException();
        }
        this.root = new Node();
        if (terms == null || terms.isEmpty()) {
            throw new IllegalArgumentException();
        }
        for (SearchTerm<T> term : terms) {
            int i = 0;
            Node nextNode = this.root;
            while ((nextNode = this.addMatch(term, i, nextNode)) != null) {
                ++i;
            }
        }
        this.initialize();
    }

    private Node addMatch(SearchTerm<T> term, int offset, Node current) {
        boolean atEnd;
        int index = term.get(offset);
        boolean bl = atEnd = offset == term.size() - 1;
        if (current.getNeighbor(index) == null) {
            if (atEnd) {
                current.setNeighbor(new Node(term), index);
                return null;
            }
            current.setNeighbor(new Node(), index);
        } else if (atEnd) {
            current.getNeighbor(index).setMatchingTerm(term);
            return null;
        }
        return current.getNeighbor(index);
    }

    private void initialize() {
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.add(this.root);
        this.root.setFailureNode(null);
        while (!queue.isEmpty()) {
            Node current = (Node)queue.poll();
            for (int i = 0; i < 256; ++i) {
                Node fail;
                Node next = current.getNeighbor(i);
                if (next == null) continue;
                for (fail = current.getFailureNode(); fail != null && fail.getNeighbor(i) == null; fail = fail.getFailureNode()) {
                }
                if (fail != null) {
                    next.setFailureNode(fail.getNeighbor(i));
                } else {
                    next.setFailureNode(this.root);
                }
                queue.add(next);
            }
        }
    }

    @Override
    public SearchState search(InputStream stream, boolean findAll) throws IOException {
        return this.search(stream, findAll, null);
    }

    private SearchState search(InputStream stream, boolean findAll, SearchState state) throws IOException {
        int currentChar;
        SearchState currentState;
        if (this.root == null) {
            throw new IllegalStateException();
        }
        SearchState searchState = currentState = state == null ? new SearchState(this.root) : state;
        if (!findAll && currentState.foundMatch()) {
            throw new IllegalStateException("A match has already been found yet we're being asked to keep searching");
        }
        Node current = currentState.getCurrentNode();
        while ((currentChar = stream.read()) >= 0) {
            currentState.incrementBytesRead(1L);
            Node next = current.getNeighbor(currentChar);
            if (next == null) {
                for (next = current.getFailureNode(); next != null && next.getNeighbor(currentChar) == null; next = next.getFailureNode()) {
                }
                next = next != null ? next.getNeighbor(currentChar) : this.root;
            }
            if (next == null) {
                throw new IllegalStateException("tree out of sync");
            }
            if (next.hasMatch()) {
                currentState.addResult(next.getMatchingTerm());
            }
            for (Node failNode = next.getFailureNode(); failNode != null; failNode = failNode.getFailureNode()) {
                if (!failNode.hasMatch()) continue;
                currentState.addResult(failNode.getMatchingTerm());
            }
            current = next;
            if (!currentState.foundMatch() || findAll) continue;
            break;
        }
        currentState.setCurrentNode(current);
        return currentState;
    }
}

