/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.prefs.Preferences;
import javax.swing.text.EditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.modules.editor.impl.DefaultIndentEngine;
import org.netbeans.modules.editor.lib.SettingsConversions;
import org.openide.text.IndentEngine;
import org.openide.util.Lookup;

public final class ComplexValueSettingsFactory {
    private ComplexValueSettingsFactory() {
    }

    public static final Object getRenderingHintsValue(MimePath mimePath, String settingName) {
        assert (settingName.equals("rendering-hints")) : "The getRenderingHints factory called for '" + settingName + "'";
        FontColorSettings fcs = MimeLookup.getLookup(mimePath).lookup(FontColorSettings.class);
        return fcs.getFontColors("default").getAttribute(EditorStyleConstants.RenderingHints);
    }

    public static final IndentEngine getIndentEngine(MimePath mimePath) {
        IndentEngine eng = null;
        Preferences prefs = MimeLookup.getLookup(mimePath).lookup(Preferences.class);
        String handle = prefs.get("indentEngine", null);
        if (handle != null && handle.indexOf(46) == -1) {
            Lookup.Template<Object> query = new Lookup.Template<Object>(IndentEngine.class, handle, null);
            Collection<Object> all = Lookup.getDefault().lookup(query).allInstances();
            if (!all.isEmpty()) {
                eng = all.iterator().next();
            }
        } else {
            eng = (IndentEngine)SettingsConversions.callFactory(prefs, mimePath, "indentEngine", null);
        }
        if (eng == null) {
            EditorKit kit = MimeLookup.getLookup(mimePath).lookup(EditorKit.class);
            Object legacyFormatter = null;
            if (kit != null) {
                try {
                    Method createFormatterMethod = kit.getClass().getDeclaredMethod("createFormatter", new Class[0]);
                    legacyFormatter = createFormatterMethod.invoke((Object)kit, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (legacyFormatter == null) {
                eng = new DefaultIndentEngine();
            }
        }
        return eng;
    }

    public static final Object getIdentifierAcceptorValue(MimePath mimePath, String settingName) {
        assert (settingName.equals("identifier-acceptor")) : "The getIdentifierAcceptorValue factory called for '" + settingName + "'";
        return AcceptorFactory.LETTER_DIGIT;
    }

    public static final Object getWhitespaceAcceptorValue(MimePath mimePath, String settingName) {
        assert (settingName.equals("whitespace-acceptor")) : "The getWhitespaceAcceptorValue factory called for '" + settingName + "'";
        return AcceptorFactory.WHITESPACE;
    }
}

