/*
 * Decompiled with CFR 0.152.
 */
package org.c02e.jpgpj;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.c02e.jpgpj.JcaContextHelper;
import org.c02e.jpgpj.Key;
import org.c02e.jpgpj.PassphraseException;
import org.c02e.jpgpj.util.Util;

public class Subkey
implements Cloneable {
    private static final char[] NO_PASSPHRASE = Key.NO_PASSPHRASE.toCharArray();
    private static final char[] EMPTY_PASSPHRASE = new char[0];
    protected boolean forSigning;
    protected boolean forVerification;
    protected boolean forEncryption;
    protected boolean forDecryption;
    protected char[] passphraseChars;
    @Deprecated
    protected String passphrase;
    protected PGPPublicKey publicKey;
    protected PGPSecretKey secretKey;
    protected PGPPrivateKey privateKey;

    public Subkey() {
        this.setPassphraseChars(null);
    }

    public String toString() {
        if (this.publicKey == null) {
            return "nul";
        }
        StringBuilder b = new StringBuilder();
        b.append(this.secretKey != null ? "sec" : "pub");
        b.append((char)(Util.isEmpty(this.passphraseChars) && this.privateKey == null ? 32 : 43));
        if (this.forVerification) {
            b.append('v');
        } else if (this.forEncryption) {
            b.append('e');
        } else {
            b.append(' ');
        }
        if (this.forSigning) {
            b.append('s');
        } else if (this.forDecryption) {
            b.append('d');
        } else {
            b.append(' ');
        }
        b.append(' ');
        b.append(this.getShortId());
        int count = 0;
        for (String uid : this.getUids()) {
            if (count++ > 0) {
                b.append(',');
            }
            b.append(' ');
            b.append(uid);
        }
        return b.toString();
    }

    public Subkey clone() {
        try {
            Subkey other = (Subkey)this.getClass().cast(super.clone());
            other.passphraseChars = this.passphraseChars == null ? null : (char[])this.passphraseChars.clone();
            return other;
        }
        catch (CloneNotSupportedException e) {
            throw new UnsupportedOperationException("Unexpected clone failure for " + this);
        }
    }

    public boolean isForSigning() {
        return this.forSigning;
    }

    public void setForSigning(boolean x) {
        this.forSigning = x;
    }

    public boolean isForVerification() {
        return this.forVerification;
    }

    public void setForVerification(boolean x) {
        this.forVerification = x;
    }

    public boolean isForEncryption() {
        return this.forEncryption;
    }

    public void setForEncryption(boolean x) {
        this.forEncryption = x;
    }

    public boolean isForDecryption() {
        return this.forDecryption;
    }

    public void setForDecryption(boolean x) {
        this.forDecryption = x;
    }

    public boolean isUsableForSigning() {
        return this.isUsableForVerification() && this.secretKey != null && !this.secretKey.isPrivateKeyEmpty();
    }

    public boolean isUsableForVerification() {
        int algorithm = this.publicKey != null ? this.publicKey.getAlgorithm() : 0;
        return algorithm == 1 || algorithm == 3 || algorithm == 17 || algorithm == 19 || algorithm == 22;
    }

    public boolean isUsableForEncryption() {
        return this.publicKey != null && this.publicKey.isEncryptionKey();
    }

    public boolean isUsableForDecryption() {
        return this.isUsableForEncryption() && this.secretKey != null && !this.secretKey.isPrivateKeyEmpty();
    }

    public char[] getPassphraseChars() {
        return this.passphraseChars;
    }

    public void setPassphraseChars(char[] x) {
        if (x == null) {
            x = EMPTY_PASSPHRASE;
        }
        if (!Arrays.equals(x, this.passphraseChars)) {
            this.clearSecrets();
            this.passphraseChars = x;
        }
    }

    public String getPassphrase() {
        if (this.passphrase == null) {
            this.passphrase = new String(this.passphraseChars);
        }
        return this.passphrase;
    }

    public void setPassphrase(String x) {
        this.setPassphraseChars(x != null ? x.toCharArray() : null);
        this.passphrase = x;
    }

    public boolean isNoPassphrase() {
        return Arrays.equals(this.passphraseChars, NO_PASSPHRASE);
    }

    public void setNoPassphrase(boolean x) {
        if (x != this.isNoPassphrase()) {
            this.setPassphrase(x ? Key.NO_PASSPHRASE : null);
        }
    }

    public PGPPublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PGPPublicKey x) throws PGPException {
        this.publicKey = x;
        this.calculateUsage();
    }

    public PGPSecretKey getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(PGPSecretKey x) throws PGPException {
        this.secretKey = x;
        if (this.secretKey != null) {
            this.setPublicKey(this.secretKey.getPublicKey());
        }
    }

    public PGPPrivateKey getPrivateKey() throws PGPException {
        if (this.privateKey == null) {
            this.privateKey = this.extractPrivateKey(this.passphraseChars);
        }
        return this.privateKey;
    }

    public String getFingerprint() {
        if (this.publicKey == null) {
            return "";
        }
        return Util.formatAsHex(this.publicKey.getFingerprint());
    }

    public String getId() {
        if (this.publicKey == null) {
            return "";
        }
        return "0x" + String.format("%016X", this.publicKey.getKeyID());
    }

    public String getShortId() {
        if (this.publicKey == null) {
            return "";
        }
        return String.format("%016X", this.publicKey.getKeyID()).substring(8);
    }

    public List<String> getUids() {
        if (this.publicKey == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        Iterator uids = this.publicKey.getUserIDs();
        while (uids.hasNext()) {
            result.add((String)uids.next());
        }
        return result;
    }

    public int getUsageFlags() throws PGPException {
        if (this.publicKey == null) {
            return 0;
        }
        int flags = 0;
        Iterator signatures = this.publicKey.getSignatures();
        while (signatures.hasNext()) {
            PGPSignature signature = (PGPSignature)signatures.next();
            PGPSignatureSubpacketVector hashedSubPackets = signature.getHashedSubPackets();
            if (hashedSubPackets == null) continue;
            flags |= hashedSubPackets.getKeyFlags();
        }
        return flags;
    }

    public boolean matches(String id) {
        if (Util.isEmpty(id)) {
            return false;
        }
        Pattern regex = Pattern.compile(id, 18);
        return this.matches(regex);
    }

    public boolean matches(Pattern id) {
        if (id == null || this.publicKey == null) {
            return false;
        }
        if (id.matcher(this.getFingerprint()).find()) {
            return true;
        }
        if (id.matcher(this.getId()).find()) {
            return true;
        }
        Iterator uids = this.publicKey.getUserIDs();
        while (uids.hasNext()) {
            String uid = (String)uids.next();
            if (!id.matcher(uid).find()) continue;
            return true;
        }
        return false;
    }

    public boolean isUnlocked() {
        return this.privateKey != null;
    }

    public void unlock(char[] passphraseChars) throws PGPException {
        this.privateKey = this.extractPrivateKey(passphraseChars);
    }

    public void clearSecrets() {
        if (this.passphraseChars != null) {
            Arrays.fill(this.passphraseChars, '\u0000');
        }
        this.passphraseChars = EMPTY_PASSPHRASE;
        this.passphrase = null;
        this.privateKey = null;
    }

    protected PGPPrivateKey extractPrivateKey(char[] passphraseChars) throws PGPException {
        if (this.secretKey == null) {
            return null;
        }
        try {
            return this.secretKey.extractPrivateKey(this.buildDecryptor(passphraseChars));
        }
        catch (PGPException e) {
            throw new PassphraseException("incorrect passphrase for subkey " + this, (Exception)((Object)e));
        }
    }

    protected PBESecretKeyDecryptor buildDecryptor(char[] passphraseChars) throws PGPException {
        char[] chars = passphraseChars != null && !Arrays.equals(passphraseChars, NO_PASSPHRASE) ? passphraseChars : EMPTY_PASSPHRASE;
        return JcaContextHelper.getJcePBESecretKeyDecryptorBuilder().build(chars);
    }

    protected void calculateUsage() throws PGPException {
        int flags = this.getUsageFlags();
        boolean canSign = (flags & 2) == 2;
        boolean canEncrypt = (flags & 4) == 4 || (flags & 8) == 8;
        this.forSigning = canSign && this.isUsableForSigning();
        this.forVerification = canSign && this.isUsableForVerification();
        this.forEncryption = canEncrypt && this.isUsableForEncryption();
        this.forDecryption = canEncrypt && this.isUsableForDecryption();
    }
}

