/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.discovery.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.discovery.v1.Endpoint;
import io.fabric8.kubernetes.api.model.discovery.v1.EndpointConditions;
import io.fabric8.kubernetes.api.model.discovery.v1.EndpointConditionsBuilder;
import io.fabric8.kubernetes.api.model.discovery.v1.EndpointConditionsFluent;
import io.fabric8.kubernetes.api.model.discovery.v1.EndpointHints;
import io.fabric8.kubernetes.api.model.discovery.v1.EndpointHintsBuilder;
import io.fabric8.kubernetes.api.model.discovery.v1.EndpointHintsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class EndpointFluent<A extends EndpointFluent<A>>
extends BaseFluent<A> {
    private List<String> addresses = new ArrayList<String>();
    private EndpointConditionsBuilder conditions;
    private Map<String, String> deprecatedTopology;
    private EndpointHintsBuilder hints;
    private String hostname;
    private String nodeName;
    private ObjectReferenceBuilder targetRef;
    private String zone;
    private Map<String, Object> additionalProperties;

    public EndpointFluent() {
    }

    public EndpointFluent(Endpoint instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Endpoint instance) {
        Endpoint endpoint = instance = instance != null ? instance : new Endpoint();
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withConditions(instance.getConditions());
            this.withDeprecatedTopology(instance.getDeprecatedTopology());
            this.withHints(instance.getHints());
            this.withHostname(instance.getHostname());
            this.withNodeName(instance.getNodeName());
            this.withTargetRef(instance.getTargetRef());
            this.withZone(instance.getZone());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToAddresses(int index, String item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        this.addresses.add(index, item);
        return (A)((Object)this);
    }

    public A setToAddresses(int index, String item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        this.addresses.set(index, item);
        return (A)((Object)this);
    }

    public A addToAddresses(String ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.addresses.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToAddresses(Collection<String> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.addresses.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromAddresses(String ... items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.addresses.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromAddresses(Collection<String> items) {
        if (this.addresses == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.addresses.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public String getAddress(int index) {
        return this.addresses.get(index);
    }

    public String getFirstAddress() {
        return this.addresses.get(0);
    }

    public String getLastAddress() {
        return this.addresses.get(this.addresses.size() - 1);
    }

    public String getMatchingAddress(Predicate<String> predicate) {
        for (String item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingAddress(Predicate<String> predicate) {
        for (String item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withAddresses(List<String> addresses) {
        if (addresses != null) {
            this.addresses = new ArrayList<String>();
            for (String item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)((Object)this);
    }

    public A withAddresses(String ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
            this._visitables.remove((Object)"addresses");
        }
        if (addresses != null) {
            for (String item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    public EndpointConditions buildConditions() {
        return this.conditions != null ? this.conditions.build() : null;
    }

    public A withConditions(EndpointConditions conditions) {
        this._visitables.remove((Object)"conditions");
        if (conditions != null) {
            this.conditions = new EndpointConditionsBuilder(conditions);
            this._visitables.get((Object)"conditions").add(this.conditions);
        } else {
            this.conditions = null;
            this._visitables.get((Object)"conditions").remove((Object)this.conditions);
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null;
    }

    public A withNewConditions(Boolean ready, Boolean serving, Boolean terminating) {
        return this.withConditions(new EndpointConditions(ready, serving, terminating));
    }

    public ConditionsNested<A> withNewConditions() {
        return new ConditionsNested(null);
    }

    public ConditionsNested<A> withNewConditionsLike(EndpointConditions item) {
        return new ConditionsNested(item);
    }

    public ConditionsNested<A> editConditions() {
        return this.withNewConditionsLike(Optional.ofNullable(this.buildConditions()).orElse(null));
    }

    public ConditionsNested<A> editOrNewConditions() {
        return this.withNewConditionsLike(Optional.ofNullable(this.buildConditions()).orElse(new EndpointConditionsBuilder().build()));
    }

    public ConditionsNested<A> editOrNewConditionsLike(EndpointConditions item) {
        return this.withNewConditionsLike(Optional.ofNullable(this.buildConditions()).orElse(item));
    }

    public A addToDeprecatedTopology(String key, String value) {
        if (this.deprecatedTopology == null && key != null && value != null) {
            this.deprecatedTopology = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.deprecatedTopology.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToDeprecatedTopology(Map<String, String> map) {
        if (this.deprecatedTopology == null && map != null) {
            this.deprecatedTopology = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.deprecatedTopology.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromDeprecatedTopology(String key) {
        if (this.deprecatedTopology == null) {
            return (A)((Object)this);
        }
        if (key != null && this.deprecatedTopology != null) {
            this.deprecatedTopology.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromDeprecatedTopology(Map<String, String> map) {
        if (this.deprecatedTopology == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.deprecatedTopology == null) continue;
                this.deprecatedTopology.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getDeprecatedTopology() {
        return this.deprecatedTopology;
    }

    public <K, V> A withDeprecatedTopology(Map<String, String> deprecatedTopology) {
        this.deprecatedTopology = deprecatedTopology == null ? null : new LinkedHashMap<String, String>(deprecatedTopology);
        return (A)((Object)this);
    }

    public boolean hasDeprecatedTopology() {
        return this.deprecatedTopology != null;
    }

    public EndpointHints buildHints() {
        return this.hints != null ? this.hints.build() : null;
    }

    public A withHints(EndpointHints hints) {
        this._visitables.remove((Object)"hints");
        if (hints != null) {
            this.hints = new EndpointHintsBuilder(hints);
            this._visitables.get((Object)"hints").add(this.hints);
        } else {
            this.hints = null;
            this._visitables.get((Object)"hints").remove((Object)this.hints);
        }
        return (A)((Object)this);
    }

    public boolean hasHints() {
        return this.hints != null;
    }

    public HintsNested<A> withNewHints() {
        return new HintsNested(null);
    }

    public HintsNested<A> withNewHintsLike(EndpointHints item) {
        return new HintsNested(item);
    }

    public HintsNested<A> editHints() {
        return this.withNewHintsLike(Optional.ofNullable(this.buildHints()).orElse(null));
    }

    public HintsNested<A> editOrNewHints() {
        return this.withNewHintsLike(Optional.ofNullable(this.buildHints()).orElse(new EndpointHintsBuilder().build()));
    }

    public HintsNested<A> editOrNewHintsLike(EndpointHints item) {
        return this.withNewHintsLike(Optional.ofNullable(this.buildHints()).orElse(item));
    }

    public String getHostname() {
        return this.hostname;
    }

    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)((Object)this);
    }

    public boolean hasHostname() {
        return this.hostname != null;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)((Object)this);
    }

    public boolean hasNodeName() {
        return this.nodeName != null;
    }

    public ObjectReference buildTargetRef() {
        return this.targetRef != null ? this.targetRef.build() : null;
    }

    public A withTargetRef(ObjectReference targetRef) {
        this._visitables.remove((Object)"targetRef");
        if (targetRef != null) {
            this.targetRef = new ObjectReferenceBuilder(targetRef);
            this._visitables.get((Object)"targetRef").add(this.targetRef);
        } else {
            this.targetRef = null;
            this._visitables.get((Object)"targetRef").remove(this.targetRef);
        }
        return (A)((Object)this);
    }

    public boolean hasTargetRef() {
        return this.targetRef != null;
    }

    public TargetRefNested<A> withNewTargetRef() {
        return new TargetRefNested(null);
    }

    public TargetRefNested<A> withNewTargetRefLike(ObjectReference item) {
        return new TargetRefNested(item);
    }

    public TargetRefNested<A> editTargetRef() {
        return this.withNewTargetRefLike(Optional.ofNullable(this.buildTargetRef()).orElse(null));
    }

    public TargetRefNested<A> editOrNewTargetRef() {
        return this.withNewTargetRefLike(Optional.ofNullable(this.buildTargetRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public TargetRefNested<A> editOrNewTargetRefLike(ObjectReference item) {
        return this.withNewTargetRefLike(Optional.ofNullable(this.buildTargetRef()).orElse(item));
    }

    public String getZone() {
        return this.zone;
    }

    public A withZone(String zone) {
        this.zone = zone;
        return (A)((Object)this);
    }

    public boolean hasZone() {
        return this.zone != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointFluent that = (EndpointFluent)((Object)o);
        if (!Objects.equals(this.addresses, that.addresses)) {
            return false;
        }
        if (!Objects.equals((Object)this.conditions, (Object)that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.deprecatedTopology, that.deprecatedTopology)) {
            return false;
        }
        if (!Objects.equals((Object)this.hints, (Object)that.hints)) {
            return false;
        }
        if (!Objects.equals(this.hostname, that.hostname)) {
            return false;
        }
        if (!Objects.equals(this.nodeName, that.nodeName)) {
            return false;
        }
        if (!Objects.equals(this.targetRef, that.targetRef)) {
            return false;
        }
        if (!Objects.equals(this.zone, that.zone)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.addresses, this.conditions, this.deprecatedTopology, this.hints, this.hostname, this.nodeName, this.targetRef, this.zone, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            sb.append("addresses:");
            sb.append(this.addresses + ",");
        }
        if (this.conditions != null) {
            sb.append("conditions:");
            sb.append((Object)((Object)this.conditions) + ",");
        }
        if (this.deprecatedTopology != null && !this.deprecatedTopology.isEmpty()) {
            sb.append("deprecatedTopology:");
            sb.append(this.deprecatedTopology + ",");
        }
        if (this.hints != null) {
            sb.append("hints:");
            sb.append((Object)((Object)this.hints) + ",");
        }
        if (this.hostname != null) {
            sb.append("hostname:");
            sb.append(this.hostname + ",");
        }
        if (this.nodeName != null) {
            sb.append("nodeName:");
            sb.append(this.nodeName + ",");
        }
        if (this.targetRef != null) {
            sb.append("targetRef:");
            sb.append(this.targetRef + ",");
        }
        if (this.zone != null) {
            sb.append("zone:");
            sb.append(this.zone + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TargetRefNested<N>
    extends ObjectReferenceFluent<TargetRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        TargetRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder((ObjectReferenceFluent)this, item);
        }

        public N and() {
            return (N)EndpointFluent.this.withTargetRef(this.builder.build());
        }

        public N endTargetRef() {
            return this.and();
        }
    }

    public class HintsNested<N>
    extends EndpointHintsFluent<HintsNested<N>>
    implements Nested<N> {
        EndpointHintsBuilder builder;

        HintsNested(EndpointHints item) {
            this.builder = new EndpointHintsBuilder(this, item);
        }

        public N and() {
            return (N)EndpointFluent.this.withHints(this.builder.build());
        }

        public N endHints() {
            return this.and();
        }
    }

    public class ConditionsNested<N>
    extends EndpointConditionsFluent<ConditionsNested<N>>
    implements Nested<N> {
        EndpointConditionsBuilder builder;

        ConditionsNested(EndpointConditions item) {
            this.builder = new EndpointConditionsBuilder(this, item);
        }

        public N and() {
            return (N)EndpointFluent.this.withConditions(this.builder.build());
        }

        public N endConditions() {
            return this.and();
        }
    }
}

