/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.grpc.netty;

import org.apache.kyuubi.shade.com.google.common.base.MoreObjects;
import org.apache.kyuubi.shade.com.google.common.base.Objects;
import org.apache.kyuubi.shade.com.google.common.base.Preconditions;
import org.apache.kyuubi.shade.io.grpc.Status;
import org.apache.kyuubi.shade.io.grpc.netty.NettyServerStream;
import org.apache.kyuubi.shade.io.grpc.netty.WriteQueue;

final class CancelServerStreamCommand
extends WriteQueue.AbstractQueuedCommand {
    private final NettyServerStream.TransportState stream;
    private final Status reason;
    private final PeerNotify peerNotify;

    private CancelServerStreamCommand(NettyServerStream.TransportState stream, Status reason, PeerNotify peerNotify) {
        this.stream = Preconditions.checkNotNull(stream, "stream");
        this.reason = Preconditions.checkNotNull(reason, "reason");
        this.peerNotify = Preconditions.checkNotNull(peerNotify, "peerNotify");
    }

    static CancelServerStreamCommand withReset(NettyServerStream.TransportState stream, Status reason) {
        return new CancelServerStreamCommand(stream, reason, PeerNotify.RESET);
    }

    static CancelServerStreamCommand withReason(NettyServerStream.TransportState stream, Status reason) {
        return new CancelServerStreamCommand(stream, reason, PeerNotify.BEST_EFFORT_STATUS);
    }

    NettyServerStream.TransportState stream() {
        return this.stream;
    }

    Status reason() {
        return this.reason;
    }

    boolean wantsHeaders() {
        return this.peerNotify == PeerNotify.BEST_EFFORT_STATUS;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CancelServerStreamCommand that = (CancelServerStreamCommand)o;
        return this.stream.equals(that.stream) && this.reason.equals(that.reason) && this.peerNotify.equals((Object)that.peerNotify);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.stream, this.reason, this.peerNotify});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("stream", this.stream).add("reason", this.reason).add("peerNotify", (Object)this.peerNotify).toString();
    }

    private static enum PeerNotify {
        RESET,
        BEST_EFFORT_STATUS;

    }
}

