/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.xml.bind.model.concrete;

import java.text.MessageFormat;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.lang.Validate;
import org.jvnet.jaxb2_commons.xml.bind.model.MClassInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MContainer;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPackageInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MTypeInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.origin.MElementInfoOrigin;

public class CMElementInfo<T, C extends T>
implements MElementInfo<T, C> {
    private final MElementInfoOrigin origin;
    private final MPackageInfo _package;
    private final MContainer container;
    private final String localName;
    private final QName elementName;
    private final MClassInfo<T, C> scope;
    private final MTypeInfo<T, C> typeInfo;
    private final QName substitutionHead;
    private final String defaultValue;
    private final NamespaceContext defaultValueNamespaceContext;

    public CMElementInfo(MElementInfoOrigin origin, MPackageInfo _package, MContainer container, String localName, QName elementName, MClassInfo<T, C> scope, MTypeInfo<T, C> typeInfo, QName substitutionHead, String defaultValue, NamespaceContext defaultValueNamespaceContext) {
        Validate.notNull(origin);
        Validate.notNull(elementName);
        Validate.notNull(_package);
        this.origin = origin;
        this._package = _package;
        this.container = container;
        this.localName = localName;
        this.elementName = elementName;
        this.scope = scope;
        this.typeInfo = typeInfo;
        this.substitutionHead = substitutionHead;
        this.defaultValue = defaultValue;
        this.defaultValueNamespaceContext = defaultValueNamespaceContext;
    }

    @Override
    public MElementInfoOrigin getOrigin() {
        return this.origin;
    }

    @Override
    public MPackageInfo getPackageInfo() {
        return this._package;
    }

    @Override
    public MContainer getContainer() {
        return this.container;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public String getContainerLocalName(String delimiter) {
        String localName = this.getLocalName();
        if (localName == null) {
            return null;
        }
        MContainer container = this.getContainer();
        if (container == null) {
            return localName;
        }
        String containerLocalName = container.getContainerLocalName(delimiter);
        return containerLocalName == null ? localName : containerLocalName + delimiter + localName;
    }

    @Override
    public QName getElementName() {
        return this.elementName;
    }

    @Override
    public MClassInfo<T, C> getScope() {
        return this.scope;
    }

    @Override
    public MTypeInfo<T, C> getTypeInfo() {
        return this.typeInfo;
    }

    @Override
    public QName getSubstitutionHead() {
        return this.substitutionHead;
    }

    @Override
    public boolean isNillable() {
        return true;
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public NamespaceContext getDefaultValueNamespaceContext() {
        return this.defaultValueNamespaceContext;
    }

    public String toString() {
        return MessageFormat.format("ElementInfo [{0}: {1}]", this.getElementName(), this.getTypeInfo());
    }
}

