/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft.internals;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalLong;
import org.apache.kafka.raft.Batch;
import org.apache.kafka.raft.BatchReader;
import org.apache.kafka.raft.internals.CloseListener;

public class MemoryBatchReader<T>
implements BatchReader<T> {
    private final CloseListener<BatchReader<T>> closeListener;
    private final Iterator<Batch<T>> iterator;
    private final long baseOffset;
    private final long lastOffset;

    private MemoryBatchReader(long baseOffset, long lastOffset, Iterator<Batch<T>> iterator, CloseListener<BatchReader<T>> closeListener) {
        this.baseOffset = baseOffset;
        this.lastOffset = lastOffset;
        this.iterator = iterator;
        this.closeListener = closeListener;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Batch<T> next() {
        return this.iterator.next();
    }

    @Override
    public long baseOffset() {
        return this.baseOffset;
    }

    @Override
    public OptionalLong lastOffset() {
        return OptionalLong.of(this.lastOffset);
    }

    @Override
    public void close() {
        this.closeListener.onClose(this);
    }

    public static <T> MemoryBatchReader<T> empty(long baseOffset, long lastOffset, CloseListener<BatchReader<T>> closeListener) {
        return new MemoryBatchReader<T>(baseOffset, lastOffset, Collections.emptyIterator(), closeListener);
    }

    public static <T> MemoryBatchReader<T> of(List<Batch<T>> batches, CloseListener<BatchReader<T>> closeListener) {
        if (batches.isEmpty()) {
            throw new IllegalArgumentException("MemoryBatchReader requires at least one batch to iterate, but an empty list was provided");
        }
        return new MemoryBatchReader<T>(batches.get(0).baseOffset(), batches.get(batches.size() - 1).lastOffset(), batches.iterator(), closeListener);
    }
}

