/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.swap;

import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.commons.function.ThrowingFunction;
import org.apache.juneau.swap.ObjectSwap;

public class FunctionalSwap<T, S>
extends ObjectSwap<T, S> {
    private final ThrowingFunction<T, S> swapFunction;
    private final ThrowingFunction<S, T> unswapFunction;

    public FunctionalSwap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction) {
        this(normalClass, swappedClass, swapFunction, null);
    }

    public FunctionalSwap(Class<T> normalClass, Class<S> swappedClass, ThrowingFunction<T, S> swapFunction, ThrowingFunction<S, T> unswapFunction) {
        super(normalClass, swappedClass);
        this.swapFunction = swapFunction;
        this.unswapFunction = unswapFunction;
    }

    @Override
    public S swap(BeanSession session, T o, String template) throws Exception {
        if (this.swapFunction == null) {
            return super.swap(session, o, template);
        }
        return (S)this.swapFunction.applyThrows(o);
    }

    @Override
    public T unswap(BeanSession session, S f, ClassMeta<?> hint, String template) throws Exception {
        if (this.unswapFunction == null) {
            return super.unswap(session, f, hint, template);
        }
        return (T)this.unswapFunction.applyThrows(f);
    }
}

