/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer.validate;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.operation.buffer.validate.DistanceToPointFinder;
import org.locationtech.jts.operation.buffer.validate.PointPairDistance;

public class BufferCurveMaximumDistanceFinder {
    private Geometry inputGeom;
    private PointPairDistance maxPtDist = new PointPairDistance();

    public BufferCurveMaximumDistanceFinder(Geometry inputGeom) {
        this.inputGeom = inputGeom;
    }

    public double findDistance(Geometry bufferCurve) {
        this.computeMaxVertexDistance(bufferCurve);
        this.computeMaxMidpointDistance(bufferCurve);
        return this.maxPtDist.getDistance();
    }

    public PointPairDistance getDistancePoints() {
        return this.maxPtDist;
    }

    private void computeMaxVertexDistance(Geometry curve) {
        MaxPointDistanceFilter distFilter = new MaxPointDistanceFilter(this.inputGeom);
        curve.apply(distFilter);
        this.maxPtDist.setMaximum(distFilter.getMaxPointDistance());
    }

    private void computeMaxMidpointDistance(Geometry curve) {
        MaxMidpointDistanceFilter distFilter = new MaxMidpointDistanceFilter(this.inputGeom);
        curve.apply(distFilter);
        this.maxPtDist.setMaximum(distFilter.getMaxPointDistance());
    }

    public static class MaxMidpointDistanceFilter
    implements CoordinateSequenceFilter {
        private PointPairDistance maxPtDist = new PointPairDistance();
        private PointPairDistance minPtDist = new PointPairDistance();
        private Geometry geom;

        public MaxMidpointDistanceFilter(Geometry geom) {
            this.geom = geom;
        }

        @Override
        public void filter(CoordinateSequence seq2, int index) {
            if (index == 0) {
                return;
            }
            Coordinate p0 = seq2.getCoordinate(index - 1);
            Coordinate p1 = seq2.getCoordinate(index);
            Coordinate midPt = new Coordinate((p0.x + p1.x) / 2.0, (p0.y + p1.y) / 2.0);
            this.minPtDist.initialize();
            DistanceToPointFinder.computeDistance(this.geom, midPt, this.minPtDist);
            this.maxPtDist.setMaximum(this.minPtDist);
        }

        @Override
        public boolean isGeometryChanged() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        public PointPairDistance getMaxPointDistance() {
            return this.maxPtDist;
        }
    }

    public static class MaxPointDistanceFilter
    implements CoordinateFilter {
        private PointPairDistance maxPtDist = new PointPairDistance();
        private PointPairDistance minPtDist = new PointPairDistance();
        private Geometry geom;

        public MaxPointDistanceFilter(Geometry geom) {
            this.geom = geom;
        }

        @Override
        public void filter(Coordinate pt) {
            this.minPtDist.initialize();
            DistanceToPointFinder.computeDistance(this.geom, pt, this.minPtDist);
            this.maxPtDist.setMaximum(this.minPtDist);
        }

        public PointPairDistance getMaxPointDistance() {
            return this.maxPtDist;
        }
    }
}

