/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.adapters;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFWriterI;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.writer.WriterGraphRIOTBase;
import org.apache.jena.sparql.util.Context;

public abstract class AdapterRDFWriter
extends WriterGraphRIOTBase {
    protected abstract RDFWriterI create();

    @Override
    public abstract Lang getLang();

    @Override
    public void write(Writer out, Graph graph, PrefixMap prefixMap, String baseURI, Context context2) {
        RDFWriterI w = this.create();
        this.setProperties(w, context2);
        w.write(ModelFactory.createModelForGraph(graph), out, baseURI);
    }

    @Override
    public void write(OutputStream out, Graph graph, PrefixMap prefixMap, String baseURI, Context context2) {
        RDFWriterI w = this.create();
        this.setProperties(w, context2);
        w.write(ModelFactory.createModelForGraph(graph), out, baseURI);
    }

    private void setProperties(RDFWriterI w, Context context2) {
        if (context2 == null) {
            return;
        }
        Map properties = null;
        try {
            Map p;
            properties = p = (Map)context2.get(SysRIOT.sysRdfWriterProperties);
        }
        catch (Throwable ex) {
            Log.warn(this, "Problem accessing the RDF/XML writer properties: properties ignored", ex);
        }
        if (properties != null) {
            properties.forEach((k, v) -> w.setProperty((String)k, v));
        }
    }
}

