/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.params;

import java.util.Objects;
import org.apache.jena.dboe.base.block.BlockParams;
import org.apache.jena.dboe.base.block.FileMode;
import org.apache.jena.dboe.index.IndexParams;
import org.apache.jena.tdb2.params.StoreParamsBuilder;
import org.apache.jena.tdb2.params.StoreParamsConst;
import org.apache.jena.tdb2.params.StoreParamsDynamic;

public class StoreParams
implements IndexParams,
BlockParams,
StoreParamsDynamic {
    final String label;
    final StoreParamsBuilder.Item<FileMode> fileMode;
    final StoreParamsBuilder.Item<Integer> blockReadCacheSize;
    final StoreParamsBuilder.Item<Integer> blockWriteCacheSize;
    final StoreParamsBuilder.Item<Integer> Node2NodeIdCacheSize;
    final StoreParamsBuilder.Item<Integer> NodeId2NodeCacheSize;
    final StoreParamsBuilder.Item<Integer> NodeMissCacheSize;
    final StoreParamsBuilder.Item<Integer> prefixNode2NodeIdCacheSize;
    final StoreParamsBuilder.Item<Integer> prefixNodeId2NodeCacheSize;
    final StoreParamsBuilder.Item<Integer> prefixNodeMissCacheSize;
    final StoreParamsBuilder.Item<Double> nodeCacheInitialCapacityFactor;
    final StoreParamsBuilder.Item<Integer> blockSize;
    final StoreParamsBuilder.Item<String> nodeTableBaseName;
    final StoreParamsBuilder.Item<String> primaryIndexTriples;
    final StoreParamsBuilder.Item<String[]> tripleIndexes;
    final StoreParamsBuilder.Item<String> primaryIndexQuads;
    final StoreParamsBuilder.Item<String[]> quadIndexes;
    final StoreParamsBuilder.Item<String> prefixTableBaseName;
    final StoreParamsBuilder.Item<String> primaryIndexPrefix;
    final StoreParamsBuilder.Item<String[]> prefixIndexes;

    @Deprecated
    public static StoreParamsBuilder builder() {
        return StoreParams.builder((String)null);
    }

    @Deprecated
    public static StoreParamsBuilder builder(StoreParams params) {
        return StoreParams.builder(null, params);
    }

    public static StoreParamsBuilder builder(String label) {
        return StoreParamsBuilder.create(label);
    }

    public static StoreParamsBuilder builder(String label, StoreParams params) {
        return StoreParamsBuilder.create(label, params);
    }

    StoreParams(String label, StoreParamsBuilder.Item<FileMode> fileMode, StoreParamsBuilder.Item<Integer> blockSize, StoreParamsBuilder.Item<Integer> blockReadCacheSize, StoreParamsBuilder.Item<Integer> blockWriteCacheSize, StoreParamsBuilder.Item<Integer> node2NodeIdCacheSize, StoreParamsBuilder.Item<Integer> nodeId2NodeCacheSize, StoreParamsBuilder.Item<Integer> nodeMissCacheSize, StoreParamsBuilder.Item<Integer> prefixNode2NodeIdCacheSize, StoreParamsBuilder.Item<Integer> prefixNodeId2NodeCacheSize, StoreParamsBuilder.Item<Integer> prefixNodeMissCacheSize, StoreParamsBuilder.Item<Double> nodeCacheInitialCapacityFactor, StoreParamsBuilder.Item<String> nodeTableBaseName, StoreParamsBuilder.Item<String> primaryIndexTriples, StoreParamsBuilder.Item<String[]> tripleIndexes, StoreParamsBuilder.Item<String> primaryIndexQuads, StoreParamsBuilder.Item<String[]> quadIndexes, StoreParamsBuilder.Item<String> prefixTableBasename, StoreParamsBuilder.Item<String> primaryIndexPrefix, StoreParamsBuilder.Item<String[]> prefixIndexes) {
        this.label = label;
        this.fileMode = fileMode;
        this.blockSize = blockSize;
        this.blockReadCacheSize = blockReadCacheSize;
        this.blockWriteCacheSize = blockWriteCacheSize;
        this.Node2NodeIdCacheSize = node2NodeIdCacheSize;
        this.NodeId2NodeCacheSize = nodeId2NodeCacheSize;
        this.NodeMissCacheSize = nodeMissCacheSize;
        this.prefixNode2NodeIdCacheSize = prefixNode2NodeIdCacheSize;
        this.prefixNodeId2NodeCacheSize = prefixNodeId2NodeCacheSize;
        this.prefixNodeMissCacheSize = prefixNodeMissCacheSize;
        this.nodeCacheInitialCapacityFactor = nodeCacheInitialCapacityFactor;
        this.nodeTableBaseName = nodeTableBaseName;
        this.primaryIndexTriples = primaryIndexTriples;
        this.tripleIndexes = tripleIndexes;
        this.primaryIndexQuads = primaryIndexQuads;
        this.quadIndexes = quadIndexes;
        this.primaryIndexPrefix = primaryIndexPrefix;
        this.prefixIndexes = prefixIndexes;
        this.prefixTableBaseName = prefixTableBasename;
    }

    public static StoreParams getDftStoreParams() {
        return StoreParamsConst.dftStoreParams;
    }

    public static StoreParams getDftMemStoreParams() {
        return StoreParamsConst.dftMemStoreParams;
    }

    public static StoreParams getSmallStoreParams() {
        return StoreParamsConst.smallStoreParams;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public FileMode getFileMode() {
        return (FileMode)((Object)this.fileMode.value);
    }

    @Override
    public boolean isSetFileMode() {
        return this.fileMode.isSet;
    }

    @Override
    public Integer getBlockSize() {
        return (Integer)this.blockSize.value;
    }

    @Override
    public Integer getBlockReadCacheSize() {
        return (Integer)this.blockReadCacheSize.value;
    }

    @Override
    public boolean isSetBlockReadCacheSize() {
        return this.blockReadCacheSize.isSet;
    }

    @Override
    public Integer getBlockWriteCacheSize() {
        return (Integer)this.blockWriteCacheSize.value;
    }

    @Override
    public boolean isSetBlockWriteCacheSize() {
        return this.blockWriteCacheSize.isSet;
    }

    @Override
    public Integer getNode2NodeIdCacheSize() {
        return (Integer)this.Node2NodeIdCacheSize.value;
    }

    @Override
    public boolean isSetNodeId2NodeCacheSize() {
        return this.NodeId2NodeCacheSize.isSet;
    }

    @Override
    public boolean isSetNode2NodeIdCacheSize() {
        return this.Node2NodeIdCacheSize.isSet;
    }

    @Override
    public Integer getNodeId2NodeCacheSize() {
        return (Integer)this.NodeId2NodeCacheSize.value;
    }

    @Override
    public Integer getNodeMissCacheSize() {
        return (Integer)this.NodeMissCacheSize.value;
    }

    @Override
    public boolean isSetNodeMissCacheSize() {
        return this.NodeMissCacheSize.isSet;
    }

    @Override
    public Integer getPrefixNode2NodeIdCacheSize() {
        return (Integer)this.prefixNode2NodeIdCacheSize.value;
    }

    @Override
    public boolean isSetPrefixNodeId2NodeCacheSize() {
        return this.prefixNodeId2NodeCacheSize.isSet;
    }

    @Override
    public boolean isSetPrefixNode2NodeIdCacheSize() {
        return this.prefixNode2NodeIdCacheSize.isSet;
    }

    @Override
    public Integer getPrefixNodeId2NodeCacheSize() {
        return (Integer)this.prefixNodeId2NodeCacheSize.value;
    }

    @Override
    public Integer getPrefixNodeMissCacheSize() {
        return (Integer)this.prefixNodeMissCacheSize.value;
    }

    @Override
    public boolean isSetPrefixNodeMissCacheSize() {
        return this.prefixNodeMissCacheSize.isSet;
    }

    @Override
    public Double getNodeCacheInitialCapacityFactor() {
        return (Double)this.nodeCacheInitialCapacityFactor.value;
    }

    @Override
    public boolean isSetNodeCacheInitialCapacityFactor() {
        return this.nodeCacheInitialCapacityFactor.isSet;
    }

    public String getNodeTableBaseName() {
        return (String)this.nodeTableBaseName.value;
    }

    public boolean isSetNodeTableBaseName() {
        return this.nodeTableBaseName.isSet;
    }

    public String getPrimaryIndexTriples() {
        return (String)this.primaryIndexTriples.value;
    }

    public String[] getTripleIndexes() {
        return (String[])this.tripleIndexes.value;
    }

    public String getPrimaryIndexQuads() {
        return (String)this.primaryIndexQuads.value;
    }

    public String[] getQuadIndexes() {
        return (String[])this.quadIndexes.value;
    }

    public String getPrefixTableBaseName() {
        return (String)this.prefixTableBaseName.value;
    }

    public boolean isSetPrefixBaseName() {
        return this.prefixTableBaseName.isSet;
    }

    public String getPrimaryIndexPrefix() {
        return (String)this.primaryIndexPrefix.value;
    }

    public String[] getPrefixIndexes() {
        return (String[])this.prefixIndexes.value;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        if (this.label != null) {
            this.fmt(buff, "label", this.label, true);
        }
        this.fmt(buff, "fileMode", this.getFileMode().toString(), this.fileMode.isSet);
        this.fmt(buff, "blockSize", this.getBlockSize(), this.blockSize.isSet);
        this.fmt(buff, "readCacheSize", this.getBlockReadCacheSize(), this.blockReadCacheSize.isSet);
        this.fmt(buff, "writeCacheSize", this.getBlockWriteCacheSize(), this.blockWriteCacheSize.isSet);
        this.fmt(buff, "Node2NodeIdCacheSize", this.getNode2NodeIdCacheSize(), this.Node2NodeIdCacheSize.isSet);
        this.fmt(buff, "NodeId2NodeCacheSize", this.getNodeId2NodeCacheSize(), this.NodeId2NodeCacheSize.isSet);
        this.fmt(buff, "NodeMissCacheSize", this.getNodeMissCacheSize(), this.NodeMissCacheSize.isSet);
        this.fmt(buff, "prefixNode2NodeIdCacheSize", this.getPrefixNode2NodeIdCacheSize(), this.prefixNode2NodeIdCacheSize.isSet);
        this.fmt(buff, "prefixNodeId2NodeCacheSize", this.getPrefixNodeId2NodeCacheSize(), this.prefixNodeId2NodeCacheSize.isSet);
        this.fmt(buff, "prefixNodeMissCacheSize", this.getPrefixNodeMissCacheSize(), this.prefixNodeMissCacheSize.isSet);
        this.fmt(buff, "nodeCacheInitialCapacityFactor", this.getNodeCacheInitialCapacityFactor(), this.nodeCacheInitialCapacityFactor.isSet);
        this.fmt(buff, "nodeTableBaseName", this.getNodeTableBaseName(), this.nodeTableBaseName.isSet);
        this.fmt(buff, "primaryIndexTriples", this.getPrimaryIndexTriples(), this.primaryIndexTriples.isSet);
        this.fmt(buff, "tripleIndexes", this.getTripleIndexes(), this.tripleIndexes.isSet);
        this.fmt(buff, "primaryIndexQuads", this.getPrimaryIndexQuads(), this.primaryIndexQuads.isSet);
        this.fmt(buff, "quadIndexes", this.getQuadIndexes(), this.quadIndexes.isSet);
        this.fmt(buff, "prefixTableBaseName", this.getPrefixTableBaseName(), this.prefixTableBaseName.isSet);
        this.fmt(buff, "primaryIndexPrefix", this.getPrimaryIndexPrefix(), this.primaryIndexPrefix.isSet);
        this.fmt(buff, "prefixIndexes", this.getPrefixIndexes(), this.prefixIndexes.isSet);
        return buff.toString();
    }

    private void fmt(StringBuilder buff, String name, String[] strings, boolean isSet) {
        String dftStr = "";
        if (!isSet) {
            dftStr = "dft:";
        }
        buff.append(String.format("%-20s   %s[%s]\n", name, dftStr, String.join((CharSequence)", ", strings)));
    }

    private void fmt(StringBuilder buff, String name, String value, boolean isSet) {
        String dftStr = "";
        if (!isSet) {
            dftStr = "dft:";
        }
        buff.append(String.format("%-20s   %s%s\n", name, dftStr, value));
    }

    private void fmt(StringBuilder buff, String name, int value, boolean isSet) {
        String dftStr = "";
        if (!isSet) {
            dftStr = "dft:";
        }
        buff.append(String.format("%-20s   %s%s\n", name, dftStr, value));
    }

    private void fmt(StringBuilder buff, String name, double value, boolean isSet) {
        String dftStr = "";
        if (!isSet) {
            dftStr = "dft:";
        }
        buff.append(String.format("%-20s   %s%s\n", name, dftStr, value));
    }

    public static boolean sameValues(StoreParams params1, StoreParams params2) {
        if (params1 == null && params2 == null) {
            return true;
        }
        if (params1 == null) {
            return false;
        }
        if (params2 == null) {
            return false;
        }
        if (!StoreParams.sameValues(params1.fileMode, params2.fileMode)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.blockSize, params2.blockSize)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.blockReadCacheSize, params2.blockReadCacheSize)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.blockWriteCacheSize, params2.blockWriteCacheSize)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.Node2NodeIdCacheSize, params2.Node2NodeIdCacheSize)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.NodeId2NodeCacheSize, params2.NodeId2NodeCacheSize)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.NodeMissCacheSize, params2.NodeMissCacheSize)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.prefixNode2NodeIdCacheSize, params2.prefixNode2NodeIdCacheSize)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.prefixNodeId2NodeCacheSize, params2.prefixNodeId2NodeCacheSize)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.prefixNodeMissCacheSize, params2.prefixNodeMissCacheSize)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.nodeCacheInitialCapacityFactor, params2.nodeCacheInitialCapacityFactor)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.nodeTableBaseName, params2.nodeTableBaseName)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.primaryIndexTriples, params2.primaryIndexTriples)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.tripleIndexes, params2.tripleIndexes)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.primaryIndexQuads, params2.primaryIndexQuads)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.quadIndexes, params2.quadIndexes)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.prefixTableBaseName, params2.prefixTableBaseName)) {
            return false;
        }
        if (!StoreParams.sameValues(params1.primaryIndexPrefix, params2.primaryIndexPrefix)) {
            return false;
        }
        return StoreParams.sameValues(params1.prefixIndexes, params2.prefixIndexes);
    }

    private static <X> boolean sameValues(StoreParamsBuilder.Item<X> item1, StoreParamsBuilder.Item<X> item2) {
        return Objects.deepEquals(item1.value, item2.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.Node2NodeIdCacheSize == null ? 0 : this.Node2NodeIdCacheSize.hashCode());
        result = 31 * result + (this.NodeId2NodeCacheSize == null ? 0 : this.NodeId2NodeCacheSize.hashCode());
        result = 31 * result + (this.NodeMissCacheSize == null ? 0 : this.NodeMissCacheSize.hashCode());
        result = 31 * result + (this.prefixNode2NodeIdCacheSize == null ? 0 : this.prefixNode2NodeIdCacheSize.hashCode());
        result = 31 * result + (this.prefixNodeId2NodeCacheSize == null ? 0 : this.prefixNodeId2NodeCacheSize.hashCode());
        result = 31 * result + (this.prefixNodeMissCacheSize == null ? 0 : this.prefixNodeMissCacheSize.hashCode());
        result = 31 * result + (this.nodeCacheInitialCapacityFactor == null ? 0 : this.nodeCacheInitialCapacityFactor.hashCode());
        result = 31 * result + (this.blockReadCacheSize == null ? 0 : this.blockReadCacheSize.hashCode());
        result = 31 * result + (this.blockSize == null ? 0 : this.blockSize.hashCode());
        result = 31 * result + (this.blockWriteCacheSize == null ? 0 : this.blockWriteCacheSize.hashCode());
        result = 31 * result + (this.fileMode == null ? 0 : this.fileMode.hashCode());
        result = 31 * result + (this.nodeTableBaseName == null ? 0 : this.nodeTableBaseName.hashCode());
        result = 31 * result + (this.prefixTableBaseName == null ? 0 : this.prefixTableBaseName.hashCode());
        result = 31 * result + (this.prefixIndexes == null ? 0 : this.prefixIndexes.hashCode());
        result = 31 * result + (this.primaryIndexPrefix == null ? 0 : this.primaryIndexPrefix.hashCode());
        result = 31 * result + (this.primaryIndexQuads == null ? 0 : this.primaryIndexQuads.hashCode());
        result = 31 * result + (this.primaryIndexTriples == null ? 0 : this.primaryIndexTriples.hashCode());
        result = 31 * result + (this.quadIndexes == null ? 0 : this.quadIndexes.hashCode());
        result = 31 * result + (this.tripleIndexes == null ? 0 : this.tripleIndexes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StoreParams other = (StoreParams)obj;
        if (this.Node2NodeIdCacheSize == null ? other.Node2NodeIdCacheSize != null : !this.Node2NodeIdCacheSize.equals(other.Node2NodeIdCacheSize)) {
            return false;
        }
        if (this.NodeId2NodeCacheSize == null ? other.NodeId2NodeCacheSize != null : !this.NodeId2NodeCacheSize.equals(other.NodeId2NodeCacheSize)) {
            return false;
        }
        if (this.NodeMissCacheSize == null ? other.NodeMissCacheSize != null : !this.NodeMissCacheSize.equals(other.NodeMissCacheSize)) {
            return false;
        }
        if (this.prefixNode2NodeIdCacheSize == null ? other.prefixNode2NodeIdCacheSize != null : !this.prefixNode2NodeIdCacheSize.equals(other.prefixNode2NodeIdCacheSize)) {
            return false;
        }
        if (this.prefixNodeId2NodeCacheSize == null ? other.prefixNodeId2NodeCacheSize != null : !this.prefixNodeId2NodeCacheSize.equals(other.prefixNodeId2NodeCacheSize)) {
            return false;
        }
        if (this.prefixNodeMissCacheSize == null ? other.prefixNodeMissCacheSize != null : !this.prefixNodeMissCacheSize.equals(other.prefixNodeMissCacheSize)) {
            return false;
        }
        if (this.nodeCacheInitialCapacityFactor == null ? other.nodeCacheInitialCapacityFactor != null : !this.nodeCacheInitialCapacityFactor.equals(other.nodeCacheInitialCapacityFactor)) {
            return false;
        }
        if (this.blockReadCacheSize == null ? other.blockReadCacheSize != null : !this.blockReadCacheSize.equals(other.blockReadCacheSize)) {
            return false;
        }
        if (this.blockSize == null ? other.blockSize != null : !this.blockSize.equals(other.blockSize)) {
            return false;
        }
        if (this.blockWriteCacheSize == null ? other.blockWriteCacheSize != null : !this.blockWriteCacheSize.equals(other.blockWriteCacheSize)) {
            return false;
        }
        if (this.fileMode == null ? other.fileMode != null : !this.fileMode.equals(other.fileMode)) {
            return false;
        }
        if (this.nodeTableBaseName == null ? other.nodeTableBaseName != null : !this.nodeTableBaseName.equals(other.nodeTableBaseName)) {
            return false;
        }
        if (this.prefixTableBaseName == null ? other.prefixTableBaseName != null : !this.prefixTableBaseName.equals(other.prefixTableBaseName)) {
            return false;
        }
        if (this.prefixIndexes == null ? other.prefixIndexes != null : !this.prefixIndexes.equals(other.prefixIndexes)) {
            return false;
        }
        if (this.primaryIndexPrefix == null ? other.primaryIndexPrefix != null : !this.primaryIndexPrefix.equals(other.primaryIndexPrefix)) {
            return false;
        }
        if (this.primaryIndexQuads == null ? other.primaryIndexQuads != null : !this.primaryIndexQuads.equals(other.primaryIndexQuads)) {
            return false;
        }
        if (this.primaryIndexTriples == null ? other.primaryIndexTriples != null : !this.primaryIndexTriples.equals(other.primaryIndexTriples)) {
            return false;
        }
        if (this.quadIndexes == null ? other.quadIndexes != null : !this.quadIndexes.equals(other.quadIndexes)) {
            return false;
        }
        return !(this.tripleIndexes == null ? other.tripleIndexes != null : !this.tripleIndexes.equals(other.tripleIndexes));
    }
}

