/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets.prefixes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.fuseki.servlets.prefixes.PrefixesAccess;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.UpdateExec;
import org.apache.jena.tdb2.DatabaseMgr;

public class PrefixesRDF
implements PrefixesAccess {
    DatasetGraph dataset = DatabaseMgr.createDatasetGraph();

    @Override
    public Transactional transactional() {
        return this.dataset;
    }

    @Override
    public Optional<String> fetchURI(String prefix) {
        ParameterizedSparqlString pss = new ParameterizedSparqlString("PREFIX prefixes: <http://jena.apache.org/prefixes#>\nSELECT ?prefixURI WHERE {\n    ?X prefixes:prefixName ?prefixName .\n    ?X prefixes:prefixURI ?prefixURI\n}\n");
        pss.setLiteral("prefixName", prefix);
        String query2 = pss.toString();
        return this.dataset.calculateRead(() -> {
            try (QueryExec qExec = QueryExec.dataset(this.dataset).query(query2).build();){
                ArrayList x = new ArrayList();
                RowSet rowSet = qExec.select();
                rowSet.forEachRemaining(row -> {
                    String prefixNameLiteral = row.get("prefixURI").getLiteralLexicalForm();
                    if (prefixNameLiteral != null) {
                        x.add(prefixNameLiteral);
                    }
                });
                if (x.isEmpty()) {
                    Optional optional = Optional.empty();
                    return optional;
                }
                Optional<String> optional = Optional.ofNullable((String)x.get(0));
                return optional;
            }
        });
    }

    @Override
    public void updatePrefix(String prefix, String uri) {
        ParameterizedSparqlString pss = new ParameterizedSparqlString("PREFIX prefixes: <http://jena.apache.org/prefixes#>\nPREFIX xsd:      <http://www.w3.org/2001/XMLSchema#>\nASK WHERE {  ?X prefixes:prefixName  ?prefixName ;\n                prefixes:prefixURI   ?prefixURI .\n}\n");
        pss.setLiteral("prefixName", prefix);
        String query2 = pss.toString();
        this.dataset.executeWrite(() -> {
            String update2;
            AtomicBoolean result = new AtomicBoolean(false);
            try (QueryExec qExec = QueryExec.dataset(this.dataset).query(query2).build();){
                result.set(qExec.ask());
            }
            if (result.get()) {
                ParameterizedSparqlString pssUpdate = new ParameterizedSparqlString("        PREFIX prefixes: <http://jena.apache.org/prefixes#>\n        PREFIX xsd:      <http://www.w3.org/2001/XMLSchema#>\n        DELETE { ?X prefixes:prefixURI ?oldURI }\n        INSERT { ?X prefixes:prefixURI ?newURI }\n        WHERE {\n            ?X prefixes:prefixName ?prefixName ;\n                prefixes:prefixURI ?oldURI\n        }\n");
                pssUpdate.setLiteral("prefixName", prefix);
                pssUpdate.setLiteral("newURI", uri, (RDFDatatype)XSDDatatype.XSDanyURI);
                update2 = pssUpdate.toString();
            } else {
                ParameterizedSparqlString pssUpdate = new ParameterizedSparqlString("       PREFIX prefixes: <http://jena.apache.org/prefixes#>\n       PREFIX xsd:      <http://www.w3.org/2001/XMLSchema#>\n       PREFIX rdf:      <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n       INSERT DATA {\n           [] rdf:type prefixes:Prefix ;\n               prefixes:prefixName ?prefixName ;\n               prefixes:prefixURI ?newURI\n       }\n");
                pssUpdate.setLiteral("prefixName", prefix);
                pssUpdate.setLiteral("newURI", uri, (RDFDatatype)XSDDatatype.XSDanyURI);
                update2 = pssUpdate.toString();
            }
            UpdateExec.dataset(this.dataset).update(update2).execute();
        });
    }

    @Override
    public void removePrefix(String prefixToRemove) {
        ParameterizedSparqlString pss = new ParameterizedSparqlString("PREFIX prefixes: <http://jena.apache.org/prefixes#>\nDELETE WHERE { ?X prefixes:prefixName ?prefixName }\n");
        pss.setLiteral("prefixName", prefixToRemove);
        String update2 = pss.toString();
        this.dataset.executeWrite(() -> UpdateExec.dataset(this.dataset).update(update2).execute());
    }

    @Override
    public Map<String, String> getAll() {
        String query2 = "PREFIX prefixes: <http://jena.apache.org/prefixes#>\nSELECT ?prefixName ?prefixURI WHERE {\n    ?X prefixes:prefixName ?prefixName .\n    ?X prefixes:prefixURI ?prefixURI\n}\n";
        return this.dataset.calculateRead(() -> {
            ConcurrentHashMap allPairs = new ConcurrentHashMap();
            try (QueryExec qExec = QueryExec.dataset(this.dataset).query(query2).build();){
                RowSet rowSet = qExec.select();
                rowSet.forEachRemaining(row -> {
                    String prefixNameLiteral = row.get("prefixName").getLiteralLexicalForm();
                    String prefixURILiteral = row.get("prefixURI").getLiteralLexicalForm();
                    if (prefixNameLiteral != null && prefixURILiteral != null) {
                        allPairs.put(prefixNameLiteral, prefixURILiteral);
                    }
                });
                ConcurrentHashMap concurrentHashMap = allPairs;
                return concurrentHashMap;
            }
        });
    }

    @Override
    public List<String> fetchPrefix(String uri) {
        ParameterizedSparqlString pss = new ParameterizedSparqlString("PREFIX prefixes: <http://jena.apache.org/prefixes#>\nPREFIX xsd:      <http://www.w3.org/2001/XMLSchema#>\nSELECT ?prefixName WHERE {\n    ?X prefixes:prefixURI ?uriName .\n    ?X prefixes:prefixName ?prefixName\n}\n");
        pss.setLiteral("uriName", uri, (RDFDatatype)XSDDatatype.XSDanyURI);
        String query2 = pss.toString();
        return this.dataset.calculateRead(() -> {
            try (QueryExec qExec = QueryExec.dataset(this.dataset).query(query2).build();){
                RowSet rowSet = qExec.select();
                ArrayList prefixes = new ArrayList();
                rowSet.forEachRemaining(row -> {
                    String prefixNameLiteral = row.get("prefixName").getLiteralLexicalForm();
                    if (prefixNameLiteral != null) {
                        prefixes.add(prefixNameLiteral);
                    }
                });
                ArrayList arrayList = prefixes;
                return arrayList;
            }
        });
    }
}

