/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.dboe.base.block.Block;
import org.apache.jena.dboe.base.file.BlockAccessBase;
import org.apache.jena.dboe.base.file.FileException;
import org.apache.jena.dboe.sys.FileLib;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockAccessDirect
extends BlockAccessBase {
    private static Logger log = LoggerFactory.getLogger(BlockAccessDirect.class);

    public BlockAccessDirect(String filename, int blockSize) {
        super(filename, blockSize);
    }

    @Override
    public Block allocate(int blkSize) {
        if (blkSize > 0 && blkSize != this.blockSize) {
            throw new FileException("Fixed blocksize only: request= " + blkSize + "fixed size=" + this.blockSize);
        }
        int x = this.allocateId();
        ByteBuffer bb = ByteBuffer.allocate(blkSize);
        Block block = new Block(x, bb);
        return block;
    }

    @Override
    public Block read(long id) {
        this.check(id);
        this.checkIfClosed();
        ByteBuffer bb = ByteBuffer.allocate(this.blockSize);
        this.readByteBuffer(id, bb);
        bb.rewind();
        Block block = new Block(id, bb);
        return block;
    }

    private void readByteBuffer(long id, ByteBuffer dst) {
        try {
            int len = this.file.read(dst, this.filePosition(id));
            if (len != this.blockSize) {
                throw new FileException(String.format("get: short read (%d, not %d)", len, this.blockSize));
            }
        }
        catch (IOException ex) {
            throw new FileException("FileAccessDirect", ex);
        }
    }

    private final long filePosition(long id) {
        return id * (long)this.blockSize;
    }

    @Override
    public void write(Block block) {
        this.check(block);
        this.checkIfClosed();
        ByteBuffer bb = block.getByteBuffer();
        bb.limit(bb.capacity());
        bb.rewind();
        try {
            int len = this.file.write(bb, this.filePosition(block.getId()));
            if (len != this.blockSize) {
                throw new FileException(String.format("write: short write (%d, not %d)", len, this.blockSize));
            }
        }
        catch (IOException ex) {
            throw new FileException("FileAccessDirect", ex);
        }
        this.writeNotification(block);
    }

    @Override
    public void overwrite(Block block) {
        this.overwriteNotification(block);
        this.write(block);
    }

    @Override
    protected void _resetAllocBoundary(long boundary) {
        FileLib.truncate(this.file, this.filePosition(boundary));
    }

    @Override
    public void sync() {
        this.force();
    }

    @Override
    protected void _close() {
        super.force();
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    public String toString() {
        return "Direct:" + FileOps.basename(this.filename);
    }
}

