/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.stack.core.util.Unit;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TaskQueue {
    private static final int DEFAULT_MAX_CONCURRENT_TASKS = 1;
    private static final int DEFAULT_PRIORITY_RATIO = 5;
    private static final int DEFAULT_MAX_QUEUE_SIZE = Integer.MAX_VALUE;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int pending = 0;
    private boolean paused = false;
    private boolean shutdown = false;
    private CountDownLatch shutdownLatch;
    private final PrioritizedTaskQueue taskQueue;
    private final Lock taskQueueLock = new ReentrantLock(true);
    private final Executor executor;
    private final int maxConcurrentTasks;
    private final int maxQueueSize;

    public TaskQueue(Executor executor) {
        this(executor, 1, Integer.MAX_VALUE, 5);
    }

    public TaskQueue(Executor executor, int maxConcurrentTasks, int maxQueueSize, int priorityRatio) {
        this.executor = executor;
        this.maxConcurrentTasks = maxConcurrentTasks;
        this.maxQueueSize = maxQueueSize;
        this.taskQueue = new PrioritizedTaskQueue(priorityRatio);
    }

    public boolean execute(Task task) {
        this.taskQueueLock.lock();
        try {
            if (this.shutdown || this.taskQueue.size() >= this.maxQueueSize) {
                boolean bl = false;
                return bl;
            }
            this.taskQueue.add(new TaskWrapper(task));
            this.maybePollAndExecute();
            boolean bl = true;
            return bl;
        }
        finally {
            this.taskQueueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CompletionStage<Unit> submit(Task task) {
        this.taskQueueLock.lock();
        try {
            if (this.shutdown || this.taskQueue.size() >= this.maxQueueSize) {
                CompletionStage<Unit> completionStage = null;
                return completionStage;
            }
            CompletableFuture<Unit> callback = new CompletableFuture<Unit>();
            this.taskQueue.add(new TaskWrapper(task, callback));
            this.maybePollAndExecute();
            CompletableFuture<Unit> completableFuture = callback;
            return completableFuture;
        }
        finally {
            this.taskQueueLock.unlock();
        }
    }

    public void pause() {
        this.taskQueueLock.lock();
        try {
            this.paused = true;
        }
        finally {
            this.taskQueueLock.unlock();
        }
    }

    public void resume() {
        this.taskQueueLock.lock();
        try {
            this.paused = false;
            this.maybePollAndExecute();
        }
        finally {
            this.taskQueueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Task> shutdown(boolean awaitQuiescence) throws InterruptedException {
        block10: {
            this.taskQueueLock.lock();
            try {
                this.shutdown = true;
                if (this.taskQueue.isEmpty() && this.pending == 0) {
                    List<Task> list = Collections.emptyList();
                    return list;
                }
                if (awaitQuiescence) {
                    this.shutdownLatch = new CountDownLatch(this.pending);
                    break block10;
                }
                List<Task> tasks = this.taskQueue.getTasks().stream().map(tw -> ((TaskWrapper)tw).task).collect(Collectors.toList());
                this.taskQueue.clear();
                List<Task> list = tasks;
                return list;
            }
            finally {
                this.taskQueueLock.unlock();
            }
        }
        assert (this.shutdownLatch != null);
        this.shutdownLatch.await();
        this.taskQueueLock.lock();
        try {
            List<Task> tasks = this.taskQueue.getTasks().stream().map(tw -> ((TaskWrapper)tw).task).collect(Collectors.toList());
            this.taskQueue.clear();
            List<Task> list = tasks;
            return list;
        }
        finally {
            this.taskQueueLock.unlock();
        }
    }

    public boolean isShutdown() {
        this.taskQueueLock.lock();
        try {
            boolean bl = this.shutdown;
            return bl;
        }
        finally {
            this.taskQueueLock.unlock();
        }
    }

    private void maybePollAndExecute() {
        this.taskQueueLock.lock();
        try {
            if (!(this.pending >= this.maxConcurrentTasks || this.paused || this.shutdown || this.taskQueue.isEmpty())) {
                this.executor.execute(Objects.requireNonNull(this.taskQueue.poll()));
                ++this.pending;
            }
        }
        finally {
            this.taskQueueLock.unlock();
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private static final class PrioritizedTaskQueue {
        private final ArrayDeque<TaskWrapper> regular = new ArrayDeque();
        private final ArrayDeque<TaskWrapper> elevated = new ArrayDeque();
        private final ArrayDeque<TaskWrapper> critical = new ArrayDeque();
        private int consecutiveElevatedExecutions = 0;
        private final int priorityRatio;

        private PrioritizedTaskQueue(int priorityRatio) {
            this.priorityRatio = priorityRatio;
        }

        void add(TaskWrapper task) {
            switch (task.task.getPriority()) {
                case REGULAR: {
                    this.regular.add(task);
                    break;
                }
                case ELEVATED: {
                    this.elevated.add(task);
                    break;
                }
                case CRITICAL: {
                    this.critical.add(task);
                    break;
                }
                default: {
                    throw new RuntimeException("priority: " + (Object)((Object)task.task.getPriority()));
                }
            }
        }

        boolean isEmpty() {
            return this.regular.isEmpty() && this.elevated.isEmpty() && this.critical.isEmpty();
        }

        TaskWrapper poll() {
            if (!this.critical.isEmpty()) {
                return this.critical.poll();
            }
            if (this.consecutiveElevatedExecutions >= this.priorityRatio) {
                if (!this.regular.isEmpty()) {
                    this.consecutiveElevatedExecutions = 0;
                    return this.regular.poll();
                }
                if (!this.elevated.isEmpty()) {
                    ++this.consecutiveElevatedExecutions;
                    return this.elevated.poll();
                }
                return null;
            }
            if (!this.elevated.isEmpty()) {
                ++this.consecutiveElevatedExecutions;
                return this.elevated.poll();
            }
            if (!this.regular.isEmpty()) {
                this.consecutiveElevatedExecutions = 0;
                return this.regular.poll();
            }
            return null;
        }

        List<TaskWrapper> getTasks() {
            ArrayList<TaskWrapper> tasks = new ArrayList<TaskWrapper>();
            tasks.addAll(this.critical);
            tasks.addAll(this.elevated);
            tasks.addAll(this.regular);
            return tasks;
        }

        void clear() {
            this.critical.clear();
            this.elevated.clear();
            this.regular.clear();
        }

        int size() {
            return this.critical.size() + this.elevated.size() + this.regular.size();
        }
    }

    public static final class Builder {
        private Executor executor;
        private int maxConcurrentTasks = 1;
        private int maxQueueSize = Integer.MAX_VALUE;
        private int priorityRatio = 5;

        public Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder setMaxConcurrentTasks(int maxConcurrentTasks) {
            this.maxConcurrentTasks = maxConcurrentTasks;
            return this;
        }

        public Builder setMaxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public Builder setPriorityRatio(int priorityRatio) {
            this.priorityRatio = priorityRatio;
            return this;
        }

        public TaskQueue build() {
            if (this.executor == null) {
                throw new NullPointerException("executor must be non-null");
            }
            this.maxConcurrentTasks = Math.max(1, this.maxConcurrentTasks);
            this.maxQueueSize = Math.max(1, this.maxQueueSize);
            this.priorityRatio = Math.max(1, this.priorityRatio);
            return new TaskQueue(this.executor, this.maxConcurrentTasks, this.maxQueueSize, this.priorityRatio);
        }
    }

    public static enum TaskPriority {
        REGULAR,
        ELEVATED,
        CRITICAL;

    }

    public static interface Task {
        public void execute();

        default public TaskPriority getPriority() {
            return TaskPriority.REGULAR;
        }
    }

    private class TaskWrapper
    implements Runnable {
        private final Task task;
        private final CompletableFuture<Unit> callback;

        private TaskWrapper(Task task) {
            this(task, (CompletableFuture<Unit>)null);
        }

        private TaskWrapper(Task task, CompletableFuture<Unit> callback) {
            this.task = task;
            this.callback = callback;
        }

        @Override
        public void run() {
            try {
                this.task.execute();
                if (this.callback != null) {
                    TaskQueue.this.executor.execute(() -> this.callback.complete(Unit.VALUE));
                }
            }
            catch (Throwable throwable) {
                TaskQueue.this.logger.warn("Uncaught Throwable during Task execution.", throwable);
            }
            TaskWrapper inlineTask = null;
            TaskQueue.this.taskQueueLock.lock();
            try {
                if (TaskQueue.this.taskQueue.isEmpty() || TaskQueue.this.paused || TaskQueue.this.shutdown) {
                    TaskQueue.this.pending--;
                    if (TaskQueue.this.shutdown && TaskQueue.this.shutdownLatch != null) {
                        TaskQueue.this.shutdownLatch.countDown();
                    }
                } else {
                    inlineTask = TaskQueue.this.taskQueue.poll();
                }
            }
            finally {
                TaskQueue.this.taskQueueLock.unlock();
            }
            if (inlineTask != null) {
                try {
                    inlineTask.task.execute();
                    if (inlineTask.callback != null) {
                        CompletableFuture<Unit> callback = inlineTask.callback;
                        TaskQueue.this.executor.execute(() -> callback.complete(Unit.VALUE));
                    }
                }
                catch (Throwable throwable) {
                    TaskQueue.this.logger.warn("Uncaught Throwable during Task execution.", throwable);
                }
                TaskQueue.this.taskQueueLock.lock();
                try {
                    if (TaskQueue.this.taskQueue.isEmpty() || TaskQueue.this.paused || TaskQueue.this.shutdown) {
                        TaskQueue.this.pending--;
                        if (TaskQueue.this.shutdown && TaskQueue.this.shutdownLatch != null) {
                            TaskQueue.this.shutdownLatch.countDown();
                        }
                    } else {
                        TaskQueue.this.executor.execute(Objects.requireNonNull(TaskQueue.this.taskQueue.poll()));
                    }
                }
                finally {
                    TaskQueue.this.taskQueueLock.unlock();
                }
            }
        }
    }
}

