/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.expression.impl;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.tsfile.read.expression.ExpressionType;
import org.apache.tsfile.read.expression.IBinaryExpression;
import org.apache.tsfile.read.expression.IExpression;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public abstract class BinaryExpression
implements IBinaryExpression,
Serializable {
    private static final long serialVersionUID = -711801318534904452L;

    public static AndExpression and(IExpression left, IExpression right) {
        return new AndExpression(left, right);
    }

    public static OrExpression or(IExpression left, IExpression right) {
        return new OrExpression(left, right);
    }

    @Override
    public abstract IExpression clone();

    protected static class AndExpression
    extends BinaryExpression {
        private IExpression left;
        private IExpression right;

        public AndExpression(IExpression left, IExpression right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public IExpression getLeft() {
            return this.left;
        }

        @Override
        public IExpression getRight() {
            return this.right;
        }

        @Override
        public void setLeft(IExpression leftExpression) {
            this.left = leftExpression;
        }

        @Override
        public void setRight(IExpression rightExpression) {
            this.right = rightExpression;
        }

        @Override
        public ExpressionType getType() {
            return ExpressionType.AND;
        }

        @Override
        public IExpression clone() {
            return new AndExpression(this.left.clone(), this.right.clone());
        }

        @Override
        public void serialize(ByteBuffer byteBuffer) {
            ReadWriteIOUtils.write((byte)this.getType().ordinal(), byteBuffer);
            this.left.serialize(byteBuffer);
            this.right.serialize(byteBuffer);
        }

        public String toString() {
            return "[" + this.left + " && " + this.right + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AndExpression that = (AndExpression)o;
            return Objects.equals(this.toString(), that.toString());
        }

        public int hashCode() {
            return Objects.hash(this.toString());
        }
    }

    protected static class OrExpression
    extends BinaryExpression {
        private IExpression left;
        private IExpression right;

        public OrExpression(IExpression left, IExpression right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public IExpression getLeft() {
            return this.left;
        }

        @Override
        public IExpression getRight() {
            return this.right;
        }

        @Override
        public void setLeft(IExpression leftExpression) {
            this.left = leftExpression;
        }

        @Override
        public void setRight(IExpression rightExpression) {
            this.right = rightExpression;
        }

        @Override
        public ExpressionType getType() {
            return ExpressionType.OR;
        }

        @Override
        public IExpression clone() {
            return new OrExpression(this.left.clone(), this.right.clone());
        }

        @Override
        public void serialize(ByteBuffer byteBuffer) {
            ReadWriteIOUtils.write((byte)this.getType().ordinal(), byteBuffer);
            this.left.serialize(byteBuffer);
            this.right.serialize(byteBuffer);
        }

        public String toString() {
            return "[" + this.left + " || " + this.right + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OrExpression that = (OrExpression)o;
            return Objects.equals(this.toString(), that.toString());
        }

        public int hashCode() {
            return Objects.hash(this.toString());
        }
    }
}

