/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.provider;

import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.common.fieldtype.strategy.FieldTypeMappingStrategy;
import org.apache.inlong.manager.common.fieldtype.strategy.FieldTypeStrategyFactory;
import org.apache.inlong.manager.pojo.sink.sqlserver.SQLServerSink;
import org.apache.inlong.manager.pojo.sort.node.base.ExtractNodeProvider;
import org.apache.inlong.manager.pojo.sort.node.base.LoadNodeProvider;
import org.apache.inlong.manager.pojo.source.sqlserver.SQLServerSource;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.ExtractNode;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.extract.SqlServerExtractNode;
import org.apache.inlong.sort.protocol.node.load.SqlServerLoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SQLServerProvider
implements ExtractNodeProvider,
LoadNodeProvider {
    @Autowired
    private FieldTypeStrategyFactory fieldTypeStrategyFactory;

    @Override
    public Boolean accept(String streamType) {
        return "SQLSERVER".equals(streamType);
    }

    @Override
    public ExtractNode createExtractNode(StreamNode streamNodeInfo) {
        SQLServerSource source = (SQLServerSource)streamNodeInfo;
        FieldTypeMappingStrategy fieldTypeMappingStrategy = this.fieldTypeStrategyFactory.getInstance(source.getSourceType());
        List<FieldInfo> fieldInfos = this.parseStreamFieldInfos(source.getFieldList(), source.getSourceName(), fieldTypeMappingStrategy);
        Map<String, String> properties = this.parseProperties(source.getProperties());
        return new SqlServerExtractNode(source.getSourceName(), source.getSourceName(), fieldInfos, null, properties, source.getPrimaryKey(), source.getHostname(), source.getPort(), source.getUsername(), source.getPassword(), source.getDatabase(), source.getSchemaName(), source.getTableName(), source.getServerTimezone());
    }

    @Override
    public LoadNode createLoadNode(StreamNode nodeInfo, Map<String, StreamField> constantFieldMap) {
        SQLServerSink sqlServerSink = (SQLServerSink)nodeInfo;
        Map<String, String> properties = this.parseProperties(sqlServerSink.getProperties());
        FieldTypeMappingStrategy fieldTypeMappingStrategy = this.fieldTypeStrategyFactory.getInstance(sqlServerSink.getSinkType());
        List<FieldInfo> fieldInfos = this.parseSinkFieldInfos(sqlServerSink.getSinkFieldList(), sqlServerSink.getSinkName(), fieldTypeMappingStrategy);
        List<FieldRelation> fieldRelations = this.parseSinkFields(sqlServerSink.getSinkFieldList(), constantFieldMap);
        return new SqlServerLoadNode(sqlServerSink.getSinkName(), sqlServerSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, sqlServerSink.getJdbcUrl(), sqlServerSink.getUsername(), sqlServerSink.getPassword(), sqlServerSink.getSchemaName(), sqlServerSink.getTableName(), sqlServerSink.getPrimaryKey());
    }
}

