/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.metric;

import org.apache.inlong.tubemq.corebase.metric.impl.LongStatsCounter;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;

public class TrafficStatsUnit {
    private String trafficName;
    public LongStatsCounter msgCnt;
    public LongStatsCounter msgSize;

    public TrafficStatsUnit(String msgCntName, String msgSizeName, String prefix) {
        this.trafficName = prefix;
        this.msgCnt = new LongStatsCounter(msgCntName, prefix);
        this.msgSize = new LongStatsCounter(msgSizeName, prefix);
    }

    public void addMsgCntAndSize(long msgCount, long msgSize) {
        this.msgCnt.addValue(msgCount);
        this.msgSize.addValue(msgSize);
    }

    public void getValue(StringBuilder strBuff, boolean resetValue) {
        if (!TStringUtils.isEmpty(this.trafficName)) {
            strBuff.append("\"").append(this.trafficName).append("\":");
        }
        if (resetValue) {
            strBuff.append("{\"").append(this.msgCnt.getShortName()).append("\":").append(this.msgCnt.getAndResetValue()).append(",\"").append(this.msgSize.getShortName()).append("\":").append(this.msgSize.getAndResetValue()).append("}");
        } else {
            strBuff.append("{\"").append(this.msgCnt.getShortName()).append("\":").append(this.msgCnt.getValue()).append(",\"").append(this.msgSize.getShortName()).append("\":").append(this.msgSize.getValue()).append("}");
        }
    }
}

