/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.plugin.task.logcollection;

import java.text.ParseException;
import java.util.List;
import org.apache.inlong.agent.conf.TaskProfile;
import org.apache.inlong.agent.plugin.task.logcollection.LogAbstractTask;
import org.apache.inlong.agent.plugin.utils.regex.Scanner;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.DateTransUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLTask
extends LogAbstractTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLTask.class);
    private String originPattern;
    private long lastScanTime = 0L;
    public final long SCAN_INTERVAL = 60000L;

    @Override
    protected int getInstanceLimit() {
        return this.taskProfile.getInt("task.sqlTask.maxInstanceCount");
    }

    @Override
    protected void initTask() {
        super.initTask();
        this.timeOffset = this.taskProfile.get("task.sqlTask.timeOffset", "");
        this.retry = this.taskProfile.getBoolean("task.sqlTask.retry", false);
        this.originPattern = this.taskProfile.get("task.sqlTask.sql");
        if (this.retry) {
            this.initRetryTask(this.taskProfile);
        }
    }

    private boolean initRetryTask(TaskProfile profile) {
        String dataTimeFrom = profile.get("task.sqlTask.dataTimeFrom", "");
        String dataTimeTo = profile.get("task.sqlTask.dataTimeTo", "");
        try {
            this.startTime = DateTransUtils.timeStrConvertToMillSec((String)dataTimeFrom, (String)profile.getCycleUnit());
            this.endTime = DateTransUtils.timeStrConvertToMillSec((String)dataTimeTo, (String)profile.getCycleUnit());
        }
        catch (ParseException e) {
            LOGGER.error("retry task time error start {} end {}", new Object[]{dataTimeFrom, dataTimeTo, e});
            return false;
        }
        return true;
    }

    public boolean isProfileValid(TaskProfile profile) {
        boolean ret;
        if (!profile.allRequiredKeyExist()) {
            LOGGER.error("task profile needs all required key");
            return false;
        }
        if (!profile.hasKey("task.sqlTask.cycleUnit")) {
            LOGGER.error("task profile needs sql cycle unit");
            return false;
        }
        if (!profile.hasKey("task.cycleUnit")) {
            LOGGER.error("task profile needs cycle unit");
            return false;
        }
        if (profile.get("task.cycleUnit").compareTo(profile.get("task.sqlTask.cycleUnit")) != 0) {
            LOGGER.error("task profile cycle unit must be consistent");
            return false;
        }
        if (!profile.hasKey("task.timeZone")) {
            LOGGER.error("task profile needs time zone");
            return false;
        }
        boolean bl = ret = profile.hasKey("task.sqlTask.sql") && profile.hasKey("task.sqlTask.maxInstanceCount");
        if (!ret) {
            LOGGER.error("task profile needs file keys");
            return false;
        }
        if (!profile.hasKey("task.sqlTask.timeOffset")) {
            LOGGER.error("task profile needs time offset");
            return false;
        }
        return !profile.getBoolean("task.sqlTask.retry", false) || this.initRetryTask(profile);
    }

    @Override
    protected void releaseTask() {
    }

    @Override
    protected void runForNormal() {
        if (AgentUtils.getCurrentTime() - this.lastScanTime > 60000L) {
            this.scanExistingFile();
            this.lastScanTime = AgentUtils.getCurrentTime();
        }
        this.dealWithEventMap();
    }

    @Override
    protected void scanExistingFile() {
        List<Scanner.FinalPatternInfo> finalPatternInfos = Scanner.getFinalPatternInfos(this.originPattern, this.taskProfile.getCycleUnit(), this.timeOffset, this.startTime, this.endTime, this.retry);
        LOGGER.info("taskId {} scan {} get file count {}", new Object[]{this.getTaskId(), this.originPattern, finalPatternInfos.size()});
        finalPatternInfos.forEach(fileInfo -> {
            String dataTime = DateTransUtils.millSecConvertToTimeStr((long)fileInfo.dataTime, (String)this.taskProfile.getCycleUnit());
            this.addToEvenMap(fileInfo.finalPattern, dataTime, 0L, this.taskProfile.getCycleUnit());
            if (this.retry) {
                ++this.instanceCount;
            }
        });
    }

    @Override
    protected void dealWithEventMap() {
        this.removeTimeoutEvent(this.eventMap, this.retry);
        this.dealWithEventMapWithCycle();
    }
}

