/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.queue.pulsar;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class QueryCountDownLatch {
    private CountDownLatch dataLatch;
    private CountDownLatch taskLatch;
    private CountDownLatch flagLatch;

    public QueryCountDownLatch(int dataSize, int taskSize) {
        this.dataLatch = new CountDownLatch(dataSize);
        this.taskLatch = new CountDownLatch(taskSize);
        this.flagLatch = new CountDownLatch(1);
    }

    public void countDown(int dataDownSize) {
        this.taskLatch.countDown();
        for (int i = 0; i < dataDownSize; ++i) {
            this.dataLatch.countDown();
        }
        if (this.taskLatch.getCount() == 0L || this.dataLatch.getCount() == 0L) {
            this.flagLatch.countDown();
        }
    }

    public void await() throws InterruptedException {
        this.flagLatch.await();
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.flagLatch.await(timeout, unit);
    }
}

