/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.audit.file;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.inlong.audit.file.ConfigHolder;
import org.apache.inlong.audit.file.RemoteConfigJson;
import org.apache.inlong.audit.file.holder.PropertiesConfigHolder;
import org.apache.inlong.common.pojo.audit.AuditConfigRequest;
import org.apache.inlong.common.pojo.audit.MQInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManager {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigManager.class);
    private static final Map<String, ConfigHolder> holderMap = new ConcurrentHashMap<String, ConfigHolder>();
    public static List<MQInfo> mqInfoList = new ArrayList<MQInfo>();
    private static ConfigManager instance = null;
    private static String DEFAULT_CONFIG_PROPERTIES = "application.properties";

    public static ConfigManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigManager getInstance(String fileName, boolean needToCheckChanged) {
        Class<ConfigManager> clazz = ConfigManager.class;
        synchronized (ConfigManager.class) {
            ConfigHolder holder;
            if (instance == null) {
                instance = new ConfigManager();
            }
            if ((holder = holderMap.get(fileName)) == null) {
                holder = new PropertiesConfigHolder(fileName, needToCheckChanged);
                holder.loadFromFileToHolder();
                holderMap.putIfAbsent(fileName, holder);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    public Map<String, String> getProperties(String fileName) {
        ConfigHolder holder = holderMap.get(fileName);
        if (holder != null) {
            return holder.getHolder();
        }
        return null;
    }

    public <T> T getValue(String key, T defaultValue, Function<String, T> parser) {
        ConfigHolder holder = holderMap.get(DEFAULT_CONFIG_PROPERTIES);
        if (holder == null) {
            return defaultValue;
        }
        String value = holder.getHolder().get(key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return parser.apply(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String getValue(String key, String defaultValue) {
        return this.getValue(key, defaultValue, Function.identity());
    }

    public int getValue(String key, int defaultValue) {
        return this.getValue(key, defaultValue, Integer::parseInt);
    }

    private boolean updatePropertiesHolder(Map<String, String> result, String holderName, boolean addElseRemove) {
        if (StringUtils.isNotEmpty((CharSequence)holderName)) {
            PropertiesConfigHolder holder = (PropertiesConfigHolder)holderMap.get(holderName + ".properties");
            return this.updatePropertiesHolder(result, holder, true);
        }
        return true;
    }

    private boolean updatePropertiesHolder(Map<String, String> result, PropertiesConfigHolder holder, boolean addElseRemove) {
        Map<String, String> tmpHolder = holder.forkHolder();
        boolean changed = false;
        for (Map.Entry<String, String> entry : result.entrySet()) {
            String oldValue;
            String string = oldValue = addElseRemove ? tmpHolder.put(entry.getKey(), entry.getValue()) : tmpHolder.remove(entry.getKey());
            if (oldValue != null && oldValue.equals(entry.getValue()) && addElseRemove) continue;
            changed = true;
        }
        if (changed) {
            return holder.loadFromHolderToFile(tmpHolder);
        }
        return false;
    }

    public List<MQInfo> getMqInfoList() {
        return mqInfoList;
    }

    public ConfigHolder getDefaultConfigHolder() {
        return holderMap.get(DEFAULT_CONFIG_PROPERTIES);
    }

    public ConfigHolder getConfigHolder(String fileName) {
        return holderMap.get(fileName);
    }

    static {
        instance = ConfigManager.getInstance(DEFAULT_CONFIG_PROPERTIES, true);
        ReloadConfigWorker reloadProperties = new ReloadConfigWorker(instance);
        reloadProperties.setDaemon(true);
        reloadProperties.start();
    }

    private static class ReloadConfigWorker
    extends Thread {
        private static final Logger LOG = LoggerFactory.getLogger(ReloadConfigWorker.class);
        private final ConfigManager configManager;
        private final CloseableHttpClient httpClient;
        private final Gson gson = new Gson();
        private boolean isRunning = true;

        public ReloadConfigWorker(ConfigManager managerInstance) {
            this.configManager = managerInstance;
            this.httpClient = this.constructHttpClient();
        }

        private synchronized CloseableHttpClient constructHttpClient() {
            long timeoutInMs = TimeUnit.MILLISECONDS.toMillis(50000L);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout((int)timeoutInMs).setSocketTimeout((int)timeoutInMs).build();
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            httpClientBuilder.setDefaultRequestConfig(requestConfig);
            return httpClientBuilder.build();
        }

        public int getRandom(int min, int max) {
            return (int)(Math.random() * (double)(max + 1 - min)) + min;
        }

        private long getSleepTime() {
            String sleepTimeInMsStr = this.configManager.getProperties(DEFAULT_CONFIG_PROPERTIES).get("configCheckIntervalMs");
            long sleepTimeInMs = 10000L;
            try {
                if (sleepTimeInMsStr != null) {
                    sleepTimeInMs = Long.parseLong(sleepTimeInMsStr);
                }
            }
            catch (Exception ignored) {
                LOG.info("ignored Exception ", (Throwable)ignored);
            }
            return sleepTimeInMs + (long)this.getRandom(0, 5000);
        }

        public void close() {
            this.isRunning = false;
        }

        private void checkLocalFile() {
            for (ConfigHolder holder : holderMap.values()) {
                boolean isChanged = holder.checkAndUpdateHolder();
                if (!isChanged) continue;
                holder.executeCallbacks();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean checkWithManager(String host, String clusterTag) {
            HttpPost httpPost = null;
            try {
                String url = "http://" + host + "/inlong/manager/openapi" + "/audit/getConfig";
                LOG.info("start to request {} to get config info", (Object)url);
                httpPost = new HttpPost(url);
                httpPost.addHeader("Connection", "close");
                AuditConfigRequest request = new AuditConfigRequest();
                request.setClusterTag(clusterTag);
                StringEntity stringEntity = new StringEntity(this.gson.toJson((Object)request));
                stringEntity.setContentType("application/json");
                httpPost.setEntity((HttpEntity)stringEntity);
                LOG.info("start to request {} to get config info with params {}", (Object)url, (Object)request);
                CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
                String returnStr = EntityUtils.toString((HttpEntity)response.getEntity());
                RemoteConfigJson configJson = (RemoteConfigJson)this.gson.fromJson(returnStr, RemoteConfigJson.class);
                if (configJson.isSuccess() && configJson.getData() != null && ((mqInfoList = configJson.getData().getMqInfoList()) == null || mqInfoList.isEmpty())) {
                    LOG.error("getConfig from manager: no available mq config");
                    boolean bl = false;
                    return bl;
                }
            }
            catch (Exception ex) {
                LOG.error("exception caught", (Throwable)ex);
                boolean bl = false;
                return bl;
            }
            finally {
                if (httpPost != null) {
                    httpPost.releaseConnection();
                }
            }
            return true;
        }

        private void checkRemoteConfig() {
            try {
                String[] hostList;
                String managerHosts = this.configManager.getProperties(DEFAULT_CONFIG_PROPERTIES).get("manager.hosts");
                String proxyClusterTag = this.configManager.getProperties(DEFAULT_CONFIG_PROPERTIES).get("default.mq.cluster.tag");
                LOG.info("manager url: {}", (Object)managerHosts);
                for (String host : hostList = StringUtils.split((String)managerHosts, (String)",")) {
                    if (this.checkWithManager(host, proxyClusterTag)) break;
                }
            }
            catch (Exception ex) {
                LOG.error("exception caught", (Throwable)ex);
            }
        }

        @Override
        public void run() {
            long count = 0L;
            while (this.isRunning) {
                long sleepTimeInMs = this.getSleepTime();
                try {
                    this.checkLocalFile();
                    if (count % 3L == 0L) {
                        this.checkRemoteConfig();
                        count = 0L;
                    }
                    TimeUnit.MILLISECONDS.sleep(sleepTimeInMs);
                }
                catch (Exception ex) {
                    LOG.error("exception caught", (Throwable)ex);
                }
                ++count;
            }
        }
    }
}

