/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core.task;

import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.inlong.agent.common.AbstractDaemon;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.InstanceProfile;
import org.apache.inlong.agent.conf.OffsetProfile;
import org.apache.inlong.agent.conf.TaskProfile;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.store.InstanceStore;
import org.apache.inlong.agent.store.OffsetStore;
import org.apache.inlong.agent.store.Store;
import org.apache.inlong.agent.store.TaskStore;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.DateTransUtils;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.apache.inlong.common.enums.InstanceStateEnum;
import org.apache.inlong.common.enums.TaskStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetManager
extends AbstractDaemon {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffsetManager.class);
    public static final int CORE_THREAD_SLEEP_TIME = 60000;
    public static final int CLEAN_INSTANCE_ONCE_LIMIT = 1000;
    public static final long SEVEN_DAY_TIMEOUT_INTERVAL_MS = 604800000L;
    private static volatile OffsetManager offsetManager = null;
    private final OffsetStore offsetStore;
    private final InstanceStore instanceStore;
    private final TaskStore taskStore;

    private OffsetManager(Store taskBasicStore, Store instanceBasicStore, Store offsetBasicStore) {
        this.taskStore = new TaskStore(taskBasicStore);
        this.instanceStore = new InstanceStore(instanceBasicStore);
        this.offsetStore = new OffsetStore(offsetBasicStore);
    }

    private Runnable coreThread() {
        return () -> {
            Thread.currentThread().setName("offset-manager-core");
            while (this.isRunnable()) {
                try {
                    AgentUtils.silenceSleepInMs((long)60000L);
                    this.cleanDbInstance();
                    this.cleanDbOffset();
                }
                catch (Throwable ex) {
                    LOGGER.error("offset-manager-core: ", ex);
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void init(Store taskBasicStore, Store instanceBasicStore, Store offsetBasicStore) {
        if (offsetManager != null) return;
        Class<OffsetManager> clazz = OffsetManager.class;
        synchronized (OffsetManager.class) {
            if (offsetManager != null) return;
            offsetManager = new OffsetManager(taskBasicStore, instanceBasicStore, offsetBasicStore);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static OffsetManager getInstance() {
        return offsetManager;
    }

    public void setOffset(OffsetProfile profile) {
        this.offsetStore.setOffset(profile);
    }

    public void deleteOffset(String taskId, String instanceId) {
        this.offsetStore.deleteOffset(taskId, instanceId);
    }

    public OffsetProfile getOffset(String taskId, String instanceId) {
        return this.offsetStore.getOffset(taskId, instanceId);
    }

    private void cleanDbOffset() {
        List offsets = this.offsetStore.listAllOffsets();
        offsets.forEach(offset -> {
            String instanceId;
            String taskId = offset.getTaskId();
            InstanceProfile instanceProfile = this.instanceStore.getInstance(taskId, instanceId = offset.getInstanceId());
            if (instanceProfile == null) {
                this.deleteOffset(taskId, instanceId);
                LOGGER.info("instance not found, delete offset taskId {} instanceId {}", (Object)taskId, (Object)instanceId);
            }
        });
        LOGGER.info("offsetManager running! offsets count {}", (Object)offsets.size());
    }

    private void cleanDbInstance() {
        AtomicInteger cleanCount = new AtomicInteger();
        ListIterator iterator = this.instanceStore.listAllInstances().listIterator();
        while (iterator.hasNext()) {
            if (cleanCount.get() > 1000) {
                return;
            }
            InstanceProfile instanceFromDb = (InstanceProfile)iterator.next();
            String taskId = instanceFromDb.getTaskId();
            String instanceId = instanceFromDb.getInstanceId();
            TaskProfile taskFromDb = this.taskStore.getTask(taskId);
            if (taskFromDb != null && (taskFromDb.getCycleUnit().compareToIgnoreCase("R") == 0 || (taskFromDb.isRetry() ? taskFromDb.getState() != TaskStateEnum.RETRY_FINISH : instanceFromDb.getState() != InstanceStateEnum.FINISHED))) continue;
            long expireTime = Math.abs(OffsetManager.getScanCycleRange(instanceFromDb.getCycleUnit())) + AgentConfiguration.getAgentConf().getLong("agent.offset.ttl", 604800000L);
            if (AgentUtils.getCurrentTime() - instanceFromDb.getModifyTime() <= expireTime) continue;
            cleanCount.getAndIncrement();
            LOGGER.info("instance has expired, delete from instance store dataTime {} taskId {} instanceId {}", new Object[]{instanceFromDb.getSourceDataTime(), taskId, instanceId});
            this.instanceStore.deleteInstance(taskId, instanceId);
            AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_DEL_INSTANCE_DB, (String)instanceFromDb.getInlongGroupId(), (String)instanceFromDb.getInlongStreamId(), (long)instanceFromDb.getSinkDataTime(), (int)1, (long)1L, (long)Long.parseLong(instanceFromDb.get("task.auditVersion")));
            iterator.remove();
        }
    }

    public int getRunningInstanceCount() {
        return this.instanceStore.getRunningInstanceCount();
    }

    public void start() throws Exception {
        this.submitWorker(this.coreThread());
    }

    public void stop() throws Exception {
    }

    public static long getScanCycleRange(String cycleUnit) {
        if (AgentConfiguration.getAgentConf().hasKey("agent.scan.range")) {
            String range = AgentConfiguration.getAgentConf().get("agent.scan.range");
            return DateTransUtils.calcOffset((String)(range + cycleUnit));
        }
        switch (cycleUnit) {
            case "D": {
                return DateTransUtils.calcOffset((String)("-2" + cycleUnit));
            }
            case "H": 
            case "h": {
                return DateTransUtils.calcOffset((String)("-2" + cycleUnit));
            }
            case "m": {
                return DateTransUtils.calcOffset((String)("-120" + cycleUnit));
            }
        }
        return DateTransUtils.calcOffset((String)("-2" + cycleUnit));
    }
}

