/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.retry;

import com.qcloud.cos.http.CosHttpRequest;
import com.qcloud.cos.internal.CosServiceRequest;
import com.qcloud.cos.retry.RetryPolicy;
import com.qcloud.cos.retry.RetryUtils;
import java.io.IOException;
import org.apache.http.HttpResponse;

public class PredefinedRetryPolicies {
    public static final RetryPolicy NO_RETRY_POLICY = new RetryPolicy(){

        @Override
        public <X extends CosServiceRequest> boolean shouldRetry(CosHttpRequest<X> request, HttpResponse response, Exception exception, int retryIndex) {
            return false;
        }
    };
    public static final RetryPolicy DEFAULT = PredefinedRetryPolicies.getDefaultRetryPolicy();

    public static RetryPolicy getDefaultRetryPolicy() {
        return new SdkDefaultRetryPolicy();
    }

    public static class SdkDefaultRetryPolicy
    extends RetryPolicy {
        @Override
        public <X extends CosServiceRequest> boolean shouldRetry(CosHttpRequest<X> request, HttpResponse response, Exception exception, int retryIndex) {
            if (RetryUtils.isRetryableServiceException(exception)) {
                return true;
            }
            return exception.getCause() instanceof IOException;
        }
    }
}

