/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.sdk.transform.process.function.string;

import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import org.apache.inlong.sdk.transform.decode.SourceData;
import org.apache.inlong.sdk.transform.process.Context;
import org.apache.inlong.sdk.transform.process.function.TransformFunction;
import org.apache.inlong.sdk.transform.process.operator.OperatorTools;
import org.apache.inlong.sdk.transform.process.parser.ValueParser;

@TransformFunction(type="string", names={"rtrim"}, parameter="(String str)", descriptions={"- Return \"\" if 'str' is NULL;", "- Return the string 'str' with trailing space characters removed."}, examples={"rtrim(' in long ') = \" in long\""})
public class RtrimFunction
implements ValueParser {
    private ValueParser stringParser;

    public RtrimFunction(Function expr) {
        this.stringParser = OperatorTools.buildParser((Expression)expr.getParameters().getExpressions().get(0));
    }

    @Override
    public Object parse(SourceData sourceData, int rowIndex, Context context) {
        Object stringObj = this.stringParser.parse(sourceData, rowIndex, context);
        if (stringObj == null) {
            return null;
        }
        String str = OperatorTools.parseString(stringObj);
        int len = str.length();
        for (int i = len - 1; i >= 0; --i) {
            if (str.charAt(i) == ' ') continue;
            return str.substring(0, i + 1);
        }
        return "";
    }
}

