/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MQTTMessageHandler
extends ChannelDuplexHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MQTTMessageHandler.class);
    private static final int DEFAULT_FLUSH_AFTER_FLUSHES = 128;
    private final int explicitFlushAfterFlushes;
    private final Runnable flushTask;
    protected ChannelHandlerContext ctx;
    private int flushPendingCount;
    private Future<?> nextScheduledFlush;

    protected MQTTMessageHandler() {
        this(128);
    }

    protected MQTTMessageHandler(int explicitFlushAfterFlushes) {
        this.explicitFlushAfterFlushes = explicitFlushAfterFlushes;
        this.flushTask = () -> {
            if (this.flushPendingCount > 0) {
                this.flushPendingCount = 0;
                this.nextScheduledFlush = null;
                this.ctx.flush();
            }
        };
    }

    public void handlerAdded(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.flushIfNeeded(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.flushIfNeeded(ctx);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.flushIfNeeded(ctx);
        ctx.disconnect(promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.flushIfNeeded(ctx);
        ctx.close(promise);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        if (!ctx.channel().isWritable()) {
            this.flushIfNeeded(ctx);
        }
        ctx.fireChannelWritabilityChanged();
    }

    protected ChannelFuture write(Object msg) {
        return this.ctx.write(msg);
    }

    protected ChannelFuture writeAndFlush(Object msg) {
        ChannelFuture future = this.ctx.write(msg);
        this.flush(false);
        return future;
    }

    protected void flush(boolean immediately) {
        if (++this.flushPendingCount == this.explicitFlushAfterFlushes || immediately) {
            this.flushNow(this.ctx);
        } else {
            this.scheduleFlush(this.ctx);
        }
    }

    private void flushIfNeeded(ChannelHandlerContext ctx) {
        if (this.flushPendingCount > 0) {
            this.flushNow(ctx);
        }
    }

    private void flushNow(ChannelHandlerContext ctx) {
        this.cancelScheduledFlush();
        this.flushPendingCount = 0;
        ctx.flush();
    }

    private void scheduleFlush(ChannelHandlerContext ctx) {
        if (this.nextScheduledFlush == null) {
            this.nextScheduledFlush = ctx.executor().submit(this.flushTask);
        }
    }

    private void cancelScheduledFlush() {
        if (this.nextScheduledFlush != null) {
            this.nextScheduledFlush.cancel(false);
            this.nextScheduledFlush = null;
        }
    }
}

